/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.abyss;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.WorldGenMinable;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;
import net.tslat.aoa3.worldgen.trees.BloodtwisterTreeGenerator;
import net.tslat.aoa3.worldgen.trees.EyeHangerTreeGenerator;
import net.tslat.aoa3.worldgen.trees.EyebushTreeGenerator;
import net.tslat.aoa3.worldgen.trees.ShadowTreeGenerator;

public class AbyssBiome
extends AoABiome {
    public AbyssBiome() {
        super(AbyssBiome.getBuilder());
        this.func_203609_a(GenerationStage.Carving.AIR, AbyssBiome.func_203606_a(AoAWorldGen.Carvers.ABYSS_CAVES, (ICarverConfig)new ProbabilityConfig(0.14285715f)));
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.OCEANLESS, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.ABYSSAL_GRASS.get()).func_176223_P(), ((Block)AoABlocks.ABYSSAL_STONE.get()).func_176223_P(), ((Block)AoABlocks.ABYSSAL_STONE.get()).func_176223_P())).func_205414_c(0.0f).func_205417_d(100.0f).func_205412_a(NumberUtil.RGB(255, 0, 0)).func_205413_b(NumberUtil.RGB(255, 0, 0)).func_205421_a(0.0f).func_205420_b(0.4f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.SPOOKY};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(255, 0, 0);
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.UNDERGROUND_ORES) {
            this.doOreGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doOreGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        for (int i = 0; i < (Integer)AoAConfig.SERVER.ORES.bloodstoneVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.BLOODSTONE_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.bloodstoneMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.bloodstoneMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.ABYSSAL_STONE.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(45, 50), rand.randomNumberUpTo(16)));
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int posZ;
        int posY;
        int posX;
        int i;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (i = 0; i < 20; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ)).func_177230_c() != surfaceBlock) continue;
            world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.TUBEICLES.get()).func_176223_P(), 2);
        }
        block6: for (i = 0; i < 4; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ)).func_177230_c() != surfaceBlock) continue;
            switch (rand.randomNumberUpTo(5)) {
                case 0: 
                case 1: {
                    StructuresHandler.generateStructure("BloodPine", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block6;
                }
                case 2: 
                case 3: {
                    StructuresHandler.generateStructure("EyeShrub", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block6;
                }
                case 4: {
                    StructuresHandler.generateStructure("BloodSpikes", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        block13: for (int i = 0; i < 2; ++i) {
            switch (rand.randomNumberUpTo(11)) {
                case 0: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX, posZ, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)).func_177230_c() != surfaceBlock) continue block13;
                    StructuresHandler.generateStructure("TentacleTree1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block13;
                }
                case 1: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX + 1, posZ + 1, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) continue block13;
                    StructuresHandler.generateStructure("TentacleTree2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block13;
                }
                case 2: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX, posZ, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)).func_177230_c() != surfaceBlock) continue block13;
                    StructuresHandler.generateStructure("TentacleTree3", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block13;
                }
                case 3: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX + 2, posZ + 1, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) continue block13;
                    StructuresHandler.generateStructure("TentacleTree4", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block13;
                }
                case 4: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX, posZ + 1, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) continue block13;
                    StructuresHandler.generateStructure("TentacleTree5", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block13;
                }
                case 5: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX, posZ + 1, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) continue block13;
                    StructuresHandler.generateStructure("TentacleTree6", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block13;
                }
                case 6: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX, posZ, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)).func_177230_c() != surfaceBlock) continue block13;
                    StructuresHandler.generateStructure("TentacleTree7", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block13;
                }
                case 7: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX + 3, posZ + 3, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)).func_177230_c() != surfaceBlock) continue block13;
                    new BloodtwisterTreeGenerator(null).generate(world, rand.source(), pos.func_177982_a(3, 0, 3));
                    continue block13;
                }
                case 8: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX + 5, posZ + 5, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 5)).func_177230_c() != surfaceBlock) continue block13;
                    new ShadowTreeGenerator(null).generate(world, rand.source(), pos.func_177982_a(5, 0, 5));
                    continue block13;
                }
                case 9: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX + 3, posZ + 3, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)).func_177230_c() != surfaceBlock) continue block13;
                    new EyebushTreeGenerator(null).generate(world, rand.source(), pos.func_177982_a(3, 0, 3));
                    continue block13;
                }
                case 10: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX + 3, posZ + 3, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)).func_177230_c() != surfaceBlock) continue block13;
                    new EyeHangerTreeGenerator(null).generate(world, rand.source(), pos.func_177982_a(3, 0, 3));
                }
            }
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int z;
        int y;
        int x;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.illusionTreeSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(11);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 9, (y = chunkGenerator.func_222529_a(x + 9, (z = basePos.func_177952_p() + rand.randomNumberUpTo(10)) + 9, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 9)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("IllusionTree", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.jaweHutSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 5, (y = chunkGenerator.func_222529_a(x + 5, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 5, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 5)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("JaweHut", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.fleshTempleSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x, (y = chunkGenerator.func_222529_a(x, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 6, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 6)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("FleshTemple", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.abyssalLottoHutSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 2, (y = chunkGenerator.func_222529_a(x + 2, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 2, Heightmap.Type.WORLD_SURFACE_WG) + 20) + 3, z + 2)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("AbyssalLottoHut", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.shadowlordPlatformSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 2, y = chunkGenerator.func_222529_a(x + 2, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 2, Heightmap.Type.WORLD_SURFACE_WG) + 5 + rand.randomNumberUpTo(5), z + 2)).func_185904_a().func_76222_j()) {
            StructuresHandler.generateStructure("ShadowlordPlatform", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
        if (!(!rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.eyeBulbGrottoSpawnChance.get()) || world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 1, (y = chunkGenerator.func_222529_a(x + 1, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 1, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 1)).func_177230_c() != surfaceBlock || world.func_175623_d(pos.func_177978_c()) || world.func_175623_d(pos.func_177968_d()) || world.func_175623_d(pos.func_177974_f()) || world.func_175623_d(pos.func_177976_e()))) {
            StructuresHandler.generateStructure("EyeBulbGrotto", world, rand.source(), (BlockPos)pos.func_181079_c(x, y - 1, z));
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.witherRuneShrineSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c(x = basePos.func_177958_n() + rand.randomNumberUpTo(16), y = chunkGenerator.func_222529_a(x + 3, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 3, Heightmap.Type.WORLD_SURFACE_WG) + 12, z)).func_177230_c() == Blocks.field_150350_a) {
            StructuresHandler.generateStructure("WitherRuneShrine", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
    }
}

