/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.barathos;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.WorldGenMinable;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;
import net.tslat.aoa3.worldgen.surfacebuilder.config.TieredSurfaceBuilderConfig;

public class BarathosBiome
extends AoABiome {
    public BarathosBiome() {
        super(BarathosBiome.getBuilder());
        this.func_203609_a(GenerationStage.Carving.AIR, BarathosBiome.func_203606_a(AoAWorldGen.Carvers.BARATHOS_CAVES, (ICarverConfig)new ProbabilityConfig(1.0f)));
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.TIERED, (ISurfaceBuilderConfig)new TieredSurfaceBuilderConfig(((Block)AoABlocks.BARON_GROUND.get()).func_176223_P(), ((Block)AoABlocks.BARON_STONE.get()).func_176223_P(), new Tuple((Object)((Block)AoABlocks.HELLSTONE.get()).func_176223_P(), (Object)25), new Tuple((Object)((Block)AoABlocks.BARON_STONE.get()).func_176223_P(), (Object)255))).func_205414_c(2.0f).func_205417_d(500.0f).func_205412_a(NumberUtil.RGB(255, 255, 255)).func_205413_b(NumberUtil.RGB(255, 255, 255)).func_205421_a(0.0f).func_205420_b(0.35f).func_205419_a(Biome.Category.MESA);
        return builder;
    }

    public void func_206854_a(Random rand, IChunk chunk, int x, int z, int topBlock, double noise, BlockState fillerBlock, BlockState defaultFluid, int seaLevel, long seed) {
        super.func_206854_a(rand, chunk, x, z, topBlock, noise, fillerBlock, defaultFluid, seaLevel, seed);
        ChunkPos chunkPos = chunk.func_76632_l();
        ((SharedSeedRandom)rand).func_202424_a(seed, chunkPos.field_77276_a, chunkPos.field_77276_a);
        if (x - chunkPos.func_180334_c() == 13 + rand.nextInt(4) || z - chunkPos.func_180333_d() == 13 + rand.nextInt(4)) {
            chunk.func_177436_a(new BlockPos(x, topBlock - 1, z), fillerBlock, false);
        }
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DRY};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(255, 200, 0);
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.UNDERGROUND_ORES) {
            this.doOreGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doMiscGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doOreGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int i;
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.varsiumVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.VARSIUM_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.varsiumMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.varsiumMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.BARON_STONE.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(25, 63), rand.randomNumberUpTo(16)));
        }
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.baronyteVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.BARONYTE_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.baronyteMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.baronyteMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.BARON_STONE.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(25, 35), rand.randomNumberUpTo(16)));
        }
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.blaziumVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.BLAZIUM_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.blaziumMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.blaziumMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.HELLSTONE.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberUpTo(20), rand.randomNumberUpTo(16)));
        }
    }

    protected void doMiscGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block testBlock;
        int posY;
        int posZ;
        int posX;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        Block subsurfaceBlock = biome.func_205401_q().func_215452_a().func_204109_b().func_177230_c();
        switch (rand.randomNumberUpTo(4)) {
            case 0: {
                posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                posY = chunkGenerator.func_222529_a(posX + 3, posZ + 2, Heightmap.Type.WORLD_SURFACE_WG);
                testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 2)).func_177230_c();
                if (testBlock != surfaceBlock && testBlock != subsurfaceBlock) break;
                StructuresHandler.generateStructure("SmallBaronRock1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 1: {
                posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                posY = chunkGenerator.func_222529_a(posX + 1, posZ + 3, Heightmap.Type.WORLD_SURFACE_WG);
                testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 3)).func_177230_c();
                if (testBlock != surfaceBlock && testBlock != subsurfaceBlock) break;
                StructuresHandler.generateStructure("SmallBaronRock2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 2: {
                posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                posY = chunkGenerator.func_222529_a(posX + 2, posZ + 1, Heightmap.Type.WORLD_SURFACE_WG);
                testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 1)).func_177230_c();
                if (testBlock != surfaceBlock && testBlock != subsurfaceBlock) break;
                StructuresHandler.generateStructure("SmallBaronRock3", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 3: {
                posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                posY = chunkGenerator.func_222529_a(posX + 1, posZ + 1, Heightmap.Type.WORLD_SURFACE_WG);
                testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)).func_177230_c();
                if (testBlock != surfaceBlock && testBlock != subsurfaceBlock) break;
                StructuresHandler.generateStructure("SmallBaronRock4", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
            }
        }
        if (rand.oneInNChance(15)) {
            switch (rand.randomNumberUpTo(8)) {
                case 0: {
                    posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    posY = chunkGenerator.func_222529_a(posX + 4, posZ + 5, Heightmap.Type.WORLD_SURFACE_WG);
                    testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 5)).func_177230_c();
                    if (testBlock != surfaceBlock && testBlock != subsurfaceBlock) break;
                    StructuresHandler.generateStructure("BaronRock1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                    break;
                }
                case 1: {
                    posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    posY = chunkGenerator.func_222529_a(posX + 5, posZ + 5, Heightmap.Type.WORLD_SURFACE_WG);
                    testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 5)).func_177230_c();
                    if (testBlock != surfaceBlock && testBlock != subsurfaceBlock) break;
                    StructuresHandler.generateStructure("BaronRock2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                    break;
                }
                case 2: {
                    posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    posY = chunkGenerator.func_222529_a(posX + 4, posZ + 4, Heightmap.Type.WORLD_SURFACE_WG);
                    testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 4)).func_177230_c();
                    if (testBlock != surfaceBlock && testBlock != subsurfaceBlock) break;
                    StructuresHandler.generateStructure("BaronRock3", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                    break;
                }
                case 3: {
                    posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    posY = chunkGenerator.func_222529_a(posX + 5, posZ + 5, Heightmap.Type.WORLD_SURFACE_WG);
                    testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 5)).func_177230_c();
                    if (testBlock != surfaceBlock && testBlock != subsurfaceBlock) break;
                    StructuresHandler.generateStructure("BaronRock4", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                    break;
                }
                case 4: {
                    posX = basePos.func_177958_n() + rand.randomNumberUpTo(15);
                    posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    posY = chunkGenerator.func_222529_a(posX + 5, posZ + 5, Heightmap.Type.WORLD_SURFACE_WG);
                    testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 5)).func_177230_c();
                    if (testBlock != surfaceBlock && testBlock != subsurfaceBlock) break;
                    StructuresHandler.generateStructure("BaronRock5", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                    break;
                }
                case 5: {
                    posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    posY = chunkGenerator.func_222529_a(posX + 7, posZ + 4, Heightmap.Type.WORLD_SURFACE_WG);
                    testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 7, posY - 1, posZ + 4)).func_177230_c();
                    if (testBlock != surfaceBlock && testBlock != subsurfaceBlock) break;
                    StructuresHandler.generateStructure("BaronRock6", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                    break;
                }
                case 6: {
                    posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    posY = chunkGenerator.func_222529_a(posX + 4, posZ + 4, Heightmap.Type.WORLD_SURFACE_WG);
                    testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 4)).func_177230_c();
                    if (testBlock != surfaceBlock && testBlock != subsurfaceBlock) break;
                    StructuresHandler.generateStructure("BaronRock7", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                    break;
                }
                case 7: {
                    posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    posY = chunkGenerator.func_222529_a(posX + 4, posZ + 5, Heightmap.Type.WORLD_SURFACE_WG);
                    testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 5)).func_177230_c();
                    if (testBlock != surfaceBlock && testBlock != subsurfaceBlock) break;
                    StructuresHandler.generateStructure("BaronRock8", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                }
            }
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int z;
        int x;
        int y;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        Block subsurfaceBlock = biome.func_205401_q().func_215452_a().func_204109_b().func_177230_c();
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.baronessArenaSpawnChance.get())) {
            y = chunkGenerator.func_222529_a(basePos.func_177958_n() + 15, basePos.func_177952_p() + 15, Heightmap.Type.WORLD_SURFACE_WG);
            Block testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + 15, y - 1, basePos.func_177952_p() + 15)).func_177230_c();
            if (testBlock == surfaceBlock || testBlock == subsurfaceBlock) {
                StructuresHandler.generateStructure("BaronessArena", world, rand.source(), (BlockPos)pos.func_181079_c(basePos.func_177958_n(), y, basePos.func_177952_p()));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.hiveNestSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(10);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x, (y = chunkGenerator.func_222529_a(x + 9, (z = basePos.func_177952_p() + rand.randomNumberUpTo(10)) + 11, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("HiveNest", world, rand.source(), (BlockPos)pos);
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.baronCastleSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(15);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x, (y = chunkGenerator.func_222529_a(x + 7, (z = basePos.func_177952_p() + rand.randomNumberUpTo(14)) + 15, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("BaronCastle", world, rand.source(), (BlockPos)pos);
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.baronessHouseSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(10)) + 10, (y = chunkGenerator.func_222529_a(x + 10, (z = basePos.func_177952_p() + rand.randomNumberUpTo(11)) + 9, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 9)).func_177230_c() == surfaceBlock) {
            StructuresHandler.generateStructure("BaronessHouse", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.powerRuneShrineSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            y = chunkGenerator.func_222529_a(x + 3, z + 3, Heightmap.Type.WORLD_SURFACE_WG) + 20;
            StructuresHandler.generateStructure("PowerRuneShrine", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
    }
}

