/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.candyland;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;

public class CandylandBiome
extends AoABiome {
    public CandylandBiome() {
        super(CandylandBiome.getBuilder());
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(SurfaceBuilder.field_215396_G, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.CANDIED_GRASS.get()).func_176223_P(), ((Block)AoABlocks.CANDIED_DIRT.get()).func_176223_P(), ((Block)AoABlocks.CANDIED_DIRT.get()).func_176223_P())).func_205414_c(0.4f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(153, 51, 51)).func_205413_b(NumberUtil.RGB(153, 51, 51)).func_205421_a(0.0f).func_205420_b(0.1f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(255, 255, 0);
    }

    public void func_206854_a(Random rand, IChunk chunk, int x, int z, int startHeight, double noise, BlockState fillerBlock, BlockState oceanFluid, int seaLevel, long seed) {
        super.func_206854_a(rand, chunk, x, z, startHeight, noise, fillerBlock, oceanFluid, seaLevel, seed);
        chunk.func_177436_a(new BlockPos(x, 1, z), ((Block)AoABlocks.DIMENSIONAL_FABRIC.get()).func_176223_P(), false);
        chunk.func_177436_a(new BlockPos(x, 0, z), ((Block)AoABlocks.DIMENSIONAL_FABRIC.get()).func_176223_P(), false);
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doMiscGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int posZ;
        int posY;
        int posX;
        int i;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        block7: for (i = 0; i < 10; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ)).func_177230_c() != surfaceBlock || world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY, posZ)).func_177230_c() != Blocks.field_150350_a) continue;
            switch (rand.randomNumberUpTo(5)) {
                case 0: {
                    StructuresHandler.generateStructure("CandyTube", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block7;
                }
                case 1: {
                    StructuresHandler.generateStructure("CandyStack", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block7;
                }
                case 2: {
                    StructuresHandler.generateStructure("GreenPeppermintStack", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block7;
                }
                case 3: {
                    StructuresHandler.generateStructure("RedPeppermintStack", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block7;
                }
                case 4: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.CANDYCANE.get()).func_176223_P(), 2);
                }
            }
        }
        for (i = 0; i < 100; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ)).func_177230_c() != surfaceBlock || world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY, posZ)).func_177230_c() != Blocks.field_150350_a) continue;
            if (rand.fiftyFifty()) {
                world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.PINK_CANDY_GRASS.get()).func_176223_P(), 2);
                continue;
            }
            world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.BLUE_CANDY_GRASS.get()).func_176223_P(), 2);
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        switch (rand.randomNumberUpTo(12)) {
            case 0: {
                int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                int posY = chunkGenerator.func_222529_a(posX + 1, posZ + 6, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 6)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("CandyCane1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 1: {
                int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                int posY = chunkGenerator.func_222529_a(posX + 4, posZ + 1, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 6, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("CandyCane2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 2: {
                int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                int posY = chunkGenerator.func_222529_a(posX + 1, posZ + 1, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("CandyCane3", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 3: {
                int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                int posY = chunkGenerator.func_222529_a(posX + 1, posZ + 1, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("CandyCane4", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 4: {
                int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                int posY = chunkGenerator.func_222529_a(posX + 2, posZ + 2, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("CottonCandyTree1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 5: {
                int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                int posY = chunkGenerator.func_222529_a(posX + 2, posZ + 2, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("CottonCandyTree2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 6: {
                int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                int posY = chunkGenerator.func_222529_a(posX + 2, posZ + 2, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("AquaCottonCandyTree1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 7: {
                int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                int posY = chunkGenerator.func_222529_a(posX + 2, posZ + 2, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("AquaCottonCandyTree2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 8: {
                int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                int posY = chunkGenerator.func_222529_a(posX + 2, posZ + 2, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("Lollypop1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 9: {
                int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                int posY = chunkGenerator.func_222529_a(posX + 2, posZ + 2, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("Lollypop2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 10: {
                int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                int posY = chunkGenerator.func_222529_a(posX + 4, posZ, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("SwirlPop1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 11: {
                int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                int posY = chunkGenerator.func_222529_a(posX, posZ + 4, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 4)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("SwirlPop2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
            }
        }
    }

    protected void doMiscGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        if (rand.oneInNChance(3)) {
            switch (rand.randomNumberUpTo(6)) {
                case 0: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX, posZ + 1, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) break;
                    StructuresHandler.generateStructure("ChocolateBar1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 1: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX + 1, posZ, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ)).func_177230_c() != surfaceBlock) break;
                    StructuresHandler.generateStructure("ChocolateBar2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 2: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX, posZ + 1, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) break;
                    StructuresHandler.generateStructure("WhiteChocolateBar1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 3: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX + 1, posZ, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ)).func_177230_c() != surfaceBlock) break;
                    StructuresHandler.generateStructure("WhiteChocolateBar2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 4: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX, posZ + 1, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) break;
                    StructuresHandler.generateStructure("DarkChocolateBar1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 5: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX + 1, posZ, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ)).func_177230_c() != surfaceBlock) break;
                    StructuresHandler.generateStructure("DarkChocolateBar2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int z;
        int y;
        int x;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.cottonCandyTowerSpawnChance.get())) {
            int z2;
            int y2;
            int x2 = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x2 + 4, (y2 = chunkGenerator.func_222529_a(x2 + 4, (z2 = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 4, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z2 + 4)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("CottonCandyTower", world, rand.source(), (BlockPos)pos.func_181079_c(x2, y2, z2));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.gingerbreadHouseSpawnChance.get())) {
            int z3;
            int y3;
            int x3 = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x3 + 5, (y3 = chunkGenerator.func_222529_a(x3 + 5, (z3 = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 5, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z3 + 5)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("GingerbreadHouse", world, rand.source(), (BlockPos)pos.func_181079_c(x3, y3, z3));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.gingerbirdAviarySpawnChance.get())) {
            int z4;
            int y4;
            int x4 = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x4 + 5, (y4 = chunkGenerator.func_222529_a(x4 + 5, (z4 = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 5, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z4 + 5)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("GingerbirdAviary", world, rand.source(), (BlockPos)pos.func_181079_c(x4, y4, z4));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.candyLottoPlatformSpawnChance.get())) {
            int z5;
            int y5;
            int x5 = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x5 + 6, (y5 = chunkGenerator.func_222529_a(x5 + 6, (z5 = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 6, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z5 + 6)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("CandyLottoPlatform", world, rand.source(), (BlockPos)pos.func_181079_c(x5, y5, z5));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.infestedCandyCaneSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 6, (y = chunkGenerator.func_222529_a(x + 6, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 6, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 6)).func_177230_c() == surfaceBlock) {
            StructuresHandler.generateStructure("InfestedCandyCane", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
    }
}

