/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.celeve;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;
import net.tslat.aoa3.worldgen.trees.CelevusTreeGenerator;

public class CeleveBiome
extends AoABiome {
    public CeleveBiome() {
        super(CeleveBiome.getBuilder());
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.OCEANLESS, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.CELEVIAN_GRASS.get()).func_176223_P(), ((Block)AoABlocks.CELEVIAN_DIRT.get()).func_176223_P(), ((Block)AoABlocks.CELEVIAN_DIRT.get()).func_176223_P())).func_205414_c(0.5f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(0, 0, 255)).func_205413_b(NumberUtil.RGB(0, 0, 255)).func_205421_a(0.1f).func_205420_b(0.1f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.VOID};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(0, 255, 0);
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        block7: for (int i = 0; i < 60; ++i) {
            int posZ;
            int posY;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ)).func_177230_c() != surfaceBlock) continue;
            switch (rand.randomNumberUpTo(5)) {
                case 0: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.BLUE_CELEVIANS.get()).func_176223_P(), 2);
                    continue block7;
                }
                case 1: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.RED_CELEVIANS.get()).func_176223_P(), 2);
                    continue block7;
                }
                case 2: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.WHITE_CELEVIANS.get()).func_176223_P(), 2);
                    continue block7;
                }
                case 3: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.PURPLE_CELEVIANS.get()).func_176223_P(), 2);
                    continue block7;
                }
                case 4: {
                    StructuresHandler.generateStructure("Celebulb", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (int i = 0; i < 2; ++i) {
            int posZ;
            int posY;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, (posY = chunkGenerator.func_222529_a(posX + 2, (posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 2, Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ + 2)).func_177230_c() != surfaceBlock) continue;
            new CelevusTreeGenerator(null, null, rand.source()).generate(world, rand.source(), pos.func_177984_a());
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int y;
        int z;
        int x;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.gyroPlatformSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(11);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            y = rand.randomNumberBetween(40, 60);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x, y, z)).func_177230_c() == Blocks.field_150350_a && world.func_180495_p((BlockPos)pos.func_181079_c(x + 17, y + 7, z + 17)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("GyroPlatform", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.celevianLottoBalloonSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            y = rand.randomNumberBetween(10, 30);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 2, y, z + 2)).func_177230_c() == Blocks.field_150350_a && world.func_180495_p((BlockPos)pos.func_181079_c(x + 8, y + 17, z + 8)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("CelevianLottoBalloon", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.toyTowerSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 5, (y = chunkGenerator.func_222529_a(x + 5, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 5, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 5)).func_177230_c() == surfaceBlock) {
            StructuresHandler.generateStructure("ToyTower", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.compassRuneShrineSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            y = chunkGenerator.func_222529_a(x + 3, z + 3, Heightmap.Type.WORLD_SURFACE_WG) + 15;
            StructuresHandler.generateStructure("CompassRuneShrine", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
    }
}

