/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.creeponia;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.WorldGenMinable;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;
import net.tslat.aoa3.worldgen.surfacebuilder.config.TieredSurfaceBuilderConfig;
import net.tslat.aoa3.worldgen.trees.CreepTreeGenerator;

public class CreeponiaBiome
extends AoABiome {
    public CreeponiaBiome() {
        super(CreeponiaBiome.getBuilder());
        this.func_203609_a(GenerationStage.Carving.AIR, CreeponiaBiome.func_203606_a(AoAWorldGen.Carvers.CREEPONIA_CAVES, (ICarverConfig)new ProbabilityConfig(0.14285715f)));
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.TIERED, (ISurfaceBuilderConfig)new TieredSurfaceBuilderConfig(((Block)AoABlocks.CREEP_GRASS.get()).func_176223_P(), ((Block)AoABlocks.CREEP_DIRT.get()).func_176223_P(), new Tuple((Object)((Block)AoABlocks.PRIMED_STONE.get()).func_176223_P(), (Object)20), new Tuple((Object)((Block)AoABlocks.PRESSED_CREEP_STONE.get()).func_176223_P(), (Object)40), new Tuple((Object)((Block)AoABlocks.CREEP_STONE.get()).func_176223_P(), (Object)256))).func_205414_c(0.4f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(0, 255, 0)).func_205413_b(NumberUtil.RGB(0, 255, 0)).func_205421_a(0.0f).func_205420_b(0.25f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MAGICAL};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(255, 255, 0);
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.UNDERGROUND_ORES) {
            this.doOreGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doOreGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int i;
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.ornamyteVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.ORNAMYTE_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.ornamyteMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.ornamyteMaxOresPerVein.get() + 1), block -> block.func_177230_c() == AoABlocks.CREEP_STONE.get() || block.func_177230_c() == AoABlocks.PRIMED_STONE.get() || block.func_177230_c() == AoABlocks.PRESSED_CREEP_STONE.get()).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(3, 15), rand.randomNumberUpTo(16)));
        }
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.gemenyteVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.GEMENYTE_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.gemenyteMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.gemenyteMaxOresPerVein.get() + 1), block -> block.func_177230_c() == AoABlocks.CREEP_STONE.get() || block.func_177230_c() == AoABlocks.PRIMED_STONE.get() || block.func_177230_c() == AoABlocks.PRESSED_CREEP_STONE.get()).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(22, 37), rand.randomNumberUpTo(16)));
        }
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.jewelyteVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.JEWELYTE_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.jewelyteMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.jewelyteMaxOresPerVein.get() + 1), block -> block.func_177230_c() == AoABlocks.CREEP_STONE.get() || block.func_177230_c() == AoABlocks.PRIMED_STONE.get() || block.func_177230_c() == AoABlocks.PRESSED_CREEP_STONE.get()).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(22, 37), rand.randomNumberUpTo(16)));
        }
        for (i = 0; i < 128; ++i) {
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            int posY = rand.randomNumberBetween(2, 50);
            BlockPos blockPos = new BlockPos(posX, posY, posZ);
            Block bl = world.func_180495_p(blockPos).func_177230_c();
            if (bl != AoABlocks.CREEP_STONE.get() && bl != AoABlocks.PRESSED_CREEP_STONE.get() && bl != AoABlocks.PRIMED_STONE.get()) continue;
            world.func_180501_a(blockPos, ((Block)AoABlocks.CREEP_CRYSTAL.get()).func_176223_P(), 2);
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (int i = 0; i < 60; ++i) {
            int posZ;
            int posY;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ)).func_177230_c() != surfaceBlock) continue;
            if (rand.fiftyFifty()) {
                world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.CREEP_BUSH.get()).func_176223_P(), 2);
                continue;
            }
            world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.CREEP_FLOWERS.get()).func_176223_P(), 2);
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (int i = 0; i < 7; ++i) {
            int posZ;
            int posY;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, (posY = chunkGenerator.func_222529_a(posX + 3, (posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 3, Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ + 3)).func_177230_c() != surfaceBlock) continue;
            new CreepTreeGenerator(null).generate(world, rand.source(), pos.func_177984_a());
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int z;
        int y;
        int x;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.creeperHQSpawnChance.get())) {
            int z2;
            int y2;
            int x2 = basePos.func_177958_n() + rand.randomNumberUpTo(6);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x2 + 9, (y2 = chunkGenerator.func_222529_a(x2 + 9, (z2 = basePos.func_177952_p() + rand.randomNumberUpTo(6)) + 10, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z2 + 10)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("CreeperHQ", world, rand.source(), (BlockPos)pos.func_181079_c(x2, y2, z2));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.creeponianLottoStandSpawnChance.get())) {
            int z3;
            int y3;
            int x3 = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x3 + 3, (y3 = chunkGenerator.func_222529_a(x3 + 3, (z3 = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 3, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z3 + 3)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("CreeponianLottoStand", world, rand.source(), (BlockPos)pos.func_181079_c(x3, y3, z3));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.explosivesTowerSpawnChance.get())) {
            int z4;
            int y4;
            int x4 = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x4 + 3, (y4 = chunkGenerator.func_222529_a(x4 + 3, (z4 = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 3, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z4 + 3)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("ExplosivesTower", world, rand.source(), (BlockPos)pos.func_181079_c(x4, y4, z4));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.creeponiaBankSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 6, (y = chunkGenerator.func_222529_a(x + 6, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 6, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 6)).func_177230_c() == surfaceBlock) {
            StructuresHandler.generateStructure("CreeponiaBank", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
    }
}

