/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.crystevia;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.WorldGenMinable;
import net.tslat.aoa3.worldgen.structures.AoAStructure;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;

public class CrysteviaBiome
extends AoABiome {
    public CrysteviaBiome() {
        super(CrysteviaBiome.getBuilder());
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.OCEANLESS, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.CRYSTALLISED_ROCK.get()).func_176223_P(), ((Block)AoABlocks.CRYSTALLISED_ROCK.get()).func_176223_P(), ((Block)AoABlocks.CRYSTALLISED_ROCK.get()).func_176223_P())).func_205414_c(0.4f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(204, 0, 102)).func_205413_b(NumberUtil.RGB(204, 0, 102)).func_205421_a(0.1f).func_205420_b(0.2f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.WET};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(255, 255, 0);
    }

    public void func_206854_a(Random random, IChunk chunkIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed) {
        super.func_206854_a(random, chunkIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed);
        for (int i = 0; i <= 4; ++i) {
            chunkIn.func_177436_a(new BlockPos(x, i, z), ((Block)AoABlocks.DIMENSIONAL_FABRIC.get()).func_176223_P(), false);
            chunkIn.func_177436_a(new BlockPos(x, 127 - i, z), ((Block)AoABlocks.DIMENSIONAL_FABRIC.get()).func_176223_P(), false);
        }
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.UNDERGROUND_ORES) {
            this.doOreGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doMiscGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doOreGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int i;
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.blueGemstoneVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.BLUE_GEMSTONE_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.blueGemstoneMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.blueGemstoneMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.CRYSTALLISED_ROCK.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(10, 110), rand.randomNumberUpTo(16)));
        }
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.greenGemstoneVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.GREEN_GEMSTONE_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.greenGemstoneMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.greenGemstoneMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.CRYSTALLISED_ROCK.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(10, 110), rand.randomNumberUpTo(16)));
        }
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.redGemstoneVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.RED_GEMSTONE_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.redGemstoneMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.redGemstoneMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.CRYSTALLISED_ROCK.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(10, 110), rand.randomNumberUpTo(16)));
        }
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.purpleGemstoneVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.PURPLE_GEMSTONE_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.purpleGemstoneMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.purpleGemstoneMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.CRYSTALLISED_ROCK.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(10, 110), rand.randomNumberUpTo(16)));
        }
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.whiteGemstoneVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.WHITE_GEMSTONE_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.whiteGemstoneMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.whiteGemstoneMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.CRYSTALLISED_ROCK.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(10, 110), rand.randomNumberUpTo(16)));
        }
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.yellowGemstoneVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.YELLOW_GEMSTONE_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.yellowGemstoneMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.yellowGemstoneMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.CRYSTALLISED_ROCK.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(10, 110), rand.randomNumberUpTo(16)));
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        block8: for (int i = 0; i < 15; ++i) {
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            int posY = this.findNextSuitableYCoord(world, posX, rand.randomNumberBetween(20, 100), posZ);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)).func_177230_c() != surfaceBlock || posY <= 0) continue;
            switch (rand.randomNumberUpTo(6)) {
                case 0: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.BLUE_CRYSTAL_PLANT.get()).func_176223_P(), 2);
                    continue block8;
                }
                case 1: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.GREEN_CRYSTAL_PLANT.get()).func_176223_P(), 2);
                    continue block8;
                }
                case 2: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.PURPLE_CRYSTAL_PLANT.get()).func_176223_P(), 2);
                    continue block8;
                }
                case 3: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.RED_CRYSTAL_PLANT.get()).func_176223_P(), 2);
                    continue block8;
                }
                case 4: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.WHITE_CRYSTAL_PLANT.get()).func_176223_P(), 2);
                    continue block8;
                }
                case 5: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.YELLOW_CRYSTAL_PLANT.get()).func_176223_P(), 2);
                }
            }
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        block15: for (int i = 0; i < rand.randomNumberUpTo(6); ++i) {
            String colour;
            switch (rand.randomNumberUpTo(6)) {
                case 0: {
                    colour = "Blue";
                    break;
                }
                case 1: {
                    colour = "Green";
                    break;
                }
                case 2: {
                    colour = "Purple";
                    break;
                }
                case 3: {
                    colour = "Red";
                    break;
                }
                case 4: {
                    colour = "White";
                    break;
                }
                default: {
                    colour = "Yellow";
                }
            }
            switch (rand.randomNumberUpTo(6)) {
                case 0: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = this.findNextSuitableYCoord(world, posX + 1, rand.randomNumberBetween(20, 100), posZ + 1);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) continue block15;
                    StructuresHandler.generateStructure(colour + "CrystalChunk1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block15;
                }
                case 1: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = this.findNextSuitableYCoord(world, posX, rand.randomNumberBetween(20, 100), posZ);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)).func_177230_c() != surfaceBlock) continue block15;
                    StructuresHandler.generateStructure(colour + "CrystalChunk2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block15;
                }
                case 2: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = this.findNextSuitableYCoord(world, posX + 1, rand.randomNumberBetween(20, 100), posZ + 1);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) continue block15;
                    StructuresHandler.generateStructure(colour + "CrystalChunk3", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block15;
                }
                case 3: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = this.findNextSuitableYCoord(world, posX, rand.randomNumberBetween(20, 100), posZ);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)).func_177230_c() != surfaceBlock) continue block15;
                    StructuresHandler.generateStructure(colour + "CrystalChunk4", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block15;
                }
                case 4: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = this.findNextSuitableYCoord(world, posX + 1, rand.randomNumberBetween(20, 100), posZ + 1);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) continue block15;
                    StructuresHandler.generateStructure(colour + "CrystalChunk5", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block15;
                }
                case 5: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = this.findNextSuitableYCoord(world, posX, rand.randomNumberBetween(20, 100), posZ);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)).func_177230_c() != surfaceBlock) continue block15;
                    StructuresHandler.generateStructure(colour + "CrystalChunk6", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
        }
    }

    protected void doMiscGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        if (rand.oneInNChance(10)) {
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            int posY = rand.randomNumberBetween(10, 120);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY, posZ)).func_177230_c() == surfaceBlock) {
                world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), Blocks.field_150355_j.func_176223_P(), 2);
                while (posY > 2 && world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)).func_177230_c() != Blocks.field_150350_a) {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY - 1, posZ), Blocks.field_150350_a.func_176223_P(), 2);
                    --posY;
                }
            }
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int y;
        int z;
        int x;
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.crystalBuildingSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            y = rand.randomNumberBetween(20, 100);
            switch (rand.randomNumberUpTo(4)) {
                case 0: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 5, y + 3, z + 5)).func_177230_c() != Blocks.field_150350_a) break;
                    StructuresHandler.generateStructure("CrystalExtensionStation", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
                    break;
                }
                case 1: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 4, y + 3, z + 4)).func_177230_c() != Blocks.field_150350_a) break;
                    StructuresHandler.generateStructure("CrystalLottoOverlook", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
                    break;
                }
                case 2: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 3, y + 3, z + 3)).func_177230_c() != Blocks.field_150350_a) break;
                    StructuresHandler.generateStructure("PowerStation", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
                    break;
                }
                case 3: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 4, y + 1, z + 4)).func_177230_c() != Blocks.field_150350_a) break;
                    StructuresHandler.generateStructure("CrystalTradingPost", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
                }
            }
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.crystalTransferHutSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            y = rand.randomNumberBetween(20, 100);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 5, y, z + 5)).func_177230_c() == Blocks.field_150350_a && world.func_180495_p((BlockPos)pos.func_181079_c(x + 5, y + 9, z + 5)).func_177230_c() == Blocks.field_150350_a) {
                AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
                switch (rand.randomNumberUpTo(6)) {
                    case 0: {
                        structure = StructuresHandler.getStructure("BlueCrystalTransferHut");
                        break;
                    }
                    case 1: {
                        structure = StructuresHandler.getStructure("GreenCrystalTransferHut");
                        break;
                    }
                    case 2: {
                        structure = StructuresHandler.getStructure("PurpleCrystalTransferHut");
                        break;
                    }
                    case 3: {
                        structure = StructuresHandler.getStructure("RedCrystalTransferHut");
                        break;
                    }
                    case 4: {
                        structure = StructuresHandler.getStructure("WhiteCrystalTransferHut");
                        break;
                    }
                    case 5: {
                        structure = StructuresHandler.getStructure("YellowCrystalTransferHut");
                    }
                }
                StructuresHandler.generateStructure(structure, world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        }
    }

    private int findNextSuitableYCoord(IWorld world, int posX, int posY, int posZ) {
        BlockPos.Mutable testPos = new BlockPos.Mutable(posX, posY, posZ);
        if (world.func_180495_p((BlockPos)testPos).func_177230_c() == Blocks.field_150350_a) {
            while (testPos.func_177956_o() >= 2 && world.func_180495_p((BlockPos)testPos.func_189536_c(Direction.DOWN)).func_177230_c() == Blocks.field_150350_a) {
            }
            Block rock = (Block)AoABlocks.CRYSTALLISED_ROCK.get();
            if (world.func_180495_p((BlockPos)testPos).func_177230_c() == rock) {
                return testPos.func_177956_o() + 1;
            }
        }
        return 0;
    }
}

