/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.deeplands;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.WorldGenMinable;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;

public class DeeplandsBiome
extends AoABiome {
    public DeeplandsBiome() {
        super(DeeplandsBiome.getBuilder());
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.OCEANLESS, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.DENSE_STONE.get()).func_176223_P(), ((Block)AoABlocks.DENSE_STONE.get()).func_176223_P(), ((Block)AoABlocks.DENSE_STONE.get()).func_176223_P())).func_205414_c(0.0f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(200, 200, 200)).func_205413_b(NumberUtil.RGB(200, 200, 200)).func_205421_a(0.0f).func_205420_b(0.0f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.SPARSE};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(0, 0, 0);
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.UNDERGROUND_ORES) {
            this.doOreGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doMiscGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doOreGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int i;
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.chargedRuniumVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.CHARGED_RUNIUM_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.chargedRuniumMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.chargedRuniumMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.DENSE_STONE.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(70, 115), rand.randomNumberUpTo(16)));
        }
        for (i = 0; i < 4; ++i) {
            new WorldGenMinable(((Block)AoABlocks.DEEP_CASE.get()).func_176223_P(), 5, (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.DENSE_STONE.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(70, 115), rand.randomNumberUpTo(16)));
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        for (int i = 0; i < 30; ++i) {
            int posZ;
            int posY;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY = 20, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16))).func_177230_c() != Blocks.field_150350_a) continue;
            if (rand.fiftyFifty()) {
                world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.DEEP_GRASS.get()).func_176223_P(), 2);
                continue;
            }
            world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.DEEP_BLOOMS.get()).func_176223_P(), 2);
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        if (rand.oneInNChance(3)) {
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            int posY = 20;
            if (rand.fiftyFifty()) {
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY, posZ + 3)).func_177230_c() == Blocks.field_150350_a) {
                    StructuresHandler.generateStructure("Deepshroom1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            } else if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY, posZ + 4)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("Deepshroom2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
            }
        }
    }

    protected void doMiscGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int posY;
        int posZ;
        int posX;
        world.func_180501_a((BlockPos)pos.func_181079_c(basePos.func_177958_n() + rand.randomNumberUpTo(15), 19, basePos.func_177952_p() + rand.randomNumberUpTo(15)), ((Block)AoABlocks.DEEP_CRYSTAL.get()).func_176223_P(), 2);
        if (rand.oneInNChance(25)) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            posY = rand.randomNumberBetween(19, 21);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, 20, posZ)).func_177230_c() == Blocks.field_150350_a) {
                if (rand.fiftyFifty()) {
                    StructuresHandler.generateStructure("DeepSpire1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                } else {
                    StructuresHandler.generateStructure("DeepSpire2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
        }
        if (rand.oneInNChance(6)) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            posY = 20;
            switch (rand.randomNumberUpTo(3)) {
                case 0: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 6, posY, posZ + 6)).func_177230_c() != Blocks.field_150350_a) break;
                    StructuresHandler.generateStructure("FossilisedRibs1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 1: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 6, posY, posZ + 6)).func_177230_c() != Blocks.field_150350_a) break;
                    StructuresHandler.generateStructure("FossilisedRibs2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 2: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 7, posY, posZ + 7)).func_177230_c() != Blocks.field_150350_a) break;
                    StructuresHandler.generateStructure("BoneCircle", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int z;
        int y;
        int x;
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.arocknidCaveSpawnChance.get())) {
            int z2;
            int y2;
            int x2 = basePos.func_177958_n() + rand.randomNumberUpTo(15);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x2 + 7, y2 = 20, (z2 = basePos.func_177952_p() + rand.randomNumberUpTo(15)) + 7)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("ArocknidCave", world, rand.source(), (BlockPos)pos.func_181079_c(x2, y2, z2));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.chargingStationSpawnChance.get())) {
            int z3;
            int y3;
            int x3 = basePos.func_177958_n() + rand.randomNumberUpTo(15);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x3 + 7, y3 = 20, (z3 = basePos.func_177952_p() + rand.randomNumberUpTo(15)) + 7)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("ChargingStation", world, rand.source(), (BlockPos)pos.func_181079_c(x3, y3, z3));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.krorPillarsSpawnChance.get())) {
            int z4;
            int y4;
            int x4 = basePos.func_177958_n() + rand.randomNumberUpTo(15);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x4 + 7, y4 = 20, z4 = basePos.func_177952_p() + rand.randomNumberUpTo(16))).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("KrorPillars", world, rand.source(), (BlockPos)pos.func_181079_c(x4, y4, z4));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.deepLottoShelterSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 9, y = 20, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 9)).func_177230_c() == Blocks.field_150350_a) {
            StructuresHandler.generateStructure("DeepLottoShelter", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
    }
}

