/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.dustopia;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;
import net.tslat.aoa3.worldgen.trees.DawnwoodTreeGenerator;

public class DustopiaBiome
extends AoABiome {
    public DustopiaBiome() {
        super(DustopiaBiome.getBuilder());
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.OCEANLESS, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.FADED_GRASS.get()).func_176223_P(), ((Block)AoABlocks.BLACKENED_SOIL.get()).func_176223_P(), ((Block)AoABlocks.DARKENED_ROCK.get()).func_176223_P())).func_205414_c(0.25f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(0, 0, 0)).func_205413_b(NumberUtil.RGB(0, 0, 0)).func_205421_a(0.0f).func_205420_b(0.25f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.FOREST};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(0, 0, 0);
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doMiscGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int posZ;
        int posY;
        int posX;
        int i;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (i = 0; i < 8; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ)).func_177230_c() != surfaceBlock) continue;
            if (rand.fiftyFifty()) {
                world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.DAWN_BUSH.get()).func_176223_P(), 2);
                continue;
            }
            world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.DAWN_FLOWER.get()).func_176223_P(), 2);
        }
        for (i = 0; i < 25; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ)).func_177230_c() != surfaceBlock) continue;
            world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.DAWN_GRASS.get()).func_176223_P(), 2);
        }
    }

    protected void doMiscGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        if (rand.oneInNChance(5)) {
            switch (rand.randomNumberUpTo(3)) {
                case 0: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX + 2, posZ + 2, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)).func_177230_c() != surfaceBlock) break;
                    StructuresHandler.generateStructure("DawnCage1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 1: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX + 1, posZ + 5, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 5)).func_177230_c() != surfaceBlock) break;
                    StructuresHandler.generateStructure("DawnCage2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 2: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX + 5, posZ + 1, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) break;
                    StructuresHandler.generateStructure("DawnCage3", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (int i = 0; i < 5; ++i) {
            int posZ;
            int posY;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, (posY = chunkGenerator.func_222529_a(posX + 3, (posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 3, Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ + 3)).func_177230_c() != surfaceBlock) continue;
            new DawnwoodTreeGenerator(null).generate(world, rand.source(), pos.func_177984_a());
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int z;
        int y;
        int x;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.primordialShrineSpawnChance.get())) {
            int z2;
            int y2;
            int x2 = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x2 + 2, (y2 = chunkGenerator.func_222529_a(x2, z2 = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) - 1, z2 + 5)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("PrimordialShrine", world, rand.source(), (BlockPos)pos.func_181079_c(x2, y2, z2));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.crusiliskCaveSpawnChance.get())) {
            int z3;
            int y3;
            int x3 = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x3 + 5, (y3 = chunkGenerator.func_222529_a(x3 + 5, (z3 = basePos.func_177952_p() + rand.randomNumberUpTo(10)) + 13, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z3 + 13)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("CrusiliskCave", world, rand.source(), (BlockPos)pos.func_181079_c(x3, y3 - 1, z3));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.merkyreTowerSpawnChance.get())) {
            int z4;
            int y4;
            int x4 = basePos.func_177958_n() + rand.randomNumberUpTo(15);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x4 + 7, (y4 = chunkGenerator.func_222529_a(x4 + 7, (z4 = basePos.func_177952_p() + rand.randomNumberUpTo(15)) + 9, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z4 + 9)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("MerkyreTower", world, rand.source(), (BlockPos)pos.func_181079_c(x4, y4, z4));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.arkzyneOutpostSpawnChance.get())) {
            int z5;
            int y5;
            int x5 = basePos.func_177958_n() + rand.randomNumberUpTo(15);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x5 + 7, (y5 = chunkGenerator.func_222529_a(x5 + 7, (z5 = basePos.func_177952_p() + rand.randomNumberUpTo(15)) + 7, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z5 + 7)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("ArkzyneOutpost", world, rand.source(), (BlockPos)pos.func_181079_c(x5, y5, z5));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.lottoCageSpawnChance.get())) {
            int z6;
            int y6;
            int x6 = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x6 + 2, (y6 = chunkGenerator.func_222529_a(x6 + 2, (z6 = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 2, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z6 + 2)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("LottoCage", world, rand.source(), (BlockPos)pos.func_181079_c(x6, y6, z6));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.dustopianVillageSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n()) + 16, (y = chunkGenerator.func_222529_a(x + 16, (z = basePos.func_177952_p() + rand.randomNumberUpTo(7)) + 11, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 17)).func_177230_c() == surfaceBlock) {
            StructuresHandler.generateStructure("DustopianVillage", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
    }
}

