/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.gardencia;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.structures.AoAStructure;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;

public class GardenciaBiome
extends AoABiome {
    public GardenciaBiome() {
        super(GardenciaBiome.getBuilder());
        this.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, AoAWorldGen.Features.BIOME_FRIENDLY_LAKE.get().func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(Blocks.field_150355_j.func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));
        this.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, AoAWorldGen.Features.BIOME_FRIENDLY_LAKE.get().func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(Blocks.field_150355_j.func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(SurfaceBuilder.field_215396_G, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.AROMATIC_GRASS.get()).func_176223_P(), ((Block)AoABlocks.AROMATIC_DIRT.get()).func_176223_P(), ((Block)AoABlocks.AROMATIC_STONE.get()).func_176223_P())).func_205414_c(0.5f).func_205417_d(0.7f).func_205412_a(NumberUtil.RGB(25, 209, 25)).func_205413_b(NumberUtil.RGB(25, 209, 25)).func_205421_a(0.0f).func_205420_b(0.3f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.WET, BiomeDictionary.Type.HILLS};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(0, 255, 0);
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        block5: for (int i = 0; i < 59; ++i) {
            int posZ;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            int posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG);
            if (posY <= 67 || world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)).func_177230_c() != surfaceBlock || world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY, posZ)).func_177230_c() != Blocks.field_150350_a) continue;
            switch (rand.randomNumberUpTo(3)) {
                case 0: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.DAILEERS.get()).func_176223_P(), 2);
                    continue block5;
                }
                case 1: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.LYLIPS.get()).func_176223_P(), 2);
                    continue block5;
                }
                case 2: {
                    StructuresHandler.generateStructure("GardenGrass", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (int i = 0; i < 2; ++i) {
            int posZ;
            int posX;
            int posY;
            if (rand.fiftyFifty() || (posY = chunkGenerator.func_222529_a(posX = basePos.func_177958_n() + rand.randomNumberUpTo(16), posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) <= 67) continue;
            AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
            switch (rand.randomNumberUpTo(10)) {
                case 0: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 3)).func_177230_c() != surfaceBlock) break;
                    structure = StructuresHandler.getStructure("RoseTree");
                    break;
                }
                case 1: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ)).func_177230_c() != surfaceBlock) break;
                    structure = StructuresHandler.getStructure("BlueStarflower1");
                    break;
                }
                case 2: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 5)).func_177230_c() != surfaceBlock) break;
                    structure = StructuresHandler.getStructure("BlueStarflower2");
                    break;
                }
                case 3: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ)).func_177230_c() != surfaceBlock) break;
                    structure = StructuresHandler.getStructure("RoseStarflower1");
                    break;
                }
                case 4: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 5)).func_177230_c() != surfaceBlock) break;
                    structure = StructuresHandler.getStructure("RoseStarflower2");
                    break;
                }
                case 5: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 5)).func_177230_c() != surfaceBlock) break;
                    structure = StructuresHandler.getStructure("Sunflower1");
                    break;
                }
                case 6: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) break;
                    structure = StructuresHandler.getStructure("Sunflower2");
                    break;
                }
                case 7: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) break;
                    structure = StructuresHandler.getStructure("BlueTulip");
                    break;
                }
                case 8: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) break;
                    structure = StructuresHandler.getStructure("PurpleTulip");
                    break;
                }
                case 9: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) break;
                    structure = StructuresHandler.getStructure("MagentaTulip");
                }
            }
            StructuresHandler.generateStructure(structure, world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int z;
        int y;
        int x;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.floroCastleSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(5);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x, y = 63, z = basePos.func_177952_p() + rand.randomNumberUpTo(5))).func_177230_c() == Blocks.field_150355_j) {
                StructuresHandler.generateStructure("FloroCastle", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.gardenCastleSpawnChance.get())) {
            x = basePos.func_177958_n();
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 17, (y = chunkGenerator.func_222529_a(x + 17, (z = basePos.func_177952_p() + rand.randomNumberUpTo(9)) + 5, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 5)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("GardenCastle", world, rand.source(), (BlockPos)pos.func_181079_c(x, y - 1, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.lottoSkyFlowerSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 4, (y = chunkGenerator.func_222529_a(x + 4, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 4, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 4)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("LottoSkyFlower", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.wizardFlowerSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 5, (y = chunkGenerator.func_222529_a(x + 5, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 5, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 5)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("WizardFlower", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.dayseeFlowerSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 7, (y = chunkGenerator.func_222529_a(x + 7, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 7, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 7)).func_177230_c() == surfaceBlock) {
            StructuresHandler.generateStructure("DayseeFlower", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.kineticRuneShrineSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            y = chunkGenerator.func_222529_a(x + 3, z + 3, Heightmap.Type.WORLD_SURFACE_WG) + 20;
            StructuresHandler.generateStructure("KineticRuneShrine", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
    }
}

