/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.haven;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.WorldGenMinable;
import net.tslat.aoa3.worldgen.structures.AoAStructure;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;
import net.tslat.aoa3.worldgen.trees.HavenTreeGenerator;

public class HavenBiome
extends AoABiome {
    public HavenBiome() {
        super(HavenBiome.getBuilder());
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.OCEANLESS, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.WEIGHTLESS_GRASS.get()).func_176223_P(), ((Block)AoABlocks.WEIGHTLESS_DIRT.get()).func_176223_P(), ((Block)AoABlocks.WEIGHTLESS_STONE.get()).func_176223_P())).func_205414_c(0.5f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(0, 0, 255)).func_205413_b(NumberUtil.RGB(0, 0, 255)).func_205421_a(0.1f).func_205420_b(0.2f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.VOID};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(0, 255, 0);
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.UNDERGROUND_ORES) {
            this.doOreGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doOreGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        for (int i = 0; i < (Integer)AoAConfig.SERVER.ORES.crystalliteVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.CRYSTALLITE_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.crystalliteMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.crystalliteMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.WEIGHTLESS_STONE.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(30, 70), rand.randomNumberUpTo(16)));
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int posZ;
        int posY;
        int posX;
        int i;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        block11: for (i = 0; i < 50; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ)).func_177230_c() != surfaceBlock) continue;
            switch (rand.randomNumberUpTo(7)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.HAVEN_GRASS_PLANT.get()).func_176223_P(), 2);
                    continue block11;
                }
                case 4: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.BLUE_DAYLOOMS.get()).func_176223_P(), 2);
                    continue block11;
                }
                case 5: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.YELLOW_DAYLOOMS.get()).func_176223_P(), 2);
                    continue block11;
                }
                case 6: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.PINK_DAYLOOMS.get()).func_176223_P(), 2);
                }
            }
        }
        for (i = 0; i < 5; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ)).func_177230_c() != surfaceBlock) continue;
            AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
            switch (rand.randomNumberUpTo(3)) {
                case 0: {
                    structure = StructuresHandler.getStructure("BlueHavendales");
                    break;
                }
                case 1: {
                    structure = StructuresHandler.getStructure("PinkHavendales");
                    break;
                }
                case 2: {
                    structure = StructuresHandler.getStructure("YellowHavendales");
                }
            }
            StructuresHandler.generateStructure(structure, world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (int i = 0; i < 3; ++i) {
            int posZ;
            int posY;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 7, (posY = chunkGenerator.func_222529_a(posX + 7, (posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 7, Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ + 7)).func_177230_c() != surfaceBlock) continue;
            new HavenTreeGenerator(null, null, rand.source()).generate(world, rand.source(), (BlockPos)pos);
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int y;
        int z;
        int x;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.dawnlightDungeonSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(10);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            y = rand.randomNumberBetween(10, 35);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 10, y + 7, z + 5)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("DawnlightDungeon", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.floatingLottoFountainSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            y = rand.randomNumberBetween(10, 50);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 3, y + 8, z + 3)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("FloatingLottoFountain", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.guardianTowerSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n()) + 14, (y = chunkGenerator.func_222529_a(x, z = basePos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 14)).func_177230_c() == surfaceBlock) {
            StructuresHandler.generateStructure("GuardianTower", world, rand.source(), (BlockPos)pos.func_181079_c(x, y - 1, z));
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.strikeRuneShrineSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 3, y = chunkGenerator.func_222529_a(x + 3, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 3, Heightmap.Type.WORLD_SURFACE_WG) + 20, z + 3)).func_177230_c() == Blocks.field_150350_a) {
            StructuresHandler.generateStructure("StrikeRuneShrine", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
    }
}

