/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.iromine;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.WorldGenMinable;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;
import net.tslat.aoa3.worldgen.trees.IrodustTreeGenerator;
import net.tslat.aoa3.worldgen.trees.IrogoldTreeGenerator;

public class IromineBiome
extends AoABiome {
    public IromineBiome() {
        super(IromineBiome.getBuilder());
        this.func_203609_a(GenerationStage.Carving.AIR, IromineBiome.func_203606_a(AoAWorldGen.Carvers.IROMINE_CAVES, (ICarverConfig)new ProbabilityConfig(0.14285715f)));
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.OCEANLESS, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.IROGRASS.get()).func_176223_P(), ((Block)AoABlocks.IROSTONE.get()).func_176223_P(), ((Block)AoABlocks.IROSTONE.get()).func_176223_P())).func_205414_c(0.4f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(255, 249, 173)).func_205413_b(NumberUtil.RGB(255, 249, 173)).func_205421_a(0.0f).func_205420_b(0.5f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(0, 0, 0);
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.UNDERGROUND_ORES) {
            this.doOreGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doMiscGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doOreGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        for (int i = 0; i < (Integer)AoAConfig.SERVER.ORES.lyonVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.LYON_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.lyonMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.lyonMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.IROSTONE.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(45, 65), rand.randomNumberUpTo(16)));
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        block5: for (int i = 0; i < 40; ++i) {
            int posZ;
            int posY;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ)).func_177230_c() != surfaceBlock) continue;
            switch (rand.randomNumberUpTo(3)) {
                case 0: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.IRO_GRASS.get()).func_176223_P(), 2);
                    continue block5;
                }
                case 1: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.LURCHIANS.get()).func_176223_P(), 2);
                    continue block5;
                }
                case 2: {
                    world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.IROTOPS.get()).func_176223_P(), 2);
                }
            }
        }
    }

    protected void doMiscGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int posZ;
        int posY;
        int posX;
        if (rand.oneInNChance(50) && world.func_180495_p((BlockPos)pos.func_181079_c((posX = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 3, posY = chunkGenerator.func_222529_a(posX + 3, (posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 3, Heightmap.Type.WORLD_SURFACE_WG) + 15 + rand.randomNumberUpTo(5), posZ + 3)).func_177230_c() == Blocks.field_150350_a) {
            if (rand.fiftyFifty()) {
                StructuresHandler.generateStructure("IroDoubler", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
            } else {
                StructuresHandler.generateStructure("IroFloater", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
            }
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (int i = 0; i < 3; ++i) {
            int posZ;
            int posY;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, (posY = chunkGenerator.func_222529_a(posX + 4, (posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 4, Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ + 4)).func_177230_c() != surfaceBlock) continue;
            if (rand.fiftyFifty()) {
                new IrogoldTreeGenerator(null).generate(world, rand.source(), pos.func_177984_a());
                continue;
            }
            new IrodustTreeGenerator(null).generate(world, rand.source(), pos.func_177984_a());
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int z;
        int y;
        int x;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.iroMazeSpawnChance.get())) {
            x = basePos.func_177958_n();
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 20, (y = chunkGenerator.func_222529_a(x + 20, (z = basePos.func_177952_p()) + 14, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 14)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("IroMaze", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.chargingPadsSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(13);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 8, (y = chunkGenerator.func_222529_a(x + 8, (z = basePos.func_177952_p() + rand.randomNumberUpTo(13)) + 8, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 8)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("ChargingPads", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.professorsLabSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(13);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 8, (y = chunkGenerator.func_222529_a(x + 8, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 5, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 5)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("ProfessorsLab", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.iroPillarSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 3, (y = chunkGenerator.func_222529_a(x + 3, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 3, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 3)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("IroPillar", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.iroPassageSpawnChance.get())) {
            switch (rand.randomNumberUpTo(4)) {
                case 0: {
                    x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    y = chunkGenerator.func_222529_a(x + 6, z + 6, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 6, y - 1, z + 6)).func_177230_c() != surfaceBlock) break;
                    StructuresHandler.generateStructure("EnforcerTower", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
                    break;
                }
                case 1: {
                    x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    y = chunkGenerator.func_222529_a(x + 5, z + 6, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 5, y - 1, z + 6)).func_177230_c() != surfaceBlock) break;
                    StructuresHandler.generateStructure("MechyonTemple", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
                    break;
                }
                case 2: {
                    x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    z = basePos.func_177952_p() + rand.randomNumberUpTo(10);
                    y = chunkGenerator.func_222529_a(x + 7, z + 10, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 7, y - 1, z + 10)).func_177230_c() != surfaceBlock) break;
                    StructuresHandler.generateStructure("IroPassage1", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
                    break;
                }
                case 3: {
                    x = basePos.func_177958_n() + rand.randomNumberUpTo(13);
                    z = basePos.func_177952_p() + rand.randomNumberUpTo(14);
                    y = chunkGenerator.func_222529_a(x + 8, z + 8, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 8, y - 1, z + 8)).func_177230_c() != surfaceBlock) break;
                    StructuresHandler.generateStructure("IroPassage2", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
                }
            }
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.energyRuneShrineSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 3, y = chunkGenerator.func_222529_a(x + 3, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 3, Heightmap.Type.WORLD_SURFACE_WG) + 20, z + 3)).func_177230_c() == Blocks.field_150350_a) {
            StructuresHandler.generateStructure("EnergyRuneShrine", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
    }
}

