/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.lborean;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;

public class LBoreanBiome
extends AoABiome {
    public LBoreanBiome() {
        super(LBoreanBiome.getBuilder());
        for (int i = 0; i < 8; ++i) {
            this.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, AoAWorldGen.Features.BIOME_FRIENDLY_LAKE.get().func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(Blocks.field_150355_j.func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));
        }
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.OCEANLESS, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.CORAL_GRASS.get()).func_176223_P(), ((Block)AoABlocks.CORAL_SOIL.get()).func_176223_P(), ((Block)AoABlocks.CORAL_ROCK.get()).func_176223_P())).func_205414_c(0.5f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(0, 0, 255)).func_205413_b(NumberUtil.RGB(0, 0, 255)).func_205421_a(0.0f).func_205420_b(0.05f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(0, 0, 255);
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        block7: for (int i = 0; i < 65; ++i) {
            int posZ;
            int posY;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p(pos.func_181079_c(posX, posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG), posZ).func_177977_b()).func_177230_c() != surfaceBlock) continue;
            if (rand.oneInNChance(6500)) {
                world.func_180501_a((BlockPos)pos, ((Block)AoABlocks.RED_WATERWEEDS.get()).func_176223_P(), 2);
                continue;
            }
            switch (rand.randomNumberUpTo(5)) {
                case 0: {
                    world.func_180501_a((BlockPos)pos, ((Block)AoABlocks.BUREAL_STOCKS.get()).func_176223_P(), 2);
                    continue block7;
                }
                case 1: {
                    world.func_180501_a((BlockPos)pos, ((Block)AoABlocks.GREEN_WATERWEEDS.get()).func_176223_P(), 2);
                    continue block7;
                }
                case 2: {
                    world.func_180501_a((BlockPos)pos, ((Block)AoABlocks.WHITE_WATERWEEDS.get()).func_176223_P(), 2);
                    continue block7;
                }
                case 3: {
                    world.func_180501_a((BlockPos)pos, ((Block)AoABlocks.YELLOW_WATERWEEDS.get()).func_176223_P(), 2);
                    continue block7;
                }
                case 4: {
                    world.func_180501_a((BlockPos)pos, ((Block)AoABlocks.BLUE_OCEALITES.get()).func_176223_P(), 2);
                }
            }
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
        int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
        switch (rand.randomNumberUpTo(6)) {
            case 0: {
                int posY = chunkGenerator.func_222529_a(posX + 3, posZ + 3, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("GreenCoral1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 1: {
                int posY = chunkGenerator.func_222529_a(posX + 1, posZ + 1, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 10)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("GreenCoral2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 2: {
                int posY = chunkGenerator.func_222529_a(posX + 4, posZ + 4, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 4)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("PinkCoral1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 3: {
                int posY = chunkGenerator.func_222529_a(posX + 1, posZ + 1, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 10, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("OrangeCoral", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 4: {
                int posY = chunkGenerator.func_222529_a(posX + 4, posZ + 4, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 4)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("WhiteCoral", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                break;
            }
            case 5: {
                int posY = chunkGenerator.func_222529_a(posX + 4, posZ + 5, Heightmap.Type.WORLD_SURFACE_WG);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 5)).func_177230_c() != surfaceBlock) break;
                StructuresHandler.generateStructure("YellowCoral", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
            }
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int z;
        int y;
        int x;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.aquaticCastleSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(6);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 12, (y = chunkGenerator.func_222529_a(x + 12, (z = basePos.func_177952_p() + rand.randomNumberUpTo(5)) + 12, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 12)).func_177230_c() == surfaceBlock || world.func_180495_p((BlockPos)pos).func_177230_c() == Blocks.field_150355_j) {
                StructuresHandler.generateStructure("AquaticCastle", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.drownedLottoStandSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 6, (y = chunkGenerator.func_222529_a(x + 6, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 7, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 7)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("DrownedLottoStand", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.dracyonFountainSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 4, (y = chunkGenerator.func_222529_a(x + 4, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 4, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 4)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("DracyonFountain", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.hydroPlatformSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 3, (y = chunkGenerator.func_222529_a(x + 3, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 3, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 3)).func_177230_c() == surfaceBlock) {
            StructuresHandler.generateStructure("HydroPlatform", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.waterRuneShrineSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 3, y = chunkGenerator.func_222529_a(x + 3, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 3, Heightmap.Type.WORLD_SURFACE_WG) + 20, z + 3)).func_177230_c() == Blocks.field_150350_a) {
            StructuresHandler.generateStructure("WaterRuneShrine", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
    }
}

