/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.lelyetia;

import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;
import net.tslat.aoa3.worldgen.trees.AchonyTreeGenerator;
import net.tslat.aoa3.worldgen.trees.ChurryTreeGenerator;
import net.tslat.aoa3.worldgen.trees.InvertedAchonyTreeGenerator;
import net.tslat.aoa3.worldgen.trees.InvertedChurryTreeGenerator;

public class LelyetiaBiome
extends AoABiome {
    public LelyetiaBiome() {
        super(LelyetiaBiome.getBuilder());
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.VOID, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P(), ((Block)AoABlocks.LELYETIAN_STONE.get()).func_176223_P(), ((Block)AoABlocks.INVERTED_LELYETIAN_GRASS.get()).func_176223_P())).func_205414_c(2.0f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(0, 0, 255)).func_205413_b(NumberUtil.RGB(0, 0, 255)).func_205421_a(0.0f).func_205420_b(0.0f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.HOT, BiomeDictionary.Type.VOID};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(0, 0, 255);
    }

    @Override
    public void generateStructuredChunk(IWorld world, ChunkPrimer chunk, SharedSeedRandom rand, BiConsumer<BlockPos, BlockState> blockPlacer) {
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        BlockPos.Mutable pos = new BlockPos.Mutable();
        if (random.percentChance(0.364)) {
            switch (random.randomNumberUpTo(7)) {
                case 0: {
                    this.genLandStrip(blockPlacer, 0, 55, 0, 15, 59, 0);
                    this.genLandStrip(blockPlacer, 0, 55, 15, 15, 59, 15);
                    this.genLandStrip(blockPlacer, 15, 55, 0, 15, 59, 15);
                    this.genLandStrip(blockPlacer, 0, 55, 0, 0, 59, 15);
                    blockPlacer.accept((BlockPos)pos.func_181079_c(1, 59, 1), ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
                    blockPlacer.accept((BlockPos)pos.func_181079_c(14, 59, 14), ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
                    blockPlacer.accept((BlockPos)pos.func_181079_c(1, 59, 14), ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
                    blockPlacer.accept((BlockPos)pos.func_181079_c(14, 59, 1), ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
                    this.genLandStrip(blockPlacer, 1, 55, 1, 14, 58, 1);
                    this.genLandStrip(blockPlacer, 1, 55, 14, 14, 58, 14);
                    this.genLandStrip(blockPlacer, 14, 55, 1, 14, 58, 14);
                    this.genLandStrip(blockPlacer, 1, 55, 1, 1, 58, 14);
                    blockPlacer.accept((BlockPos)pos.func_181079_c(2, 58, 2), ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
                    blockPlacer.accept((BlockPos)pos.func_181079_c(13, 58, 13), ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
                    blockPlacer.accept((BlockPos)pos.func_181079_c(2, 58, 13), ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
                    blockPlacer.accept((BlockPos)pos.func_181079_c(13, 58, 2), ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
                    this.genLandStrip(blockPlacer, 2, 55, 2, 13, 57, 2);
                    this.genLandStrip(blockPlacer, 2, 55, 13, 13, 57, 13);
                    this.genLandStrip(blockPlacer, 13, 55, 2, 13, 57, 13);
                    this.genLandStrip(blockPlacer, 2, 55, 2, 2, 57, 13);
                    blockPlacer.accept((BlockPos)pos.func_181079_c(3, 57, 3), ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
                    blockPlacer.accept((BlockPos)pos.func_181079_c(12, 57, 12), ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
                    blockPlacer.accept((BlockPos)pos.func_181079_c(3, 57, 12), ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
                    blockPlacer.accept((BlockPos)pos.func_181079_c(12, 57, 3), ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
                    this.genLandStrip(blockPlacer, 3, 55, 3, 12, 56, 3);
                    this.genLandStrip(blockPlacer, 3, 55, 12, 12, 56, 12);
                    this.genLandStrip(blockPlacer, 12, 55, 3, 12, 56, 12);
                    this.genLandStrip(blockPlacer, 3, 55, 3, 3, 56, 12);
                    break;
                }
                case 1: {
                    this.genLandStrip(blockPlacer, 0, 55, 0, 15, 59, 1);
                    this.genLandStrip(blockPlacer, 0, 55, 14, 15, 59, 15);
                    this.genLandStrip(blockPlacer, 0, 55, 2, 1, 59, 13);
                    this.genLandStrip(blockPlacer, 14, 55, 2, 15, 59, 13);
                    this.genLandStrip(blockPlacer, 4, 55, 4, 11, 59, 5);
                    this.genLandStrip(blockPlacer, 4, 55, 10, 11, 59, 11);
                    this.genLandStrip(blockPlacer, 4, 55, 6, 5, 59, 9);
                    this.genLandStrip(blockPlacer, 10, 55, 6, 11, 59, 9);
                    break;
                }
                case 2: {
                    this.genLandStrip(blockPlacer, 0, 55, 0, 15, 59, 0);
                    this.genLandStrip(blockPlacer, 0, 55, 15, 15, 59, 15);
                    this.genLandStrip(blockPlacer, 15, 55, 0, 15, 59, 15);
                    this.genLandStrip(blockPlacer, 0, 55, 0, 0, 59, 15);
                    this.genLandStrip(blockPlacer, 1, 55, 1, 6, 59, 6);
                    this.genLandStrip(blockPlacer, 9, 55, 1, 14, 59, 6);
                    this.genLandStrip(blockPlacer, 1, 55, 9, 6, 59, 14);
                    this.genLandStrip(blockPlacer, 9, 55, 9, 14, 59, 14);
                    break;
                }
                case 3: {
                    this.genLandStrip(blockPlacer, 0, 55, 0, 15, 59, 1);
                    this.genLandStrip(blockPlacer, 0, 55, 14, 15, 59, 15);
                    this.genLandStrip(blockPlacer, 0, 55, 2, 1, 59, 13);
                    this.genLandStrip(blockPlacer, 14, 55, 2, 15, 59, 13);
                    this.genLandStrip(blockPlacer, 2, 55, 2, 13, 57, 3);
                    this.genLandStrip(blockPlacer, 2, 55, 12, 13, 57, 13);
                    this.genLandStrip(blockPlacer, 2, 55, 2, 3, 57, 11);
                    this.genLandStrip(blockPlacer, 12, 55, 2, 13, 57, 11);
                    this.genLandStrip(blockPlacer, 4, 55, 4, 11, 56, 5);
                    this.genLandStrip(blockPlacer, 4, 55, 10, 11, 56, 11);
                    this.genLandStrip(blockPlacer, 4, 55, 4, 5, 56, 9);
                    this.genLandStrip(blockPlacer, 10, 55, 4, 11, 56, 9);
                    break;
                }
                case 4: {
                    this.genLandStrip(blockPlacer, 0, 55, 0, 15, 59, 4);
                    this.genLandStrip(blockPlacer, 0, 55, 11, 15, 59, 15);
                    this.genLandStrip(blockPlacer, 0, 55, 5, 4, 59, 10);
                    this.genLandStrip(blockPlacer, 11, 55, 5, 15, 59, 10);
                    this.genLandStrip(blockPlacer, 5, 55, 10, 6, 59, 10);
                    this.genLandStrip(blockPlacer, 5, 55, 9, 5, 59, 9);
                    this.genLandStrip(blockPlacer, 9, 55, 10, 10, 59, 10);
                    this.genLandStrip(blockPlacer, 10, 55, 9, 10, 59, 9);
                    this.genLandStrip(blockPlacer, 5, 55, 5, 5, 59, 6);
                    this.genLandStrip(blockPlacer, 6, 55, 5, 6, 59, 5);
                    this.genLandStrip(blockPlacer, 10, 55, 5, 10, 59, 6);
                    this.genLandStrip(blockPlacer, 9, 55, 5, 9, 59, 5);
                    break;
                }
                case 5: {
                    this.genLandStrip(blockPlacer, 0, 55, 0, 15, 59, 1);
                    this.genLandStrip(blockPlacer, 0, 55, 14, 15, 59, 15);
                    this.genLandStrip(blockPlacer, 0, 55, 2, 1, 59, 13);
                    this.genLandStrip(blockPlacer, 14, 55, 2, 15, 59, 13);
                    this.setAllBlocksInRegion(blockPlacer, 7, 58, 2, 8, 58, 13, ((Block)AoABlocks.LELYETIAN_STONE.get()).func_176223_P());
                    this.setAllBlocksInRegion(blockPlacer, 2, 58, 7, 6, 58, 8, ((Block)AoABlocks.LELYETIAN_STONE.get()).func_176223_P());
                    this.setAllBlocksInRegion(blockPlacer, 9, 58, 7, 13, 58, 8, ((Block)AoABlocks.LELYETIAN_STONE.get()).func_176223_P());
                    this.setAllBlocksInRegion(blockPlacer, 7, 59, 2, 8, 59, 13, ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
                    this.setAllBlocksInRegion(blockPlacer, 2, 59, 7, 6, 59, 8, ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
                    this.setAllBlocksInRegion(blockPlacer, 9, 59, 7, 13, 59, 8, ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
                    break;
                }
                case 6: {
                    this.genLandStrip(blockPlacer, 0, 55, 0, 15, 59, 0);
                    this.genLandStrip(blockPlacer, 0, 55, 15, 15, 59, 15);
                    this.genLandStrip(blockPlacer, 15, 55, 0, 15, 59, 15);
                    this.genLandStrip(blockPlacer, 0, 55, 0, 0, 59, 15);
                    this.genLandStrip(blockPlacer, 7, 55, 1, 8, 59, 14);
                    this.genLandStrip(blockPlacer, 1, 55, 7, 6, 59, 8);
                    this.genLandStrip(blockPlacer, 9, 55, 7, 14, 59, 8);
                    this.genLandStrip(blockPlacer, 1, 55, 1, 6, 58, 1);
                    this.genLandStrip(blockPlacer, 1, 55, 6, 6, 58, 6);
                    this.genLandStrip(blockPlacer, 1, 55, 2, 1, 58, 5);
                    this.genLandStrip(blockPlacer, 6, 55, 2, 6, 58, 5);
                    this.genLandStrip(blockPlacer, 2, 55, 2, 5, 57, 2);
                    this.genLandStrip(blockPlacer, 2, 55, 5, 5, 57, 5);
                    this.genLandStrip(blockPlacer, 2, 55, 3, 2, 57, 4);
                    this.genLandStrip(blockPlacer, 5, 55, 3, 5, 57, 4);
                    this.genLandStrip(blockPlacer, 1, 55, 9, 6, 58, 9);
                    this.genLandStrip(blockPlacer, 1, 55, 14, 6, 58, 14);
                    this.genLandStrip(blockPlacer, 1, 55, 10, 1, 58, 13);
                    this.genLandStrip(blockPlacer, 6, 55, 10, 6, 58, 13);
                    this.genLandStrip(blockPlacer, 2, 55, 10, 5, 57, 10);
                    this.genLandStrip(blockPlacer, 2, 55, 13, 5, 57, 13);
                    this.genLandStrip(blockPlacer, 2, 55, 11, 2, 57, 12);
                    this.genLandStrip(blockPlacer, 5, 55, 11, 5, 57, 12);
                    this.genLandStrip(blockPlacer, 9, 55, 1, 14, 58, 1);
                    this.genLandStrip(blockPlacer, 9, 55, 6, 14, 58, 6);
                    this.genLandStrip(blockPlacer, 9, 55, 2, 9, 58, 5);
                    this.genLandStrip(blockPlacer, 14, 55, 2, 14, 58, 5);
                    this.genLandStrip(blockPlacer, 10, 55, 2, 13, 57, 2);
                    this.genLandStrip(blockPlacer, 10, 55, 5, 13, 57, 5);
                    this.genLandStrip(blockPlacer, 10, 55, 3, 10, 57, 4);
                    this.genLandStrip(blockPlacer, 13, 55, 3, 13, 57, 4);
                    this.genLandStrip(blockPlacer, 9, 55, 9, 14, 58, 9);
                    this.genLandStrip(blockPlacer, 9, 55, 14, 14, 58, 14);
                    this.genLandStrip(blockPlacer, 9, 55, 10, 9, 58, 13);
                    this.genLandStrip(blockPlacer, 14, 55, 10, 14, 58, 13);
                    this.genLandStrip(blockPlacer, 10, 55, 10, 13, 57, 10);
                    this.genLandStrip(blockPlacer, 10, 55, 13, 13, 57, 13);
                    this.genLandStrip(blockPlacer, 10, 55, 11, 10, 57, 12);
                    this.genLandStrip(blockPlacer, 13, 55, 11, 13, 57, 12);
                }
            }
        } else {
            this.genLandStrip(blockPlacer, 0, 55, 0, 15, 59, 15);
        }
    }

    private void genLandStrip(BiConsumer<BlockPos, BlockState> blockPlacer, int lowerX, int lowerY, int lowerZ, int upperX, int upperY, int upperZ) {
        this.setAllBlocksInRegion(blockPlacer, lowerX, lowerY, lowerZ, upperX, lowerY, upperZ, ((Block)AoABlocks.INVERTED_LELYETIAN_GRASS.get()).func_176223_P());
        this.setAllBlocksInRegion(blockPlacer, lowerX, lowerY + 1, lowerZ, upperX, upperY - 1, upperZ, ((Block)AoABlocks.LELYETIAN_STONE.get()).func_176223_P());
        this.setAllBlocksInRegion(blockPlacer, lowerX, upperY, lowerZ, upperX, upperY, upperZ, ((Block)AoABlocks.LELYETIAN_GRASS.get()).func_176223_P());
    }

    private void setAllBlocksInRegion(BiConsumer<BlockPos, BlockState> blockPlacer, int lowerX, int lowerY, int lowerZ, int upperX, int upperY, int upperZ, BlockState block) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int x = lowerX; x <= upperX; ++x) {
            for (int y = lowerY; y <= upperY; ++y) {
                for (int z = lowerZ; z <= upperZ; ++z) {
                    blockPlacer.accept((BlockPos)mutablePos.func_181079_c(x, y, z), block);
                }
            }
        }
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int posZ;
        int posY;
        int posX;
        int i;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (i = 0; i < 51; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY = 54, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16))).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(pos.func_177984_a()).func_177230_c() != AoABlocks.INVERTED_LELYETIAN_GRASS.get()) continue;
            world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.LELYETIAN_WEEDS_DOWN.get()).func_176223_P(), 2);
        }
        for (i = 0; i < 51; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG), posZ)).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(pos.func_177977_b()).func_177230_c() != surfaceBlock) continue;
            world.func_180501_a((BlockPos)pos.func_181079_c(posX, posY, posZ), ((Block)AoABlocks.LELYETIAN_WEEDS.get()).func_176223_P(), 2);
        }
        for (i = 0; i < 11; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ)).func_177230_c() != surfaceBlock) continue;
            if (rand.fiftyFifty()) {
                StructuresHandler.generateStructure("LelyetianWiggler", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                continue;
            }
            StructuresHandler.generateStructure("LelyetianStem", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
        }
        for (i = 0; i < 11; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = 54) + 1, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16))).func_177230_c() != AoABlocks.INVERTED_LELYETIAN_GRASS.get()) continue;
            if (rand.fiftyFifty()) {
                StructuresHandler.generateStructure("InvertedLelyetianWiggler", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                continue;
            }
            StructuresHandler.generateStructure("InvertedLelyetianStem", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int posZ;
        int posY;
        int posX;
        int i;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (i = 0; i < 2; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY = chunkGenerator.func_222529_a(posX + 4, (posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 4, Heightmap.Type.WORLD_SURFACE_WG), posZ + 4)).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(pos.func_177977_b()).func_177230_c() != surfaceBlock) continue;
            new ChurryTreeGenerator(null).generate(world, rand.source(), (BlockPos)pos);
        }
        for (i = 0; i < 2; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY = chunkGenerator.func_222529_a(posX + 3, (posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 3, Heightmap.Type.WORLD_SURFACE_WG), posZ + 3)).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(pos.func_177977_b()).func_177230_c() != surfaceBlock) continue;
            new AchonyTreeGenerator(null).generate(world, rand.source(), (BlockPos)pos);
        }
        for (i = 0; i < 2; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY = 54, (posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 4)).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(pos.func_177984_a()).func_177230_c() != AoABlocks.INVERTED_LELYETIAN_GRASS.get()) continue;
            new InvertedChurryTreeGenerator(null).generate(world, rand.source(), (BlockPos)pos);
        }
        for (i = 0; i < 2; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY = 54, (posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 3)).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(pos.func_177984_a()).func_177230_c() != AoABlocks.INVERTED_LELYETIAN_GRASS.get()) continue;
            new InvertedAchonyTreeGenerator(null).generate(world, rand.source(), (BlockPos)pos);
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int z;
        int y;
        int x;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.lelyetianTowerSpawnChance.get())) {
            int z2;
            int y2;
            int x2 = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x2 + 7, (y2 = 60) - 1, (z2 = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 7)).func_177230_c() == surfaceBlock && world.func_180495_p((BlockPos)pos.func_181079_c(x2 + 7, y2, z2 + 7)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("LelyetianTower", world, rand.source(), (BlockPos)pos.func_181079_c(x2, y2, z2));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.zhinxEnclaveSpawnChance.get())) {
            int x3 = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            int z3 = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            int y3 = 15;
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x3 + 4, 55, z3 + 6)).func_177230_c() != Blocks.field_150350_a) {
                StructuresHandler.generateStructure("ZhinxEnclave", world, rand.source(), (BlockPos)pos.func_181079_c(x3, y3, z3));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.paraviteHiveSpawnChance.get())) {
            int x4 = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            int z4 = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            int y4 = 36;
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x4 + 6, 55, z4 + 6)).func_177230_c() != Blocks.field_150350_a) {
                StructuresHandler.generateStructure("ParaviteHive", world, rand.source(), (BlockPos)pos.func_181079_c(x4, y4, z4));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.boneyDungeonSpawnChance.get())) {
            int x5 = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            int z5 = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            int y5 = 31;
            StructuresHandler.generateStructure("BoneyDungeon", world, rand.source(), (BlockPos)pos.func_181079_c(x5, y5, z5));
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.grawPillarSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 2, (y = 60) - 1, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 2)).func_177230_c() == surfaceBlock && world.func_180495_p((BlockPos)pos.func_181079_c(x + 2, y, z + 2)).func_177230_c() == Blocks.field_150350_a) {
            StructuresHandler.generateStructure("GrawPillar", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
    }
}

