/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.lunalus;

import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;
import net.tslat.aoa3.worldgen.trees.LuniciaTreeGenerator;
import net.tslat.aoa3.worldgen.trees.LunossoTreeGenerator;

public class LunalusBiome
extends AoABiome {
    public LunalusBiome() {
        super(LunalusBiome.getBuilder());
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.VOID, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P())).func_205414_c(-1.0f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(25, 25, 25)).func_205413_b(NumberUtil.RGB(25, 25, 25)).func_205421_a(0.0f).func_205420_b(0.0f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.VOID, BiomeDictionary.Type.SPARSE};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(255, 175, 175);
    }

    @Override
    public void generateStructuredChunk(IWorld world, ChunkPrimer chunk, SharedSeedRandom rand, BiConsumer<BlockPos, BlockState> blockPlacer) {
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block bl;
        int y;
        int z;
        int x;
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                for (y = 36; y <= 60; ++y) {
                    bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x, y - 1, basePos.func_177952_p() + z)).func_177230_c();
                    if (!rand.oneInNChance(10) || bl != AoABlocks.LUNASOLE_GRASS.get() && bl != AoABlocks.LUNALYTE_GRASS.get() || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue;
                    if (rand.fiftyFifty()) {
                        world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.LUNTAR.get()).func_176223_P(), 2);
                        continue;
                    }
                    world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.LUNALIP.get()).func_176223_P(), 2);
                }
            }
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                for (y = 61; y <= 85; ++y) {
                    bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x, y - 1, basePos.func_177952_p() + z)).func_177230_c();
                    if (!rand.oneInNChance(10) || bl != AoABlocks.LUNASOLE_GRASS.get() && bl != AoABlocks.LUNALYTE_GRASS.get() || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue;
                    if (rand.fiftyFifty()) {
                        world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.LUNTAR.get()).func_176223_P(), 2);
                        continue;
                    }
                    world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.LUNALIP.get()).func_176223_P(), 2);
                }
            }
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block bl;
        int y;
        int z;
        int x;
        int count = 0;
        block6: for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                for (y = 36; y <= 60; ++y) {
                    if (!rand.oneInNChance(25)) continue;
                    switch (rand.randomNumberUpTo(4)) {
                        case 0: {
                            bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x + 1, y - 1, basePos.func_177952_p() + z + 1)).func_177230_c();
                            if (bl != AoABlocks.LUNALYTE_GRASS.get() && bl != AoABlocks.LUNASOLE_GRASS.get()) break;
                            StructuresHandler.generateStructure("LunossoTree1", world, rand.source(), pos.func_177982_a(-1, 1, -1));
                            ++count;
                            break;
                        }
                        case 1: {
                            bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x + 2, y - 1, basePos.func_177952_p() + z + 2)).func_177230_c();
                            if (bl != AoABlocks.LUNALYTE_GRASS.get() && bl != AoABlocks.LUNASOLE_GRASS.get()) break;
                            StructuresHandler.generateStructure("LunossoTree2", world, rand.source(), pos.func_177982_a(-2, 1, -2));
                            ++count;
                            break;
                        }
                        case 2: {
                            bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x + 2, y - 1, basePos.func_177952_p() + z + 2)).func_177230_c();
                            if (bl != AoABlocks.LUNALYTE_GRASS.get() && bl != AoABlocks.LUNASOLE_GRASS.get()) break;
                            StructuresHandler.generateStructure("LuniciaTree1", world, rand.source(), pos.func_177982_a(-2, 1, -2));
                            ++count;
                            break;
                        }
                        case 3: {
                            bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x + 2, y - 1, basePos.func_177952_p() + z + 2)).func_177230_c();
                            if (bl != AoABlocks.LUNALYTE_GRASS.get() && bl != AoABlocks.LUNASOLE_GRASS.get()) break;
                            StructuresHandler.generateStructure("LuniciaTree2", world, rand.source(), pos.func_177982_a(-2, 1, -2));
                            ++count;
                        }
                    }
                    if (count == 2) break block6;
                }
            }
        }
        count = 0;
        block9: for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                for (y = 61; y <= 85; ++y) {
                    if (!rand.oneInNChance(25)) continue;
                    if (rand.fiftyFifty()) {
                        bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x + 2, y - 1, basePos.func_177952_p() + z + 2)).func_177230_c();
                        if (bl == AoABlocks.LUNALYTE_GRASS.get() || bl == AoABlocks.LUNASOLE_GRASS.get()) {
                            new LunossoTreeGenerator(null).generate(world, rand.source(), pos.func_177984_a());
                            ++count;
                        }
                    } else {
                        bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x + 2, y - 1, basePos.func_177952_p() + z + 2)).func_177230_c();
                        if (bl == AoABlocks.LUNALYTE_GRASS.get() || bl == AoABlocks.LUNASOLE_GRASS.get()) {
                            new LuniciaTreeGenerator(null).generate(world, rand.source(), pos.func_177984_a());
                            ++count;
                        }
                    }
                    if (count == 2) break block9;
                }
            }
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int y;
        int z;
        int x;
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.fiftyFifty()) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(4);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(4);
            y = rand.randomNumberBetween(36, 45);
            if (rand.fiftyFifty()) {
                StructuresHandler.generateStructure("LunarIsland1", world, rand.source(), new BlockPos(x, y, z));
            } else {
                StructuresHandler.generateStructure("LunarIsland2", world, rand.source(), new BlockPos(x, y, z));
            }
        }
        if (rand.fiftyFifty()) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(4);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(4);
            y = rand.randomNumberBetween(61, 70);
            if (rand.fiftyFifty()) {
                StructuresHandler.generateStructure("LunarIsland1", world, rand.source(), new BlockPos(x, y, z));
            } else {
                StructuresHandler.generateStructure("LunarIsland2", world, rand.source(), new BlockPos(x, y, z));
            }
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.lunarVillageSpawnChance.get())) {
            x = basePos.func_177958_n();
            z = basePos.func_177952_p();
            y = rand.randomNumberBetween(4, 8);
            StructuresHandler.generateStructure("LunarAtom", world, rand.source(), (BlockPos)pos.func_181079_c(x + 60, y, z + 14));
            StructuresHandler.generateStructure("LunarLottoPlatform", world, rand.source(), (BlockPos)pos.func_181079_c(x + 85, y, z + 29));
            StructuresHandler.generateStructure("LunarFoodMarket", world, rand.source(), (BlockPos)pos.func_181079_c(x + 35, y, z));
            StructuresHandler.generateStructure("LunarHerbalHouse", world, rand.source(), (BlockPos)pos.func_181079_c(x + 15, y, z + 5));
            StructuresHandler.generateStructure("SpellbinderHouse", world, rand.source(), (BlockPos)pos.func_181079_c(x + 47, y + 22, z + 22));
            StructuresHandler.generateStructure("LunaradeStand", world, rand.source(), (BlockPos)pos.func_181079_c(x + 28, y + 22, z + 22));
            StructuresHandler.generateStructure("LunarBank", world, rand.source(), (BlockPos)pos.func_181079_c(x, y + 5, z + 12));
            StructuresHandler.generateStructure("LunarFountain", world, rand.source(), (BlockPos)pos.func_181079_c(x + 30, y, z + 14));
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.spaceArenaSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(9);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(8);
            y = rand.randomNumberBetween(15, 18);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 10, y + 4, z + 11)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("SpaceArena", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.lunarCreationPlatformSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            y = rand.randomNumberBetween(15, 18);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 4, y + 2, z + 4)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("LunarCreationPlatform", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.zargPlanetoidSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(7);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(5);
            y = rand.randomNumberBetween(15, 18);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 11, y + 12, z + 12)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("ZargPlanetoid", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.lunarMazeSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(12);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(12);
            y = rand.randomNumberBetween(15, 18);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 9, y + 7, z + 9)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("LunarMaze", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.lunarPrisonSpawnChance.get())) {
            x = basePos.func_177958_n();
            z = basePos.func_177952_p() + rand.randomNumberUpTo(9);
            y = rand.randomNumberBetween(15, 18);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 18, y + 5, z + 10)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("LunarPrison", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.lunarGardenSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(13);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(13);
            y = rand.randomNumberBetween(15, 18);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 8, y + 7, z + 8)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("LunarGarden", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.observersEyeSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            y = rand.randomNumberBetween(90, 100);
            StructuresHandler.generateStructure("ObserversEye", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.lunarRuneShrineSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            int n = y = rand.fiftyFifty() ? rand.randomNumberBetween(70, 90) : rand.randomNumberBetween(6, 21);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 3, y, z + 3)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("LunarRuneShrine", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        }
    }
}

