/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.mysterium;

import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.WorldGenMinable;
import net.tslat.aoa3.worldgen.structures.AoAStructure;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;

public class MysteriumBiome
extends AoABiome {
    public MysteriumBiome() {
        super(MysteriumBiome.getBuilder());
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.VOID, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.FUNGAL_GRASS.get()).func_176223_P(), ((Block)AoABlocks.FUNGAL_DIRT.get()).func_176223_P(), ((Block)AoABlocks.FUNGAL_ROCK.get()).func_176223_P())).func_205414_c(0.4f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(88, 51, 142)).func_205413_b(NumberUtil.RGB(88, 51, 142)).func_205421_a(0.0f).func_205420_b(0.0f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MUSHROOM};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(255, 0, 0);
    }

    @Override
    public void generateStructuredChunk(IWorld world, ChunkPrimer chunk, SharedSeedRandom rand, BiConsumer<BlockPos, BlockState> blockPlacer) {
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        BlockPos.Mutable pos = new BlockPos.Mutable();
        BlockState stone = ((Block)AoABlocks.FUNGAL_ROCK.get()).func_176223_P();
        BlockState dirt = ((Block)AoABlocks.FUNGAL_DIRT.get()).func_176223_P();
        BlockState grass = ((Block)AoABlocks.FUNGAL_GRASS.get()).func_176223_P();
        if (random.oneInNChance(3)) {
            this.setAllBlocksInRegion(blockPlacer, 0, 1, 0, 15, 10, 15, stone);
            this.setAllBlocksInRegion(blockPlacer, 0, 11, 0, 15, 12, 15, Blocks.field_150355_j.func_176223_P());
        } else {
            int z;
            int x;
            this.setAllBlocksInRegion(blockPlacer, 0, 1, 0, 15, 20, 15, stone);
            this.setAllBlocksInRegion(blockPlacer, 0, 21, 0, 15, 21, 15, dirt);
            for (x = 0; x <= 15; ++x) {
                for (z = 0; z <= 15; ++z) {
                    if (x == 0 || x == 15 || z == 0 || z == 15) {
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 22, z), grass);
                        continue;
                    }
                    blockPlacer.accept((BlockPos)pos.func_181079_c(x, 22, z), dirt);
                }
            }
            for (x = 1; x <= 14; ++x) {
                for (z = 1; z <= 14; ++z) {
                    if (x == 1 || x == 14 || z == 1 || z == 14) {
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 23, z), grass);
                        continue;
                    }
                    blockPlacer.accept((BlockPos)pos.func_181079_c(x, 23, z), dirt);
                }
            }
            this.setAllBlocksInRegion(blockPlacer, 2, 24, 2, 13, 24, 13, grass);
        }
        this.setAllBlocksInRegion(blockPlacer, 0, 0, 0, 15, 1, 15, ((Block)AoABlocks.DIMENSIONAL_FABRIC.get()).func_176223_P());
    }

    private void setAllBlocksInRegion(BiConsumer<BlockPos, BlockState> blockPlacer, int lowerX, int lowerY, int lowerZ, int upperX, int upperY, int upperZ, BlockState block) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int x = lowerX; x <= upperX; ++x) {
            for (int y = lowerY; y <= upperY; ++y) {
                for (int z = lowerZ; z <= upperZ; ++z) {
                    blockPlacer.accept((BlockPos)mutablePos.func_181079_c(x, y, z), block);
                }
            }
        }
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.UNDERGROUND_ORES) {
            this.doOreGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doOreGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        for (int i = 0; i < (Integer)AoAConfig.SERVER.ORES.mystiteVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.MYSTITE_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.mystiteMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.mystiteMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.FUNGAL_ROCK.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberBetween(2, 22), rand.randomNumberUpTo(16)));
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int posZ;
        int posY;
        int posX;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        if (world.func_180495_p(basePos).func_177230_c() != Blocks.field_150355_j) {
            for (int x = 0; x < 16; ++x) {
                block14: for (int z = 0; z < 16; ++z) {
                    if (!rand.fiftyFifty() || world.func_180495_p((BlockPos)pos.func_181079_c(posX = basePos.func_177958_n() + x, (posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + z, Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ)).func_177230_c() != surfaceBlock || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue;
                    switch (rand.randomNumberUpTo(5)) {
                        case 0: {
                            world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.MYSTIC_BUSH.get()).func_176223_P(), 2);
                            continue block14;
                        }
                        case 1: {
                            world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.MYSTIC_FERNS.get()).func_176223_P(), 2);
                            continue block14;
                        }
                        case 2: {
                            world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.RAINBOW_GRASS.get()).func_176223_P(), 2);
                            continue block14;
                        }
                        case 3: {
                            world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.RAINBOW_GRASS2.get()).func_176223_P(), 2);
                            continue block14;
                        }
                        case 4: {
                            world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.RAINBOW_GRASS3.get()).func_176223_P(), 2);
                        }
                    }
                }
            }
        }
        for (int i = 0; i < 3; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            posY = chunkGenerator.func_222529_a(posX, posZ, Heightmap.Type.WORLD_SURFACE_WG);
            AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
            switch (rand.randomNumberUpTo(4)) {
                case 0: {
                    structure = StructuresHandler.getStructure("TinyBlueMushroom");
                    break;
                }
                case 1: {
                    structure = StructuresHandler.getStructure("TinyGreenMushroom");
                    break;
                }
                case 2: {
                    structure = StructuresHandler.getStructure("TinyOrangeMushroom");
                    break;
                }
                case 3: {
                    structure = StructuresHandler.getStructure("TinyYellowMushroom");
                }
            }
            StructuresHandler.generateStructure(structure, world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        block8: for (int i = 0; i < 3; ++i) {
            switch (rand.randomNumberUpTo(6)) {
                case 0: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(4);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(4);
                    int posY = chunkGenerator.func_222529_a(posX + 6, posZ + 6, Heightmap.Type.WORLD_SURFACE);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 6, posY - 1, posZ + 6)).func_177230_c() == Blocks.field_150350_a) continue block8;
                    StructuresHandler.generateStructure("BlueMushroomTree", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block8;
                }
                case 1: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(4);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(4);
                    int posY = chunkGenerator.func_222529_a(posX + 6, posZ + 6, Heightmap.Type.WORLD_SURFACE);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 6, posY - 1, posZ + 6)).func_177230_c() == Blocks.field_150350_a) continue block8;
                    StructuresHandler.generateStructure("GreenMushroomTree", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block8;
                }
                case 2: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(8);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(8);
                    int posY = chunkGenerator.func_222529_a(posX + 4, posZ + 4, Heightmap.Type.WORLD_SURFACE);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 4)).func_177230_c() == Blocks.field_150350_a) continue block8;
                    StructuresHandler.generateStructure("OrangeMushroomTree", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block8;
                }
                case 3: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(8);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(8);
                    int posY = chunkGenerator.func_222529_a(posX + 4, posZ + 4, Heightmap.Type.WORLD_SURFACE);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 4)).func_177230_c() == Blocks.field_150350_a) continue block8;
                    StructuresHandler.generateStructure("PurpleMushroomTree", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block8;
                }
                case 4: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(9);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(9);
                    int posY = chunkGenerator.func_222529_a(posX + 3, posZ + 3, Heightmap.Type.WORLD_SURFACE);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)).func_177230_c() == Blocks.field_150350_a) continue block8;
                    StructuresHandler.generateStructure("YellowMushroomTree", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block8;
                }
                case 5: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(10);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(10);
                    int posY = chunkGenerator.func_222529_a(posX + 2, posZ + 2, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)).func_177230_c() == Blocks.field_150350_a) continue block8;
                    StructuresHandler.generateStructure("MiniBlueMushroomTree", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int z;
        int y;
        int x;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.hauntedCastleSpawnChance.get())) {
            x = basePos.func_177958_n();
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 19, (y = chunkGenerator.func_222529_a(x + 19, (z = basePos.func_177952_p()) + 14, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 14)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("HauntedCastle", world, rand.source(), (BlockPos)pos.func_181079_c(x, y - 1, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.fungshroomSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(13);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 8, (y = chunkGenerator.func_222529_a(x + 8, (z = basePos.func_177952_p() + rand.randomNumberUpTo(13)) + 8, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 8)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("Fungshroom", world, rand.source(), (BlockPos)pos.func_181079_c(x, y - 1, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.gorbVillageSpawnChance.get())) {
            x = basePos.func_177958_n();
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 22, (y = chunkGenerator.func_222529_a(x + 22, (z = basePos.func_177952_p() + rand.randomNumberUpTo(10)) + 10, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 10)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("GorbVillage", world, rand.source(), (BlockPos)pos.func_181079_c(x, y - 1, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.mysticLottoShroomSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 4, (y = chunkGenerator.func_222529_a(x + 4, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 4, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 4)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("MysticLottoShroom", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.mushroomSpiderCaveSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(15);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 7, (y = chunkGenerator.func_222529_a(x + 7, (z = basePos.func_177952_p() + rand.randomNumberUpTo(15)) + 7, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 7)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("MushroomSpiderCave", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.mysticPortalPlatformSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 6, (y = chunkGenerator.func_222529_a(x + 6, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 4, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 4)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("MysticPortalPlatform", world, rand.source(), (BlockPos)pos.func_181079_c(x, y - 1, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.runicArenaSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 7, (y = chunkGenerator.func_222529_a(x + 7, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 7, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 7)).func_177230_c() == surfaceBlock) {
            StructuresHandler.generateStructure("RunicArena", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.distortionRuneShrineSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c(x = basePos.func_177958_n() + rand.randomNumberUpTo(16), y = chunkGenerator.func_222529_a(x + 3, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 3, Heightmap.Type.WORLD_SURFACE_WG) + 15, z)).func_177230_c() == Blocks.field_150350_a) {
            StructuresHandler.generateStructure("DistortionRuneShrine", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
    }
}

