/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.overworld;

import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.worldgen.structures.overworld.proper.AmphibiyteCoveStructure;
import net.tslat.aoa3.worldgen.structures.overworld.proper.RuinedTeleporterFrameStructure;
import net.tslat.aoa3.worldgen.structures.overworld.proper.WindRuneShrineStructure;

public class OverworldGen {
    public static void init() {
        OverworldGen.registerOreGen();
        OverworldGen.registerStructures();
    }

    public static void registerOreGen() {
        for (Biome biome : BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD)) {
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)AoABlocks.AMETHYST_ORE.get()).func_176223_P(), 7)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(4, 14, 0, 17))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)AoABlocks.ROSITE_ORE.get()).func_176223_P(), 10)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(5, 17, 0, 31))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)AoABlocks.LIMONITE_ORE.get()).func_176223_P(), 12)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 8, 0, 60))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)AoABlocks.RUNIUM_ORE.get()).func_176223_P(), 17)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(7, 5, 0, 127))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)AoABlocks.JADE_ORE.get()).func_176223_P(), 9)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(5, 7, 0, 13))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)AoABlocks.SAPPHIRE_ORE.get()).func_176223_P(), 4)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 4, 0, 8))));
        }
    }

    public static void registerStructures() {
        ConfiguredFeature windRuneShrine = ((WindRuneShrineStructure)AoAWorldGen.Structures.WIND_RUNE_SHRINE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        ConfiguredFeature ruinedPortalFrame = ((RuinedTeleporterFrameStructure)AoAWorldGen.Structures.RUINED_TELEPORTER_FRAME.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        ConfiguredFeature amphibiyteCove = ((AmphibiyteCoveStructure)AoAWorldGen.Structures.AMPHIBIYTE_COVE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        Set overworldbiomes = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD);
        for (Biome biome : overworldbiomes) {
            biome.func_226711_a_(ruinedPortalFrame);
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ruinedPortalFrame.func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        }
        for (Biome oceanBiome : BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            if (!overworldbiomes.contains(oceanBiome)) continue;
            oceanBiome.func_226711_a_(amphibiyteCove);
            oceanBiome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, amphibiyteCove.func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        }
        for (Biome mountainBiome : BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
            if (!overworldbiomes.contains(mountainBiome)) continue;
            mountainBiome.func_226711_a_(windRuneShrine);
            mountainBiome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, windRuneShrine.func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        }
    }
}

