/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.precasia;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.WorldGenMinable;
import net.tslat.aoa3.worldgen.structures.AoAStructure;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;
import net.tslat.aoa3.worldgen.trees.LucalusTreeGenerator;
import net.tslat.aoa3.worldgen.trees.StranglewoodTreeGenerator;

public class PrecasiaBiome
extends AoABiome {
    public PrecasiaBiome() {
        super(PrecasiaBiome.getBuilder());
        this.func_203609_a(GenerationStage.Carving.AIR, PrecasiaBiome.func_203606_a(AoAWorldGen.Carvers.PRECASIA_CAVES, (ICarverConfig)new ProbabilityConfig(0.14285715f)));
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.OCEANLESS, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.PRECASIAN_GRASS.get()).func_176223_P(), ((Block)AoABlocks.PRECASIAN_SURFACE_ROCK.get()).func_176223_P(), ((Block)AoABlocks.PRECASIAN_LOWER_ROCK.get()).func_176223_P())).func_205414_c(2.0f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(0, 0, 255)).func_205413_b(NumberUtil.RGB(0, 0, 255)).func_205421_a(0.0f).func_205420_b(0.4f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE};
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.UNDERGROUND_ORES) {
            this.doOreGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doOreGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int i;
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.skullboneFragmentVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.SKULLBONE_FRAGMENTS_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.skullboneFragmentMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.skullboneFragmentMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.PRECASIAN_LOWER_ROCK.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberUpTo(40), rand.randomNumberUpTo(16)));
        }
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.footboneFragmentVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.FOOTBONE_FRAGMENTS_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.footboneFragmentMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.footboneFragmentMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.PRECASIAN_LOWER_ROCK.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberUpTo(40), rand.randomNumberUpTo(16)));
        }
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.legboneFragmentVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.LEGBONE_FRAGMENTS_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.legboneFragmentMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.legboneFragmentMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.PRECASIAN_LOWER_ROCK.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberUpTo(40), rand.randomNumberUpTo(16)));
        }
        for (i = 0; i < (Integer)AoAConfig.SERVER.ORES.chestboneFragmentVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.CHESTBONE_FRAGMENTS_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.chestboneFragmentMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.chestboneFragmentMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.PRECASIAN_LOWER_ROCK.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberUpTo(16), rand.randomNumberUpTo(40), rand.randomNumberUpTo(16)));
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (int i = 0; i < 25; ++i) {
            int posZ;
            int posY;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ)).func_177230_c() != surfaceBlock) continue;
            if (rand.fiftyFifty()) {
                world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.LUCON_GRASS.get()).func_176223_P(), 2);
                continue;
            }
            world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.TANGLE_THORNS.get()).func_176223_P(), 2);
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        block4: for (int i = 0; i < 3; ++i) {
            switch (rand.randomNumberUpTo(3)) {
                case 0: 
                case 1: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(14);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(14);
                    int posY = chunkGenerator.func_222529_a(posX + 8, posZ + 8, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 8, posY - 1, posZ + 8)).func_177230_c() != surfaceBlock) continue block4;
                    new StranglewoodTreeGenerator(null).generate(world, rand.source(), pos.func_177984_a());
                    continue block4;
                }
                case 2: {
                    int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    int posY = chunkGenerator.func_222529_a(posX + 6, posZ + 6, Heightmap.Type.WORLD_SURFACE_WG);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 6, posY - 1, posZ + 6)).func_177230_c() != surfaceBlock) continue block4;
                    new LucalusTreeGenerator(null).generate(world, rand.source(), pos.func_177984_a());
                }
            }
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int y;
        int z;
        int x;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.kaiyuTempleSpawnChance.get())) {
            x = basePos.func_177958_n();
            z = basePos.func_177952_p();
            y = chunkGenerator.func_222529_a(x + 22, z + 22, Heightmap.Type.WORLD_SURFACE_WG);
            StructuresHandler.generateStructure("KaiyuTemple", world, rand.source(), (BlockPos)pos.func_181079_c(x, y - 30, z));
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.skeletalArmyArenaSpawnChance.get())) {
            x = basePos.func_177958_n();
            z = basePos.func_177952_p() + rand.randomNumberUpTo(7);
            y = chunkGenerator.func_222529_a(x + 22, z + 13, Heightmap.Type.WORLD_SURFACE_WG);
            Block block1 = world.func_180495_p((BlockPos)pos.func_181079_c(x + 1, y - 1, z + 8)).func_177230_c();
            Block block2 = world.func_180495_p((BlockPos)pos.func_181079_c(x + 28, y - 1, z + 11)).func_177230_c();
            if (!(block1.getBlock() != surfaceBlock.getBlock() && block1 != AoABlocks.PRECASIAN_SURFACE_ROCK.get() || block2.getBlock() != surfaceBlock.getBlock() && block2 != AoABlocks.PRECASIAN_SURFACE_ROCK.get())) {
                StructuresHandler.generateStructure("SkeletalArmyArena", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.jungleLottoHutSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 4, (y = chunkGenerator.func_222529_a(x + 4, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 4, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 4)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("JungleLottoHut", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.opteryxNestSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 4, (y = chunkGenerator.func_222529_a(x + 4, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 4, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 4)).func_177230_c() == surfaceBlock) {
            StructuresHandler.generateStructure("OpteryxNest", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.precasianDenSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(2);
            z = basePos.func_177952_p();
            y = rand.randomNumberBetween(5, 20);
            AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
            switch (rand.randomNumberUpTo(3)) {
                case 0: {
                    structure = StructuresHandler.getStructure("DiocusDen");
                    break;
                }
                case 1: {
                    structure = StructuresHandler.getStructure("IosaurDen");
                    break;
                }
                case 2: {
                    structure = StructuresHandler.getStructure("SpinoledonDen");
                }
            }
            StructuresHandler.generateStructure(structure, world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.lifeRuneShrineSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            y = chunkGenerator.func_222529_a(x, z, Heightmap.Type.WORLD_SURFACE_WG) + 20;
            StructuresHandler.generateStructure("LifeRuneShrine", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
    }
}

