/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.runandor;

import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.WorldGenMinable;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;
import net.tslat.aoa3.worldgen.trees.RunicTreeGenerator;

public class RunandorBiome
extends AoABiome {
    private int chunkNum = RandomUtil.randomNumberUpTo(26);

    public RunandorBiome() {
        super(RunandorBiome.getBuilder());
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.VOID, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.RUNIC_GRASS.get()).func_176223_P(), ((Block)AoABlocks.RUNIC_STONE.get()).func_176223_P(), ((Block)AoABlocks.RUNIC_STONE.get()).func_176223_P())).func_205414_c(0.5f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(0, 0, 255)).func_205413_b(NumberUtil.RGB(0, 0, 255)).func_205421_a(0.0f).func_205420_b(0.0f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.MOUNTAIN};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(0, 0, 255);
    }

    @Override
    public void generateStructuredChunk(IWorld world, ChunkPrimer chunk, SharedSeedRandom rand, BiConsumer<BlockPos, BlockState> blockPlacer) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        if (this.chunkNum > 25) {
            this.chunkNum = 0;
        }
        this.setAllBlocksInRegion(blockPlacer, 0, 2, 0, 15, 11 + this.chunkNum, 15, ((Block)AoABlocks.RUNIC_STONE.get()).func_176223_P());
        this.setAllBlocksInRegion(blockPlacer, 0, 11 + this.chunkNum, 0, 15, 11 + this.chunkNum, 15, 11 + this.chunkNum <= 14 ? ((Block)AoABlocks.RUNIC_STONE.get()).func_176223_P() : ((Block)AoABlocks.RUNIC_GRASS.get()).func_176223_P());
        if (this.chunkNum < 4) {
            for (int x = 0; x <= 15; ++x) {
                for (int y = 12 + this.chunkNum; y <= 15; ++y) {
                    for (int z = 0; z <= 15; ++z) {
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, y, z), Blocks.field_150355_j.func_176223_P());
                    }
                }
            }
        }
        ++this.chunkNum;
        this.setAllBlocksInRegion(blockPlacer, 0, 0, 0, 15, 1, 15, ((Block)AoABlocks.DIMENSIONAL_FABRIC.get()).func_176223_P());
    }

    private void setAllBlocksInRegion(BiConsumer<BlockPos, BlockState> blockPlacer, int lowerX, int lowerY, int lowerZ, int upperX, int upperY, int upperZ, BlockState block) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int x = lowerX; x <= upperX; ++x) {
            for (int y = lowerY; y <= upperY; ++y) {
                for (int z = lowerZ; z <= upperZ; ++z) {
                    blockPlacer.accept((BlockPos)mutablePos.func_181079_c(x, y, z), block);
                }
            }
        }
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.UNDERGROUND_ORES) {
            this.doOreGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doOreGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        for (int i = 0; i < (Integer)AoAConfig.SERVER.ORES.elecaniumVeinsPerChunk.get(); ++i) {
            new WorldGenMinable(((Block)AoABlocks.ELECANIUM_ORE.get()).func_176223_P(), rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.elecaniumMinOresPerVein.get(), (Integer)AoAConfig.SERVER.ORES.elecaniumMaxOresPerVein.get() + 1), (Predicate<BlockState>)BlockMatcher.func_177642_a((Block)((Block)AoABlocks.RUNIC_STONE.get()))).generate(world, rand.source(), basePos.func_177982_a(rand.randomNumberBetween(1, 15), rand.randomNumberBetween(2, 36), rand.randomNumberBetween(1, 15)));
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        block5: for (int i = 0; i < 85; ++i) {
            int posZ;
            int posY;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = chunkGenerator.func_222529_a(posX, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16), Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ)).func_177230_c() != surfaceBlock) continue;
            switch (rand.randomNumberUpTo(3)) {
                case 0: {
                    world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.RUNIC_BUSH.get()).func_176223_P(), 2);
                    continue block5;
                }
                case 1: {
                    world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.RUNE_BULBS.get()).func_176223_P(), 2);
                    continue block5;
                }
                case 2: {
                    world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.MAGIAS.get()).func_176223_P(), 2);
                }
            }
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (int i = 0; i < 2; ++i) {
            int posZ;
            int posY;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, (posY = chunkGenerator.func_222529_a(posX + 4, (posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 4, Heightmap.Type.WORLD_SURFACE_WG)) - 1, posZ + 4)).func_177230_c() != surfaceBlock) continue;
            new RunicTreeGenerator(null).generate(world, rand.source(), pos.func_177984_a());
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.clunkheadArenaSpawnChance.get())) {
            int z;
            int y;
            int x = basePos.func_177958_n() + rand.randomNumberUpTo(6);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 12, (y = chunkGenerator.func_222529_a(x + 12, (z = basePos.func_177952_p() + rand.randomNumberUpTo(10)) + 10, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 10)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("ClunkheadArena", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.runicTowerSpawnChance.get())) {
            int z;
            int y;
            int x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 5, (y = chunkGenerator.func_222529_a(x + 5, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 5, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 5)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("RunicTower", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.spectralCageSpawnChance.get())) {
            int z;
            int y;
            int x = basePos.func_177958_n() + rand.randomNumberUpTo(13);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 8, (y = chunkGenerator.func_222529_a(x + 8, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 7, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 7)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("SpectralCage", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.runeRandomisationStationSpawnChance.get())) {
            int z;
            int y;
            int x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 7, (y = chunkGenerator.func_222529_a(x + 7, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 7, Heightmap.Type.WORLD_SURFACE_WG)) - 1, z + 7)).func_177230_c() == surfaceBlock) {
                StructuresHandler.generateStructure("RuneRandomisationStation", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.runeTemplarBunkerSpawnChance.get())) {
            int x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            int z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            int y = 3;
            if (chunkGenerator.func_222529_a(x + 7, z + 7, Heightmap.Type.WORLD_SURFACE_WG) > 11) {
                StructuresHandler.generateStructure("RuneTemplarBunker", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        }
    }
}

