/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.shyrelands;

import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.structures.AoAStructure;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;
import net.tslat.aoa3.worldgen.trees.ShyreTreeGenerator;

public class ShyrelandsBiome
extends AoABiome {
    public ShyrelandsBiome() {
        super(ShyrelandsBiome.getBuilder());
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.VOID, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.BRIGHT_GRASS.get()).func_176223_P(), ((Block)AoABlocks.BRIGHT_ROCK.get()).func_176223_P(), ((Block)AoABlocks.BRIGHT_ROCK.get()).func_176223_P())).func_205414_c(2.0f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(0, 0, 255)).func_205413_b(NumberUtil.RGB(0, 0, 255)).func_205421_a(0.0f).func_205420_b(0.0f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.HOT};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(0, 0, 255);
    }

    @Override
    public void generateStructuredChunk(IWorld world, ChunkPrimer chunk, SharedSeedRandom rand, BiConsumer<BlockPos, BlockState> blockPlacer) {
        BlockState whiteBricks = ((Block)AoABlocks.WHITE_SHYRE_BRICKS.get()).func_176223_P();
        BlockState yellowBricks = ((Block)AoABlocks.YELLOW_SHYRE_BRICKS.get()).func_176223_P();
        BlockState glass = ((Block)AoABlocks.SHYRE_GLASS.get()).func_176223_P();
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        this.setAllBlocksInRegion(blockPlacer, 0, 0, 0, 15, 29, 15, ((Block)AoABlocks.BRIGHT_ROCK.get()).func_176223_P());
        this.setAllBlocksInRegion(blockPlacer, 1, 30, 1, 14, 30, 14, ((Block)AoABlocks.BRIGHT_GRASS.get()).func_176223_P());
        this.setAllBlocksInRegion(blockPlacer, 0, 30, 0, 15, 30, 0, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 30, 15, 15, 30, 15, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 30, 1, 0, 30, 14, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 15, 30, 1, 15, 30, 14, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 46, 0, 0, 54, 0, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 46, 15, 0, 54, 15, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 15, 46, 0, 15, 54, 0, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 15, 46, 15, 15, 54, 15, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 55, 0, 15, 55, 0, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 55, 15, 15, 55, 15, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 55, 1, 0, 55, 14, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 15, 55, 1, 15, 55, 14, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 1, 46, 0, 14, 54, 0, glass);
        this.setAllBlocksInRegion(blockPlacer, 1, 46, 15, 14, 54, 15, glass);
        this.setAllBlocksInRegion(blockPlacer, 0, 46, 1, 0, 54, 14, glass);
        this.setAllBlocksInRegion(blockPlacer, 15, 46, 1, 15, 54, 14, glass);
        this.setAllBlocksInRegion(blockPlacer, 0, 45, 0, 15, 45, 0, yellowBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 45, 15, 15, 45, 15, yellowBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 45, 1, 0, 45, 14, yellowBricks);
        this.setAllBlocksInRegion(blockPlacer, 15, 45, 1, 15, 45, 14, yellowBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 31, 0, 3, 44, 0, yellowBricks);
        this.setAllBlocksInRegion(blockPlacer, 12, 31, 0, 14, 44, 0, yellowBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 31, 15, 3, 44, 15, yellowBricks);
        this.setAllBlocksInRegion(blockPlacer, 12, 31, 15, 15, 44, 15, yellowBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 31, 0, 0, 44, 3, yellowBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 31, 12, 0, 44, 14, yellowBricks);
        this.setAllBlocksInRegion(blockPlacer, 15, 31, 0, 15, 44, 3, yellowBricks);
        this.setAllBlocksInRegion(blockPlacer, 15, 31, 12, 15, 44, 14, yellowBricks);
        this.setAllBlocksInRegion(blockPlacer, 4, 31, 0, 4, 44, 0, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 11, 31, 0, 11, 44, 0, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 4, 31, 15, 4, 44, 15, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 11, 31, 15, 11, 44, 15, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 31, 4, 0, 44, 4, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 31, 11, 0, 44, 11, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 15, 31, 4, 15, 44, 4, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 15, 31, 11, 15, 44, 11, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 5, 44, 0, 10, 44, 0, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 5, 44, 15, 10, 44, 15, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 0, 44, 5, 0, 44, 10, whiteBricks);
        this.setAllBlocksInRegion(blockPlacer, 15, 44, 5, 15, 44, 10, whiteBricks);
        this.buildRandomDoor(Direction.NORTH, blockPlacer, random);
        this.buildRandomDoor(Direction.SOUTH, blockPlacer, random);
        this.buildRandomDoor(Direction.EAST, blockPlacer, random);
        this.buildRandomDoor(Direction.WEST, blockPlacer, random);
        this.setAllBlocksInRegion(blockPlacer, 0, 0, 0, 15, 1, 15, ((Block)AoABlocks.DIMENSIONAL_FABRIC.get()).func_176223_P());
    }

    private void setAllBlocksInRegion(BiConsumer<BlockPos, BlockState> blockPlacer, int lowerX, int lowerY, int lowerZ, int upperX, int upperY, int upperZ, BlockState block) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int x = lowerX; x <= upperX; ++x) {
            for (int y = lowerY; y <= upperY; ++y) {
                for (int z = lowerZ; z <= upperZ; ++z) {
                    blockPlacer.accept((BlockPos)mutablePos.func_181079_c(x, y, z), block);
                }
            }
        }
    }

    private void buildRandomDoor(Direction side, BiConsumer<BlockPos, BlockState> blockPlacer, RandomUtil.EasyRandom rand) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        BlockState whiteBricks = ((Block)AoABlocks.WHITE_SHYRE_BRICKS.get()).func_176223_P();
        BlockState glass = ((Block)AoABlocks.SHYRE_GLASS.get()).func_176223_P();
        block0 : switch (side) {
            case NORTH: 
            case SOUTH: {
                int z = 0;
                if (side == Direction.SOUTH) {
                    z = 15;
                }
                switch (rand.randomNumberUpTo(5)) {
                    case 0: {
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(7, 43, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(8, 43, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 42, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 42, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(7, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(8, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 42, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 42, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 41, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 41, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(7, 41, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(8, 41, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 41, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 41, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 40, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 40, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 40, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 40, z), whiteBricks);
                        break;
                    }
                    case 1: {
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(7, 43, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(8, 43, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(7, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(8, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 41, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 41, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 41, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 41, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 40, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 40, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 40, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 40, z), whiteBricks);
                        break;
                    }
                    case 2: {
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(7, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(8, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 42, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(7, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(8, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 42, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 41, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 41, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 41, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 41, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 40, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 40, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 40, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 40, z), whiteBricks);
                        break;
                    }
                    case 3: {
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 43, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 43, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 42, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 42, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 41, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 41, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 41, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 41, z), whiteBricks);
                        break;
                    }
                    case 4: {
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 43, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(7, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(8, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 43, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 43, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 42, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(7, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(8, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 42, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 42, z), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(5, 41, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(6, 41, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(9, 41, z), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(10, 41, z), whiteBricks);
                    }
                }
                break;
            }
            case WEST: 
            case EAST: {
                int x = 0;
                if (side == Direction.EAST) {
                    x = 15;
                }
                switch (rand.randomNumberUpTo(5)) {
                    case 0: {
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 5), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 6), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 7), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 8), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 9), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 10), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 5), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 6), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 7), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 8), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 9), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 10), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 5), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 6), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 7), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 8), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 9), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 10), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 40, 5), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 40, 6), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 40, 7), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 40, 8), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 40, 9), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 40, 10), whiteBricks);
                        break block0;
                    }
                    case 1: {
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 5), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 6), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 7), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 8), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 9), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 10), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 5), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 6), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 7), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 8), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 9), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 10), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 5), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 6), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 9), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 10), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 40, 5), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 40, 6), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 40, 9), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 40, 10), whiteBricks);
                        break block0;
                    }
                    case 2: {
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 5), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 6), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 7), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 8), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 9), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 10), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 5), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 6), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 7), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 8), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 9), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 10), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 5), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 6), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 9), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 10), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 40, 5), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 40, 6), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 40, 9), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 40, 10), whiteBricks);
                        break block0;
                    }
                    case 3: {
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 5), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 6), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 9), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 10), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 5), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 6), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 9), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 10), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 5), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 6), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 9), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 10), whiteBricks);
                        break block0;
                    }
                    case 4: {
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 5), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 6), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 7), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 8), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 9), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 43, 10), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 5), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 6), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 7), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 8), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 9), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 42, 10), glass);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 5), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 6), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 9), whiteBricks);
                        blockPlacer.accept((BlockPos)pos.func_181079_c(x, 41, 10), whiteBricks);
                    }
                }
            }
        }
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.UNDERGROUND_ORES) {
            this.doOreGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doMiscGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doOreGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int posY;
        int posZ;
        int posX;
        int i;
        Block fillerBlock = this.field_201875_ar.field_215454_b.func_204109_b().func_177230_c();
        for (i = 0; i < rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.shyregemMinOresPerChunk.get(), (Integer)AoAConfig.SERVER.ORES.shyregemMaxOresPerChunk.get()); ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            posY = rand.randomNumberBetween(2, 27);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY, posZ)).func_177230_c() != fillerBlock) continue;
            world.func_180501_a((BlockPos)pos, ((Block)AoABlocks.SHYREGEM_ORE.get()).func_176223_P(), 2);
        }
        for (i = 0; i < rand.randomNumberBetween((Integer)AoAConfig.SERVER.ORES.shyrestoneMinOresPerChunk.get(), (Integer)AoAConfig.SERVER.ORES.shyrestoneMaxOresPerChunk.get()); ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            posY = rand.randomNumberBetween(2, 27);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY, posZ)).func_177230_c() != fillerBlock) continue;
            world.func_180501_a((BlockPos)pos, ((Block)AoABlocks.SHYRESTONE_ORE.get()).func_176223_P(), 2);
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int posZ;
        int posY;
        int posX;
        int i;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (i = 0; i < 9; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(14);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY = 54, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(14))).func_177230_c() != Blocks.field_150350_a) continue;
            world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.SHYRE_GLASS.get()).func_176223_P(), 2);
            StructuresHandler.generateStructure("InvertedShyreStock", world, rand.source(), (BlockPos)pos);
        }
        block8: for (i = 0; i < 64; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(14);
            if (!world.func_175623_d((BlockPos)pos.func_181079_c(posX, posY = 31, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(14))) || world.func_180495_p(pos.func_177977_b()).func_177230_c() != surfaceBlock) continue;
            switch (rand.randomNumberUpTo(5)) {
                case 0: {
                    if (!rand.oneInNChance(3)) continue block8;
                    StructuresHandler.generateStructure("ShyreStock", world, rand.source(), (BlockPos)pos);
                    continue block8;
                }
                case 1: {
                    world.func_180501_a((BlockPos)pos, ((Block)AoABlocks.SHYRE_WEED.get()).func_176223_P(), 2);
                    continue block8;
                }
                case 2: {
                    world.func_180501_a((BlockPos)pos, ((Block)AoABlocks.ARCBULB.get()).func_176223_P(), 2);
                    continue block8;
                }
                case 3: {
                    world.func_180501_a((BlockPos)pos, ((Block)AoABlocks.ARCFLOWER.get()).func_176223_P(), 2);
                    continue block8;
                }
                case 4: {
                    world.func_180501_a((BlockPos)pos, ((Block)AoABlocks.HORIZON_DAISIES.get()).func_176223_P(), 2);
                }
            }
        }
        if (rand.oneInNChance(40) && world.func_175623_d((BlockPos)pos.func_181079_c(posX = basePos.func_177958_n() + rand.randomNumberUpTo(14), 31, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(14))) && world.func_180495_p(pos.func_177977_b()).func_177230_c() == surfaceBlock) {
            world.func_180501_a((BlockPos)pos, ((Block)AoABlocks.TRILLIAD_BLOOM.get()).func_176223_P(), 2);
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (int i = 0; i < rand.randomNumberUpTo(8); ++i) {
            int posZ;
            int posY;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(12);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, (posY = 31) - 1, (posZ = basePos.func_177952_p() + rand.randomNumberUpTo(12)) + 1)).func_177230_c() != surfaceBlock || !world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY, posZ + 1)).func_185904_a().func_76222_j()) continue;
            new ShyreTreeGenerator(null, null, rand.source()).generate(world, rand.source(), (BlockPos)pos);
        }
    }

    protected void doMiscGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int y;
        int x;
        int baseX = basePos.func_177958_n();
        int baseY = basePos.func_177956_o();
        int baseZ = basePos.func_177952_p();
        BlockState shyreCloud = ((Block)AoABlocks.SHYRE_CLOUD.get()).func_176223_P();
        BlockState glass = ((Block)AoABlocks.SHYRE_GLASS.get()).func_176223_P();
        for (x = 0; x <= 15; ++x) {
            for (int z = 0; z <= 15; ++z) {
                if (!rand.oneInNChance(3)) continue;
                world.func_180501_a((BlockPos)pos.func_181079_c(baseX + x, 78, baseZ + z), shyreCloud, 2);
            }
        }
        for (x = 0; x <= 15; ++x) {
            for (y = 31; y <= 45; ++y) {
                pos.func_181079_c(baseX + x, baseY + y, baseZ);
                if (rand.oneInNChance(12) && world.func_180495_p((BlockPos)pos).func_177230_c() == AoABlocks.YELLOW_SHYRE_BRICKS.get()) {
                    world.func_180501_a((BlockPos)pos, glass, 2);
                }
                pos.func_181079_c(baseX + x, baseY + y, baseZ + 15);
                if (!rand.oneInNChance(12) || world.func_180495_p((BlockPos)pos).func_177230_c() != AoABlocks.YELLOW_SHYRE_BRICKS.get()) continue;
                world.func_180501_a((BlockPos)pos, glass, 2);
            }
        }
        for (int z = 0; z <= 15; ++z) {
            for (y = 31; y <= 45; ++y) {
                pos.func_181079_c(baseX, baseY + y, baseZ + z);
                if (rand.oneInNChance(12) && world.func_180495_p((BlockPos)pos).func_177230_c() == AoABlocks.YELLOW_SHYRE_BRICKS.get()) {
                    world.func_180501_a((BlockPos)pos, glass, 2);
                }
                pos.func_181079_c(baseX + 15, baseY + y, baseZ + z);
                if (!rand.oneInNChance(12) || world.func_180495_p((BlockPos)pos).func_177230_c() != AoABlocks.YELLOW_SHYRE_BRICKS.get()) continue;
                world.func_180501_a((BlockPos)pos, glass, 2);
            }
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int y;
        int z;
        int x;
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.craexxeusTowerSpawnChance.get())) {
            x = basePos.func_177958_n() + 4;
            z = basePos.func_177952_p() + 4;
            y = 31;
            StructuresHandler.generateStructure("CraexxeusTower", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.whitewashingStationSpawnChance.get())) {
            StructuresHandler.generateStructure("WhitewashingStation", world, rand.source(), (BlockPos)pos.func_181079_c(basePos.func_177958_n() + 1, 31, basePos.func_177952_p() + 1));
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.shyreDecorationSpawnChance.get())) {
            AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
            switch (rand.randomNumberUpTo(7)) {
                case 0: {
                    structure = StructuresHandler.getStructure("DivinePlatform");
                    break;
                }
                case 1: {
                    structure = StructuresHandler.getStructure("ArcWizardCheckpoint");
                    break;
                }
                case 2: {
                    structure = StructuresHandler.getStructure("SoulscorneAmbush");
                    break;
                }
                case 3: {
                    structure = StructuresHandler.getStructure("StrangeShrine");
                    break;
                }
                case 4: {
                    structure = StructuresHandler.getStructure("ShyreDecoration1");
                    break;
                }
                case 5: {
                    structure = StructuresHandler.getStructure("ShyreDecoration2");
                    break;
                }
                case 6: {
                    structure = StructuresHandler.getStructure("ShyreDecoration3");
                }
            }
            StructuresHandler.generateStructure(structure, world, rand.source(), (BlockPos)pos.func_181079_c(basePos.func_177958_n() + 1, 31, basePos.func_177952_p() + 1));
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.shyreDungeonSpawnChance.get())) {
            switch (rand.randomNumberUpTo(3)) {
                case 0: {
                    x = basePos.func_177958_n() + 1 + rand.randomNumberUpTo(10);
                    z = basePos.func_177952_p() + 1 + rand.randomNumberUpTo(4);
                    y = rand.randomNumberBetween(2, 17);
                    StructuresHandler.generateStructure("LightwalkerDungeon", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
                    break;
                }
                case 1: {
                    x = basePos.func_177958_n() + 1 + rand.randomNumberUpTo(15);
                    z = basePos.func_177952_p() + 1 + rand.randomNumberUpTo(15);
                    y = rand.randomNumberBetween(2, 17);
                    StructuresHandler.generateStructure("LuxocronDungeon", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
                    break;
                }
                case 2: {
                    x = basePos.func_177958_n() + 1;
                    z = basePos.func_177952_p() + 1 + rand.randomNumberUpTo(15);
                    y = rand.randomNumberBetween(2, 17);
                    StructuresHandler.generateStructure("ShyreTrollDungeon", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
                }
            }
        }
    }
}

