/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.worldgen.worlds.voxponds;

import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAWorldGen;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.structures.AoAStructure;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;

public class VoxPondsBiome
extends AoABiome {
    public VoxPondsBiome() {
        super(VoxPondsBiome.getBuilder());
    }

    private static Biome.Builder getBuilder() {
        Biome.Builder builder = new Biome.Builder();
        builder.func_205415_a(Biome.RainType.NONE).func_222351_a(AoAWorldGen.SurfaceBuilders.VOID, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(((Block)AoABlocks.POLLUTED_GRASS.get()).func_176223_P(), ((Block)AoABlocks.POLLUTED_SOIL.get()).func_176223_P(), ((Block)AoABlocks.POLLUTED_STONE.get()).func_176223_P())).func_205414_c(0.0f).func_205417_d(0.0f).func_205412_a(NumberUtil.RGB(103, 147, 0)).func_205413_b(NumberUtil.RGB(103, 147, 0)).func_205421_a(0.0f).func_205420_b(0.0f).func_205419_a(Biome.Category.NONE);
        return builder;
    }

    @Override
    public BiomeDictionary.Type[] getBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.WET, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DEAD};
    }

    public int func_225529_c_() {
        return NumberUtil.RGB(0, 255, 0);
    }

    @Override
    public void generateStructuredChunk(IWorld world, ChunkPrimer chunk, SharedSeedRandom rand, BiConsumer<BlockPos, BlockState> blockPlacer) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        BlockState toxicStone = ((Block)AoABlocks.POLLUTED_STONE.get()).func_176223_P();
        BlockState toxicWaste = ((Block)AoABlocks.TOXIC_WASTE.get()).func_176223_P();
        this.setAllBlocksInRegion(blockPlacer, 0, 0, 0, 15, 15, 15, toxicStone);
        this.setAllBlocksInRegion(blockPlacer, 0, 16, 0, 15, 17, 15, Blocks.field_150355_j.func_176223_P());
        this.setAllBlocksInRegion(blockPlacer, 0, 32, 0, 15, 35, 15, toxicStone);
        if (rand.nextBoolean()) {
            this.setAllBlocksInRegion(blockPlacer, 0, 36, 0, 15, 36, 15, toxicStone);
            this.setAllBlocksInRegion(blockPlacer, 0, 37, 0, 15, 37, 15, toxicWaste);
            for (int x = 0; x <= 15; ++x) {
                for (int z = 0; z <= 15; ++z) {
                    if (!rand.nextBoolean()) continue;
                    blockPlacer.accept((BlockPos)pos.func_181079_c(x, 36, z), toxicWaste);
                }
            }
        } else {
            this.setAllBlocksInRegion(blockPlacer, 0, 36, 0, 15, 37, 15, ((Block)AoABlocks.POLLUTED_SOIL.get()).func_176223_P());
            this.setAllBlocksInRegion(blockPlacer, 0, 38, 0, 15, 38, 15, ((Block)AoABlocks.POLLUTED_GRASS.get()).func_176223_P());
            for (int x = 0; x <= 15; ++x) {
                for (int z = 0; z <= 15; ++z) {
                    if (!rand.nextBoolean()) continue;
                    blockPlacer.accept((BlockPos)pos.func_181079_c(x, 36, z), toxicStone);
                }
            }
        }
        this.setAllBlocksInRegion(blockPlacer, 0, 0, 0, 15, 1, 15, ((Block)AoABlocks.DIMENSIONAL_FABRIC.get()).func_176223_P());
    }

    private void setAllBlocksInRegion(BiConsumer<BlockPos, BlockState> blockPlacer, int lowerX, int lowerY, int lowerZ, int upperX, int upperY, int upperZ, BlockState block) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int x = lowerX; x <= upperX; ++x) {
            for (int y = lowerY; y <= upperY; ++y) {
                for (int z = lowerZ; z <= upperZ; ++z) {
                    blockPlacer.accept((BlockPos)mutablePos.func_181079_c(x, y, z), block);
                }
            }
        }
    }

    public void func_203608_a(GenerationStage.Decoration stage, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld world, long seed, SharedSeedRandom rand, BlockPos pos) {
        super.func_203608_a(stage, chunkGenerator, world, seed, rand, pos);
        Biome biome = world.func_225523_d_().func_226836_a_(pos);
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom((Random)rand);
        if (stage == GenerationStage.Decoration.VEGETAL_DECORATION) {
            this.doPlantGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doTreeGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        } else if (stage == GenerationStage.Decoration.SURFACE_STRUCTURES) {
            this.doMiscGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
            this.doStructureGen(world, biome, random, pos, new BlockPos.Mutable(), chunkGenerator);
        }
    }

    protected void doPlantGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (!rand.fiftyFifty() || world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x, 38, basePos.func_177952_p() + z)).func_177230_c() != surfaceBlock || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue;
                world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.DEAD_GRASS.get()).func_176223_P(), 2);
            }
        }
        for (int i = 0; i < 3; ++i) {
            int posZ;
            int posY;
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = 39) - 1, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16))).func_177230_c() != surfaceBlock || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue;
            world.func_180501_a(pos.func_177984_a(), ((Block)AoABlocks.VOX_SHROOM.get()).func_176223_P(), 2);
        }
    }

    protected void doTreeGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        block5: for (int i = 0; i < rand.randomNumberUpTo(3); ++i) {
            int posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            int posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            int posY = 39;
            switch (rand.randomNumberUpTo(3)) {
                case 0: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 4)).func_177230_c() != surfaceBlock || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block5;
                    StructuresHandler.generateStructure("ToxicTree1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block5;
                }
                case 1: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)).func_177230_c() != surfaceBlock || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block5;
                    StructuresHandler.generateStructure("ToxicTree2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block5;
                }
                case 2: {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)).func_177230_c() != surfaceBlock || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block5;
                    StructuresHandler.generateStructure("ToxicTree3", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
        }
    }

    protected void doMiscGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int posY;
        int posZ;
        int posX;
        int i;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        block13: for (i = 0; i < 12; ++i) {
            switch (rand.randomNumberUpTo(5)) {
                case 0: {
                    posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    posY = 39;
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)).func_177230_c() != surfaceBlock || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block13;
                    StructuresHandler.generateStructure("ToxicTentacle1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block13;
                }
                case 1: {
                    posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    posY = 39;
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block13;
                    StructuresHandler.generateStructure("ToxicTentacle2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block13;
                }
                case 2: {
                    posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    posY = 39;
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)).func_177230_c() != surfaceBlock || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block13;
                    StructuresHandler.generateStructure("ToxicTentacle3", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block13;
                }
                case 3: {
                    posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    posY = 39;
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block13;
                    StructuresHandler.generateStructure("ToxicTentacle4", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    continue block13;
                }
                case 4: {
                    posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
                    posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
                    posY = 39;
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 1)).func_177230_c() != surfaceBlock || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block13;
                    StructuresHandler.generateStructure("ToxicTentacle5", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
        }
        for (i = 0; i < 6; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = 39) - 1, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16))).func_177230_c() != surfaceBlock || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue;
            if (rand.fiftyFifty()) {
                StructuresHandler.generateStructure("VoxBranch1", world, rand.source(), pos.func_177984_a());
                continue;
            }
            StructuresHandler.generateStructure("VoxBranch2", world, rand.source(), pos.func_177984_a());
        }
        for (i = 0; i < 8; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = 38) - 1, posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16))).func_177230_c() != AoABlocks.TOXIC_WASTE.get()) continue;
            StructuresHandler.generateStructure("MiniTentacles", world, rand.source(), pos.func_177984_a());
        }
        if (rand.randomNumberUpTo(16) == 0) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            posY = 16;
            if (rand.fiftyFifty()) {
                StructuresHandler.generateStructure("DegradedSupportBeam1", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
            } else {
                StructuresHandler.generateStructure("DegradedSupportBeam2", world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
            }
        }
        for (i = 0; i < rand.randomNumberUpTo(6) + 2; ++i) {
            posX = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            posZ = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            posY = 28;
            AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
            switch (rand.randomNumberUpTo(4)) {
                case 0: {
                    structure = StructuresHandler.getStructure("ToxicStem1");
                    break;
                }
                case 1: {
                    structure = StructuresHandler.getStructure("ToxicStem2");
                    break;
                }
                case 2: {
                    structure = StructuresHandler.getStructure("ToxicStem3");
                    break;
                }
                case 3: {
                    structure = StructuresHandler.getStructure("ToxicStem4");
                }
            }
            StructuresHandler.generateStructure(structure, world, rand.source(), (BlockPos)pos.func_181079_c(posX, posY, posZ));
        }
    }

    protected void doStructureGen(IWorld world, Biome biome, RandomUtil.EasyRandom rand, BlockPos basePos, BlockPos.Mutable pos, ChunkGenerator<? extends GenerationSettings> chunkGenerator) {
        int y;
        int z;
        int x;
        Block surfaceBlock = biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c();
        ((SharedSeedRandom)rand.source()).func_202425_c(chunkGenerator.func_202089_c(), basePos.func_177958_n() << 4, basePos.func_177952_p() << 4);
        if (rand.oneInNChance(6)) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            z = basePos.func_177952_p() + rand.randomNumberUpTo(16);
            if (rand.fiftyFifty()) {
                StructuresHandler.generateStructure("HangingDegradedLampPost", world, rand.source(), (BlockPos)pos.func_181079_c(x, 27, z));
            } else {
                StructuresHandler.generateStructure("DegradedLampPost", world, rand.source(), (BlockPos)pos.func_181079_c(x, 16, z));
            }
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.enigmaStationSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 6, y = 18, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 6)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("EnigmaStation", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.controlTowerSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 6, (y = 39) - 1, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 6)).func_177230_c() == surfaceBlock && world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("ControlTower", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.cellTowerSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 5, (y = 39) - 1, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 5)).func_177230_c() == surfaceBlock && world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("CellTower", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.observationTowerSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(14);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 8, (y = 39) - 1, (z = basePos.func_177952_p() + rand.randomNumberUpTo(10)) + 11)).func_177230_c() == surfaceBlock && world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("ObservationTower", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.voxBuildingSpawnChance.get())) {
            x = basePos.func_177958_n();
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 8, (y = 39) - 1, (z = basePos.func_177952_p()) + 8)).func_177230_c() == surfaceBlock) {
                AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
                switch (rand.randomNumberUpTo(4)) {
                    case 0: {
                        structure = StructuresHandler.getStructure("DestroyedStore1");
                        break;
                    }
                    case 1: {
                        structure = StructuresHandler.getStructure("DestroyedStore2");
                        break;
                    }
                    case 2: {
                        structure = StructuresHandler.getStructure("ExoidPlatform");
                        break;
                    }
                    case 3: {
                        structure = StructuresHandler.getStructure("VoxxulonBeacon");
                    }
                }
                StructuresHandler.generateStructure(structure, world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.nightwingIslandSpawnChance.get())) {
            x = basePos.func_177958_n() + rand.randomNumberUpTo(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(x + 2, y = 18, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 2)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("NightwingIsland", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.voxLottoOutpostSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 6, (y = 39) - 1, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 6)).func_177230_c() == surfaceBlock && world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
            StructuresHandler.generateStructure("VoxLottoOutpost", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
        if (rand.percentChance((Double)AoAConfig.SERVER.STRUCTURES.poisonRuneShrineSpawnChance.get()) && world.func_180495_p((BlockPos)pos.func_181079_c((x = basePos.func_177958_n() + rand.randomNumberUpTo(16)) + 3, y = 47, (z = basePos.func_177952_p() + rand.randomNumberUpTo(16)) + 3)).func_177230_c() == Blocks.field_150350_a) {
            StructuresHandler.generateStructure("PoisonRuneShrine", world, rand.source(), (BlockPos)pos.func_181079_c(x, y, z));
        }
    }
}

