/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Session;
import net.teamfruit.emojicord.Log;
import net.teamfruit.emojicord.VersionReference;
import net.teamfruit.emojicord.compat.Compat;
import net.teamfruit.emojicord.emoji.Endpoint;
import net.teamfruit.emojicord.util.DataUtils;
import net.teamfruit.emojicord.util.Downloader;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;

public class Analytics {
    @Nonnull
    public static final Analytics instance = new Analytics();
    private final AnalyticsPreferences preferences = new AnalyticsPreferences();

    public void startAnalytics() {
        new Thread("Emojicord Analytics"){

            @Override
            public void run() {
                try {
                    if (!Analytics.this.process()) {
                        Log.log.debug("Failed to send Analytics");
                    }
                }
                catch (Exception e) {
                    Log.log.debug("Failed to send Analytics: ", (Throwable)e);
                }
            }
        }.start();
    }

    private AnalyticsRequest gatherRequest() {
        AnalyticsRequest request = new AnalyticsRequest();
        Minecraft minecraft = Compat.getMinecraft();
        Session session = minecraft.func_110432_I();
        request.identifier.userid = session.func_148255_b();
        request.identifier.username = session.func_111285_a();
        request.identifier.usertoken = session.func_148254_d();
        request.identifier.clientid = this.preferences.getClientId();
        request.identifier.token = this.preferences.getToken(request.identifier.userid);
        request.version.minecraft = Compat.CompatMinecraftVersion.getMinecraftVersion();
        request.version.forge = Compat.CompatMinecraftVersion.getForgeVersion();
        request.version.mod.minecraft = VersionReference.MINECRAFT;
        request.version.mod.forge = VersionReference.FORGE;
        request.version.mod.mod = VersionReference.VERSION;
        request.environment.lang = minecraft.field_71474_y.field_74363_ab;
        request.environment.locale = Locale.getDefault().toString();
        return request;
    }

    private boolean collectResponse(AnalyticsResponse response) {
        AnalyticsResponse.Identifier identifier = response.identifier;
        if (identifier != null) {
            String userid;
            Minecraft minecraft;
            Session session;
            boolean hasChanged = false;
            if (identifier.clientid != null) {
                this.preferences.setClientId(identifier.clientid);
                hasChanged = true;
            }
            if ((session = (minecraft = Compat.getMinecraft()).func_110432_I()) != null && !StringUtils.isEmpty((CharSequence)(userid = session.func_148255_b())) && identifier.token != null) {
                this.preferences.setToken(userid, identifier.token);
                hasChanged = true;
            }
            if (hasChanged) {
                this.preferences.save();
            }
        }
        return true;
    }

    private boolean process() throws Exception {
        String url = Endpoint.EMOJI_API.api.analytics;
        if (url == null) {
            return false;
        }
        AnalyticsRequest sendData = this.gatherRequest();
        String sendJson = DataUtils.saveString(AnalyticsRequest.class, sendData, "Analytics Request");
        if (sendJson == null) {
            return false;
        }
        HttpPost req = new HttpPost(url);
        req.setEntity((HttpEntity)new StringEntity(sendJson, ContentType.APPLICATION_JSON));
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response = Downloader.downloader.client.execute((HttpUriRequest)req, (HttpContext)context);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            Log.log.debug("Failed to send Analytics: " + statusCode);
            return false;
        }
        HttpEntity resultEntity = response.getEntity();
        AnalyticsResponse resultData = DataUtils.loadStream(resultEntity.getContent(), AnalyticsResponse.class, "Analytics Response");
        if (resultData == null) {
            return false;
        }
        return this.collectResponse(resultData);
    }

    public static class AnalyticsResponse {
        @Nullable
        public Identifier identifier = new Identifier();

        public static class Identifier {
            @Nullable
            public String clientid;
            @Nullable
            public String token;
        }
    }

    public static class AnalyticsRequest {
        public Identifier identifier = new Identifier();
        public Version version = new Version();
        public Environment environment = new Environment();

        public static class Environment {
            public String lang;
            public String locale;
        }

        public static class Version {
            public String minecraft;
            public String forge;
            public ModVersion mod = new ModVersion();

            public static class ModVersion {
                public String minecraft;
                public String forge;
                public String mod;
            }
        }

        public static class Identifier {
            public String clientid;
            public String token;
            public String userid;
            public String username;
            public String usertoken;
        }
    }

    public static class AnalyticsPreferences {
        private final Preferences prefs;

        public AnalyticsPreferences() {
            AnalyticsPreferences.suppressPreferencesWarnings();
            this.prefs = Preferences.userNodeForPackage(this.getClass());
        }

        private static void suppressPreferencesWarnings() {
            try {
                Class<?> pLoggerClass = Class.forName("sun.util.logging.PlatformLogger");
                Class<?> pLevelClass = Class.forName("sun.util.logging.PlatformLogger$Level");
                Object pLogger = pLoggerClass.getMethod("getLogger", String.class).invoke(null, "java.util.prefs");
                Object pLevel = pLoggerClass.getMethod("level", new Class[0]).invoke(pLogger, new Object[0]);
                Method pLoggetSetLevel = pLoggerClass.getMethod("setLevel", pLevelClass);
                Object pLevelOff = pLevelClass.getField("OFF").get(null);
                pLoggetSetLevel.invoke(pLogger, pLevelOff);
                Preferences.userRoot();
                pLoggetSetLevel.invoke(pLogger, pLevel);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }

        public void setClientId(String clientid) {
            this.prefs.put("clientid", clientid);
        }

        public String getClientId() {
            return this.prefs.get("clientid", null);
        }

        public void setToken(String userid, String token) {
            Preferences userprefs = this.prefs.node("users");
            userprefs.put(userid, token);
        }

        public String getToken(String userid) {
            Preferences userprefs = this.prefs.node("users");
            return userprefs.get(userid, null);
        }

        public boolean save() {
            try {
                this.prefs.flush();
            }
            catch (BackingStoreException e) {
                Log.log.warn("Failed to store Analytics Token: ", (Throwable)e);
                return false;
            }
            return true;
        }
    }
}

