/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord;

import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.teamfruit.emojicord.Analytics;
import net.teamfruit.emojicord.CommonProxy;
import net.teamfruit.emojicord.EmojicordConfig;
import net.teamfruit.emojicord.EmojicordScope;
import net.teamfruit.emojicord.EventHandler;
import net.teamfruit.emojicord.Locations;
import net.teamfruit.emojicord.VersionReference;
import net.teamfruit.emojicord.compat.Compat;
import net.teamfruit.emojicord.compat.CompatBaseProxy;
import net.teamfruit.emojicord.emoji.DiscordEmojiIdDictionary;
import net.teamfruit.emojicord.emoji.EmojiFrequently;
import net.teamfruit.emojicord.emoji.Endpoint;

public class ClientProxy
extends CommonProxy {
    public static EventHandler eventHandler;

    @Override
    public void preInit(@Nonnull CompatBaseProxy.CompatFMLPreInitializationEvent event) {
        super.preInit(event);
        EmojicordConfig.spec.registerConfigDefine(Dist.CLIENT);
        EmojicordConfig.spec.registerConfigHandler(Dist.CLIENT, event.getSuggestedConfigurationFile());
        Compat.CompatVersionChecker.startVersionCheck("emojicord", VersionReference.VERSION, "https://raw.githubusercontent.com/Team-Fruit/Emojicord/update/update.json");
    }

    @Override
    public void init(@Nonnull CompatBaseProxy.CompatFMLInitializationEvent event) {
        super.init(event);
        EmojiFrequently.instance.load(Locations.instance.getEmojicordDirectory());
        DiscordEmojiIdDictionary.instance.init(Locations.instance.getDictionaryDirectory());
        DiscordEmojiIdDictionary.instance.loadAll();
        EmojicordScope.instance.loadAll();
        if (Endpoint.loadGateway()) {
            Endpoint.loadStandardEmojis();
            Endpoint.loadStandardPicker();
            Analytics.instance.startAnalytics();
        }
        eventHandler = new EventHandler();
        eventHandler.registerHandler();
        eventHandler.registerDictionaryWatcher(Locations.instance.getDictionaryDirectory());
    }

    @Override
    public void postInit(@Nonnull CompatBaseProxy.CompatFMLPostInitializationEvent event) {
        super.postInit(event);
    }
}

