/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.teamfruit.emojicord.Log;
import net.teamfruit.emojicord.util.DataUtils;

public class EmojicordScope {
    public static EmojicordScope instance = new EmojicordScope();
    public Set<String> input = Sets.newHashSet();
    public Set<String> message = Sets.newHashSet();

    public void loadAll() {
        ArrayList input = Lists.newArrayList();
        ArrayList message = Lists.newArrayList();
        try {
            Enumeration<URL> ress = this.getClass().getClassLoader().getResources("META-INF/emojicord/scope.json");
            while (ress.hasMoreElements()) {
                URL url = ress.nextElement();
                try {
                    EmojicordScopeModel scope = DataUtils.loadStream(url.openStream(), EmojicordScopeModel.class, "Emojicord Scope Config");
                    if (scope == null) continue;
                    if (scope.input != null) {
                        input.addAll(scope.input);
                    }
                    if (scope.message == null) continue;
                    message.addAll(scope.message);
                }
                catch (IOException e) {
                    Log.log.info("Failed to load Emojicord Scope Config: ", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            Log.log.info("Failed to load Emojicord Scope Config: ", (Throwable)e);
        }
        this.input = Sets.newHashSet((Iterable)input);
        this.message = Sets.newHashSet((Iterable)message);
    }

    public boolean checkIsInput(StackTraceElement[] stacks) {
        if (stacks == null) {
            return true;
        }
        return Stream.of(stacks).map(StackTraceElement::getClassName).anyMatch(this.input::contains);
    }

    public boolean checkIsMessage(StackTraceElement[] stacks) {
        if (stacks == null) {
            return true;
        }
        return Stream.of(stacks).map(StackTraceElement::getClassName).anyMatch(this.message::contains);
    }

    public static class EmojicordScopeModel {
        public List<String> input;
        public List<String> message;
    }
}

