/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.teamfruit.emojicord.Log;
import net.teamfruit.emojicord.emoji.EmojiFrequently;
import net.teamfruit.emojicord.emoji.EmojiText;
import net.teamfruit.emojicord.emoji.PickerItem;
import net.teamfruit.emojicord.gui.EmojiSelectionChat;
import net.teamfruit.emojicord.gui.EmojiSettings;
import net.teamfruit.emojicord.gui.IChatOverlay;
import net.teamfruit.emojicord.gui.SuggestionChat;

public class EventHandler {
    @Nonnull
    static final Pattern skintonePattern = Pattern.compile("\\:skin-tone-(\\d)\\:");
    private final List<Function<ChatScreen, IChatOverlay>> overlayFactories = Arrays.asList(EmojiSettings::new, EmojiSelectionChat::new, SuggestionChat::new);
    private List<IChatOverlay> overlays = Collections.emptyList();
    private WatchService watcher;
    private AtomicBoolean changed = new AtomicBoolean(false);
    private final Map<Integer, Integer> lwjgl2glfwKeyMappings = ((Supplier<Map>)() -> {
        HashMap map = Maps.newHashMap();
        map.put(205, 262);
        map.put(203, 263);
        map.put(208, 264);
        map.put(200, 265);
        map.put(15, 258);
        map.put(28, 257);
        map.put(156, 335);
        map.put(1, 256);
        return map;
    }).get();

    public void registerHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerDictionaryWatcher(File dictDir) {
        try {
            Path dir = dictDir.toPath();
            WatchService watcher = FileSystems.getDefault().newWatchService();
            dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.watcher = watcher;
        }
        catch (IOException e) {
            Log.log.warn("Could not watch the dictionary directory: ", (Throwable)e);
        }
        if (this.watcher != null) {
            ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("emojicord-directory-watch-%d").build());
            executor.submit(() -> {
                while (true) {
                    try {
                        while (true) {
                            WatchKey watchKey = this.watcher.take();
                            for (WatchEvent<?> event : watchKey.pollEvents()) {
                                if (event.kind() == StandardWatchEventKinds.OVERFLOW) continue;
                                this.changed.set(true);
                            }
                            watchKey.reset();
                        }
                    }
                    catch (InterruptedException e) {
                        this.changed.set(true);
                        continue;
                    }
                    break;
                }
            });
            executor.shutdown();
        }
    }

    public boolean hasDictionaryDirectoryChanged() {
        if (this.watcher == null) {
            return true;
        }
        return this.changed.getAndSet(false);
    }

    @SubscribeEvent
    public void onChat(ClientChatEvent event) {
        String message = event.getMessage();
        if (!message.startsWith("/")) {
            String untoned = skintonePattern.matcher(message).replaceAll("");
            EmojiText emojiText = EmojiText.create(untoned, EnumSet.of(EmojiText.ParseFlag.ESCAPE, EmojiText.ParseFlag.ENCODE, EmojiText.ParseFlag.ENCODE_ALIAS, EmojiText.ParseFlag.ENCODE_UTF, EmojiText.ParseFlag.PARSE));
            PickerItem.fromText(emojiText).forEach(EmojiFrequently.instance::use);
            if (EmojiFrequently.instance.hasChanged()) {
                EmojiFrequently.instance.save();
            }
            EmojiText emojiText2 = EmojiText.create(message, EnumSet.of(EmojiText.ParseFlag.ESCAPE, EmojiText.ParseFlag.ENCODE, EmojiText.ParseFlag.ENCODE_ALIAS, EmojiText.ParseFlag.ENCODE_UTF));
            event.setMessage(emojiText2.getEncoded());
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (IChatOverlay overlay : this.overlays) {
                overlay.onTick();
            }
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        Screen chatScreen = event.getGui();
        this.overlays = chatScreen instanceof ChatScreen ? this.overlayFactories.stream().map(e -> (IChatOverlay)e.apply((ChatScreen)chatScreen)).collect(Collectors.toList()) : Collections.emptyList();
    }

    @SubscribeEvent
    public void onDraw(GuiScreenEvent.DrawScreenEvent.Post event) {
        ListIterator<IChatOverlay> itr = this.overlays.listIterator(this.overlays.size());
        while (itr.hasPrevious()) {
            IChatOverlay overlay = itr.previous();
            overlay.onMouseInput(event.getMouseX(), event.getMouseY());
            if (!overlay.onDraw()) continue;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onMouseClicked(GuiScreenEvent.MouseClickedEvent.Pre event) {
        for (IChatOverlay overlay : this.overlays) {
            if (!overlay.onMouseClicked(event.getButton())) continue;
            event.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent
    public void onMouseReleased(GuiScreenEvent.MouseReleasedEvent.Pre event) {
        for (IChatOverlay overlay : this.overlays) {
            if (!overlay.onMouseReleased(event.getButton())) continue;
            event.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent
    public void onMouseScroll(GuiScreenEvent.MouseScrollEvent.Pre event) {
        for (IChatOverlay overlay : this.overlays) {
            if (!overlay.onMouseScroll(event.getScrollDelta())) continue;
            event.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent
    public void onCharTyped(GuiScreenEvent.KeyboardCharTypedEvent.Pre event) {
        for (IChatOverlay overlay : this.overlays) {
            if (!overlay.onCharTyped(event.getCodePoint(), event.getModifiers())) continue;
            event.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent
    public void onKeyPressed(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        for (IChatOverlay overlay : this.overlays) {
            if (!overlay.onKeyPressed(event.getKeyCode())) continue;
            event.setCanceled(true);
            break;
        }
    }
}

