/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.asm;

import cpw.mods.modlauncher.api.ITransformer;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.teamfruit.emojicord.Log;
import net.teamfruit.emojicord.asm.EmojicordTransforms;
import net.teamfruit.emojicord.asm.lib.ClassName;
import net.teamfruit.emojicord.asm.lib.INodeTransformer;
import net.teamfruit.emojicord.asm.lib.INodeTreeTransformer;
import net.teamfruit.emojicord.asm.lib.VisitorHelper;
import net.teamfruit.emojicord.compat.CompatTransformer;
import org.objectweb.asm.tree.ClassNode;

public class EmojicordTransformer
extends CompatTransformer
implements ITransformer<ClassNode> {
    public final INodeTreeTransformer[] transformers = EmojicordTransforms.transformers;
    private final Set<String> transformerNames = Stream.of(this.transformers).map(INodeTransformer::getClassName).map(ClassName::getName).collect(Collectors.toSet());
    public static final CompatTransformer.DeferredTransform intelliInputDeferred = new CompatTransformer.DeferredTransform(EmojicordTransformer.class.getName(), "com.tsoft_web.IntelliInput.asm.IntelliInputTransformer");
    public static final CompatTransformer.DeferredTransform[] deferredTransforms = new CompatTransformer.DeferredTransform[]{intelliInputDeferred};

    @Override
    public ClassNode read(@Nonnull byte[] bytes) {
        return VisitorHelper.read(bytes, 4);
    }

    @Override
    public byte[] write(@Nonnull ClassNode node) {
        return VisitorHelper.write(node, 2);
    }

    @Override
    public ClassNode transform(ClassNode input, CompatTransformer.CompatTransformerVotingContext context) {
        try {
            for (INodeTreeTransformer transformer : this.transformers) {
                if (!transformer.getMatcher().test(input)) continue;
                return VisitorHelper.transform(input, transformer, Log.log);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not transform: ", e);
        }
        return input;
    }

    @Override
    public CompatTransformer.DeferredTransform[] deferredTransforms() {
        return deferredTransforms;
    }

    @Override
    public Set<String> targetNames() {
        return this.transformerNames;
    }
}

