/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class CompatConfigSpec {
    private final ForgeConfigSpec spec;
    private File location;
    private static final Joiner LINE_JOINER = Joiner.on((String)"\n");
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");
    private static final Joiner DOT_JOINER = Joiner.on((String)".");

    private CompatConfigSpec(ForgeConfigSpec spec) {
        this.spec = spec;
    }

    public boolean isAvailable() {
        return true;
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public File getConfigFile() {
        return this.location;
    }

    private ModConfig.Type toModConfigType(Dist side) {
        switch (side) {
            case CLIENT: {
                return ModConfig.Type.CLIENT;
            }
            case DEDICATED_SERVER: {
                return ModConfig.Type.SERVER;
            }
        }
        return ModConfig.Type.COMMON;
    }

    public void registerConfigDefine(Dist side) {
        ModLoadingContext.get().registerConfig(this.toModConfigType(side), this.spec);
    }

    public CompatConfigHandler registerConfigHandler(Dist side, File location) {
        this.location = location;
        return () -> {};
    }

    public void save() {
        this.spec.save();
    }

    private static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    public static class DoubleValue
    extends ConfigValue<Double> {
        DoubleValue(Builder parent, List<String> path, Supplier<Double> defaultSupplier, BuilderContext builderContext) {
            super(parent, path, defaultSupplier, builderContext);
        }

        @Override
        protected ForgeConfigSpec.ConfigValue<Double> applyDefine(ForgeConfigSpec.Builder builder) {
            return builder.define(this.path, this.defaultSupplier, v -> v instanceof Double);
        }
    }

    public static class IntValue
    extends ConfigValue<Integer> {
        IntValue(Builder parent, List<String> path, Supplier<Integer> defaultSupplier, BuilderContext builderContext) {
            super(parent, path, defaultSupplier, builderContext);
        }

        @Override
        protected ForgeConfigSpec.ConfigValue<Integer> applyDefine(ForgeConfigSpec.Builder builder) {
            return builder.define(this.path, this.defaultSupplier, v -> v instanceof Integer);
        }
    }

    public static class BooleanValue
    extends ConfigValue<Boolean> {
        BooleanValue(Builder parent, List<String> path, Supplier<Boolean> defaultSupplier, BuilderContext builderContext) {
            super(parent, path, defaultSupplier, builderContext);
        }

        @Override
        protected ForgeConfigSpec.ConfigValue<Boolean> applyDefine(ForgeConfigSpec.Builder builder) {
            return builder.define(this.path, this.defaultSupplier);
        }
    }

    public static class StringValue
    extends ConfigValue<String> {
        StringValue(Builder parent, List<String> path, Supplier<String> defaultSupplier, BuilderContext builderContext) {
            super(parent, path, defaultSupplier, builderContext);
        }

        @Override
        protected ForgeConfigSpec.ConfigValue<String> applyDefine(ForgeConfigSpec.Builder builder) {
            return builder.define(this.path, this.defaultSupplier, v -> v instanceof String);
        }
    }

    public static abstract class ConfigValue<T> {
        protected final Builder parent;
        protected final List<String> path;
        protected final Supplier<T> defaultSupplier;
        protected final BuilderContext builderContext;
        protected ForgeConfigSpec.ConfigValue<T> value;

        ConfigValue(Builder parent, List<String> path, Supplier<T> defaultSupplier, BuilderContext builderContext) {
            this.parent = parent;
            this.path = path;
            this.defaultSupplier = defaultSupplier;
            this.builderContext = builderContext;
        }

        public List<String> getPath() {
            return Lists.newArrayList(this.path);
        }

        public T get() {
            Preconditions.checkNotNull(this.value, (Object)"Cannot get config value without assigned Config object present");
            return (T)this.value.get();
        }

        public void set(T value) {
            Preconditions.checkNotNull(this.value, (Object)"Cannot set config value without assigned Config object present");
            this.value.set(value);
        }

        public Builder next() {
            return this.parent;
        }

        protected abstract ForgeConfigSpec.ConfigValue<T> applyDefine(ForgeConfigSpec.Builder var1);

        public void apply(ForgeConfigSpec.Builder builder) {
            this.builderContext.apply(builder);
            this.value = this.applyDefine(builder);
        }
    }

    private static class BuilderContext {
        private String[] comment;
        private String langKey;
        private boolean worldRestart = false;

        private BuilderContext() {
        }

        public void setComment(String ... value) {
            this.comment = value;
        }

        public String[] getComment() {
            return this.comment;
        }

        public void setTranslationKey(String value) {
            this.langKey = value;
        }

        public void worldRestart() {
            this.worldRestart = true;
        }

        public void ensureEmpty() {
            this.validate(this.comment, "Non-null comment when null expected");
            this.validate(this.langKey, "Non-null translation key when null expected");
            this.validate(this.worldRestart, "Dangeling world restart value set to true");
        }

        private void validate(Object value, String message) {
            if (value != null) {
                throw new IllegalStateException(message);
            }
        }

        private void validate(boolean value, String message) {
            if (value) {
                throw new IllegalStateException(message);
            }
        }

        public void apply(ForgeConfigSpec.Builder builder) {
            if (this.comment != null) {
                builder.comment(this.comment);
            }
            if (this.langKey != null) {
                builder.translation(this.langKey);
            }
            if (this.worldRestart) {
                builder.worldRestart();
            }
        }
    }

    public static class Builder {
        private BuilderContext context = new BuilderContext();
        private ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();

        public StringValue define(String path, String defaultValue) {
            return this.defineString(CompatConfigSpec.split(path), () -> defaultValue);
        }

        public StringValue defineString(List<String> path, Supplier<String> defaultSupplier) {
            StringValue ret = new StringValue(this, path, defaultSupplier, this.context);
            ret.apply(this.builder);
            this.context = new BuilderContext();
            return ret;
        }

        public BooleanValue define(String path, boolean defaultValue) {
            return this.defineBoolean(CompatConfigSpec.split(path), () -> defaultValue);
        }

        private BooleanValue defineBoolean(List<String> path, Supplier<Boolean> defaultSupplier) {
            BooleanValue ret = new BooleanValue(this, path, defaultSupplier, this.context);
            ret.apply(this.builder);
            this.context = new BuilderContext();
            return ret;
        }

        public IntValue define(String path, int defaultValue) {
            return this.defineInt(CompatConfigSpec.split(path), () -> defaultValue);
        }

        private IntValue defineInt(List<String> path, Supplier<Integer> defaultSupplier) {
            IntValue ret = new IntValue(this, path, defaultSupplier, this.context);
            ret.apply(this.builder);
            this.context = new BuilderContext();
            return ret;
        }

        public DoubleValue define(String path, double defaultValue) {
            return this.defineDouble(CompatConfigSpec.split(path), () -> defaultValue);
        }

        private DoubleValue defineDouble(List<String> path, Supplier<Double> defaultSupplier) {
            DoubleValue ret = new DoubleValue(this, path, defaultSupplier, this.context);
            ret.apply(this.builder);
            this.context = new BuilderContext();
            return ret;
        }

        public Builder comment(String comment) {
            this.context.setComment(comment);
            return this;
        }

        public Builder comment(String ... comment) {
            this.context.setComment(comment);
            return this;
        }

        public Builder translation(String translationKey) {
            this.context.setTranslationKey(translationKey);
            return this;
        }

        public Builder worldRestart() {
            this.context.worldRestart();
            return this;
        }

        public Builder push(String path) {
            return this.push(CompatConfigSpec.split(path));
        }

        public Builder push(List<String> path) {
            String[] comment = this.context.getComment();
            if (comment != null) {
                this.builder.comment(comment);
            }
            this.builder.push(path);
            this.context = new BuilderContext();
            return this;
        }

        public Builder pop() {
            return this.pop(1);
        }

        public Builder pop(int count) {
            this.builder.pop(count);
            return this;
        }

        public <T> Pair<T, CompatConfigSpec> configure(Function<Builder, T> consumer) {
            T o = consumer.apply(this);
            return Pair.of(o, (Object)this.build());
        }

        public CompatConfigSpec build() {
            this.context.ensureEmpty();
            return new CompatConfigSpec(this.builder.build());
        }

        public static interface BuilderConsumer {
            public void accept(Builder var1);
        }
    }

    public static interface CompatConfigHandler {
        public void onConfigChanged();
    }
}

