/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.emoji;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.teamfruit.emojicord.emoji.DiscordEmojiIdDictionary;
import net.teamfruit.emojicord.emoji.EmojiContext;
import net.teamfruit.emojicord.emoji.EmojiId;
import net.teamfruit.emojicord.emoji.StandardEmojiIdDictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class EmojiText {
    @Nonnull
    public static final Function<Integer, String> placeHolderSupplier = e -> String.format("{%d}", e);
    @Nonnull
    public static final Pattern placeHolderPattern = Pattern.compile("\\{(\\d+?)\\}");
    @Nonnull
    public final String text;
    @Nonnull
    public final ImmutableList<EmojiTextElement> emojis;

    public EmojiText(String text, ImmutableList<EmojiTextElement> emojis) {
        this.text = text;
        this.emojis = emojis;
    }

    private static EmojiText createUnparsed(String text) {
        return new EmojiText(text, (ImmutableList<EmojiTextElement>)ImmutableList.of());
    }

    public static EmojiText create(String text, EnumSet<ParseFlag> flags) {
        EmojiText emojiText = EmojiText.createUnparsed(text);
        if (flags.contains((Object)ParseFlag.ESCAPE)) {
            emojiText = EmojiTextParser.escape(emojiText);
        }
        if (flags.contains((Object)ParseFlag.ENCODE)) {
            emojiText = EmojiTextParser.encode(emojiText);
        }
        if (flags.contains((Object)ParseFlag.ENCODE_ALIAS)) {
            emojiText = EmojiTextParser.encodeAlias(emojiText);
        }
        if (flags.contains((Object)ParseFlag.ENCODE_UTF)) {
            emojiText = EmojiTextParser.encodeUtf(emojiText);
        }
        if (flags.contains((Object)ParseFlag.PARSE)) {
            emojiText = EmojiTextParser.parse(emojiText);
        }
        return emojiText;
    }

    public String getEncoded() {
        Matcher matcher = placeHolderPattern.matcher(this.text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int emojiIndex = NumberUtils.toInt((String)matcher.group(1), (int)-1);
            if (0 > emojiIndex || emojiIndex >= this.emojis.size()) continue;
            EmojiTextElement entry = (EmojiTextElement)this.emojis.get(emojiIndex);
            matcher.appendReplacement(sb, entry.encoded);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public EmojiContext getEmojiContext() {
        HashMap emojiMap = Maps.newHashMap();
        Matcher matcher = placeHolderPattern.matcher(StringUtils.remove((String)this.text, (char)'\u0000'));
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int emojiIndex = NumberUtils.toInt((String)matcher.group(1), (int)-1);
            if (0 > emojiIndex || emojiIndex >= this.emojis.size()) continue;
            EmojiTextElement entry = (EmojiTextElement)this.emojis.get(emojiIndex);
            if (entry.id == null) {
                matcher.appendReplacement(sb, entry.raw);
                continue;
            }
            matcher.appendReplacement(sb, String.valueOf('\u0000'));
            int index = sb.length() - 1;
            emojiMap.put(index, entry);
        }
        matcher.appendTail(sb);
        return new EmojiContext(sb.toString(), emojiMap);
    }

    public static class EmojiTextParser {
        @Nonnull
        static final Pattern colorPattern = Pattern.compile("(?i)\u00a7([0-9A-FK-OR])");
        @Nonnull
        static final Pattern pattern = Pattern.compile("<a?\\:(\\w+?)\\:([a-zA-Z0-9+/=]+?)>|\\:([\\w+-]+?(?:~\\d+?)?)\\:(?:\\:skin-tone-(\\d)\\:)?");

        public static EmojiText escape(EmojiText emojiText) {
            emojiText = EmojiTextBuilder.builder(placeHolderPattern, emojiText).apply(matcher -> {
                String g0 = matcher.group(0);
                return new EmojiTextElement(null, g0, g0, "");
            });
            emojiText = EmojiTextBuilder.builder(colorPattern, emojiText).apply(matcher -> {
                String g0 = matcher.group(0);
                return new EmojiTextElement(null, g0, g0, "");
            });
            return emojiText;
        }

        public static EmojiText parse(EmojiText emojiText) {
            emojiText = EmojiTextBuilder.builder(pattern, emojiText).apply(matcher -> {
                String g0 = matcher.group(0);
                String g1 = matcher.group(1);
                String g2 = matcher.group(2);
                if (!StringUtils.isEmpty((CharSequence)g2)) {
                    if (StringUtils.length((CharSequence)g2) > 12) {
                        return new EmojiTextElement(EmojiId.DiscordEmojiId.fromDecimalId(g2), g0, g0, String.format(":%s:", g1));
                    }
                    return new EmojiTextElement(EmojiId.DiscordEmojiId.fromEncodedId(g2), g0, g0, String.format(":%s:", g1));
                }
                return null;
            }, matcher -> {
                String g0 = matcher.group(0);
                String g3 = matcher.group(3);
                String g4 = matcher.group(4);
                if (!StringUtils.isEmpty((CharSequence)g3)) {
                    if (!StringUtils.isEmpty((CharSequence)g4)) {
                        String source = String.format(":%s::skin-tone-%s:", g3, g4);
                        EmojiId emojiId = EmojiId.StandardEmojiId.fromAlias(String.format("%s:skin-tone-%s", g3, g4));
                        if (emojiId == null) {
                            source = g3;
                            emojiId = EmojiId.StandardEmojiId.fromAlias(g3);
                        }
                        return new EmojiTextElement(emojiId, g0, g0, source);
                    }
                    return new EmojiTextElement(EmojiId.StandardEmojiId.fromAlias(g3), g0, g0, String.format(":%s:", g3));
                }
                return null;
            });
            return emojiText;
        }

        public static EmojiText encode(EmojiText emojiText) {
            emojiText = EmojiTextBuilder.builder(pattern, emojiText).apply(matcher -> {
                EmojiId emojiId;
                String g0 = matcher.group(0);
                String g3 = matcher.group(3);
                if (!StringUtils.isEmpty((CharSequence)g3) && EmojiId.StandardEmojiId.fromAlias(g3) == null && (emojiId = DiscordEmojiIdDictionary.instance.get(g3)) instanceof EmojiId.DiscordEmojiId) {
                    return new EmojiTextElement(emojiId, g0, String.format("<:%s:%s>", StringUtils.substringBefore((String)g3, (String)"~"), ((EmojiId.DiscordEmojiId)emojiId).getEncodedId()), String.format(":%s:", g3));
                }
                return null;
            });
            return emojiText;
        }

        public static EmojiText encodeAlias(EmojiText emojiText) {
            emojiText = EmojiTextBuilder.builder(StandardEmojiIdDictionary.instance.shortAliasPattern, emojiText).apply(matcher -> {
                String g0 = matcher.group(0);
                EmojiId emojiId = EmojiId.StandardEmojiId.fromAlias(g0);
                if (emojiId != null) {
                    return new EmojiTextElement(emojiId, g0, String.format(":%s:", emojiId.getCacheName()), String.format(":%s:", emojiId.getCacheName()));
                }
                return null;
            });
            return emojiText;
        }

        public static EmojiText encodeUtf(EmojiText emojiText) {
            emojiText = EmojiTextBuilder.builder(StandardEmojiIdDictionary.instance.utfPattern, emojiText).apply(matcher -> {
                String g0 = matcher.group(0);
                EmojiId emojiId = EmojiId.StandardEmojiId.fromUtf(g0);
                if (emojiId != null) {
                    String id = String.format(":%s:", emojiId.getCacheName().replace(":", "::"));
                    return new EmojiTextElement(emojiId, id, id, id);
                }
                return null;
            });
            return emojiText;
        }
    }

    public static class EmojiTextBuilder {
        public final Matcher matcher;
        private final StringBuffer sb;
        private final ImmutableList.Builder<EmojiTextElement> emojis;
        private int size;

        private EmojiTextBuilder(Matcher matcher, StringBuffer sb, ImmutableList.Builder<EmojiTextElement> emojis, int size) {
            this.matcher = matcher;
            this.sb = sb;
            this.emojis = emojis;
            this.size = size;
        }

        public EmojiTextBuilder append(EmojiTextElement element) {
            this.matcher.appendReplacement(this.sb, placeHolderSupplier.apply(this.size++));
            this.emojis.add((Object)element);
            return this;
        }

        public EmojiText build() {
            this.matcher.appendTail(this.sb);
            return new EmojiText(this.sb.toString(), (ImmutableList<EmojiTextElement>)this.emojis.build());
        }

        public EmojiText apply(EmojiTextTransformer transformer) {
            EmojiTextGroupSupplierImpl supplier = new EmojiTextGroupSupplierImpl();
            while (this.matcher.find()) {
                EmojiTextElement element = transformer.transform(supplier);
                if (element == null) continue;
                this.append(element);
            }
            return this.build();
        }

        public EmojiText apply(EmojiTextTransformer ... transformers) {
            EmojiTextGroupSupplierImpl supplier = new EmojiTextGroupSupplierImpl();
            while (this.matcher.find()) {
                for (EmojiTextTransformer transformer : transformers) {
                    EmojiTextElement element = transformer.transform(supplier);
                    if (element == null) continue;
                    this.append(element);
                }
            }
            return this.build();
        }

        public static EmojiTextBuilder builder(Pattern pattern, EmojiText emojiText) {
            return new EmojiTextBuilder(pattern.matcher(emojiText.text), new StringBuffer(), (ImmutableList.Builder<EmojiTextElement>)ImmutableList.builder().addAll(emojiText.emojis), emojiText.emojis.size());
        }

        public static interface EmojiTextTransformer {
            @Nullable
            public EmojiTextElement transform(EmojiTextGroupSupplier var1);
        }

        private class EmojiTextGroupSupplierImpl
        implements EmojiTextGroupSupplier {
            private EmojiTextGroupSupplierImpl() {
            }

            @Override
            public String group(int i) {
                return EmojiTextBuilder.this.matcher.group(i);
            }
        }

        public static interface EmojiTextGroupSupplier {
            public String group(int var1);
        }
    }

    public static class EmojiTextElement {
        @Nullable
        public final EmojiId id;
        public final String raw;
        public final String encoded;
        public final String source;

        public EmojiTextElement(@Nullable EmojiId id, String raw, String encoded, String source) {
            this.id = id;
            this.raw = raw;
            this.encoded = encoded;
            this.source = source;
        }
    }

    public static enum ParseFlag {
        ESCAPE,
        ENCODE,
        ENCODE_ALIAS,
        ENCODE_UTF,
        PARSE;

    }
}

