/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.emoji;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.teamfruit.emojicord.emoji.EmojiId;
import net.teamfruit.emojicord.emoji.EmojiText;
import net.teamfruit.emojicord.emoji.StandardEmojiIdDictionary;
import org.apache.commons.lang3.StringUtils;

public class PickerItem {
    public final String text;
    public final String name;
    public final List<String> alias;
    public final EmojiId id;

    public PickerItem(String text, String name, List<String> alias, EmojiId id) {
        this.text = text;
        this.name = name;
        this.alias = alias;
        this.id = id;
    }

    @Nullable
    public static PickerItem fromCategory(String text) {
        if (text == null) {
            return null;
        }
        String[] split = StringUtils.split((String)text);
        if (split.length <= 0) {
            return null;
        }
        String name = split[0];
        List<String> alias = Stream.of(split).map(e -> StringUtils.strip((String)e, (String)":")).collect(Collectors.toList());
        EmojiId id = (EmojiId)StandardEmojiIdDictionary.instance.aliasDictionary.get((Object)StringUtils.strip((String)name, (String)":"));
        if (id == null) {
            return null;
        }
        return new PickerItem(text, name, alias, id);
    }

    @Nullable
    public static PickerItem fromUsed(String text, EmojiId id) {
        if (text == null) {
            return null;
        }
        ArrayList alias = Lists.newArrayList((Object[])new String[]{StringUtils.strip((String)text, (String)":")});
        if (id == null) {
            return null;
        }
        return new PickerItem(text, text, alias, id);
    }

    public static List<PickerItem> fromText(EmojiText emojiText) {
        return emojiText.emojis.stream().filter(e -> e.id != null && e.raw != null).map(e -> new PickerItem(e.source, e.encoded, Lists.newArrayList((Object[])new String[]{StringUtils.strip((String)e.source, (String)":")}), e.id)).filter(e -> e != null).collect(Collectors.toList());
    }
}

