/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.gui;

public class Rectangle2d {
    private int x;
    private int y;
    private int width;
    private int height;

    public Rectangle2d(int xIn, int yIn, int widthIn, int heightIn) {
        this.x = xIn;
        this.y = yIn;
        this.width = widthIn;
        this.height = heightIn;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle2d inner(int left, int top, int right, int bottom) {
        return new Rectangle2d(this.x + left, this.y + top, this.width - (left + right), this.height - (top + bottom));
    }

    public Rectangle2d outer(int left, int top, int right, int bottom) {
        return new Rectangle2d(this.x - left, this.y - top, this.width + left + right, this.height + top + bottom);
    }

    public boolean contains(int x, int y) {
        return x >= this.x && x <= this.x + this.width && y >= this.y && y <= this.y + this.height;
    }

    public boolean contains(Rectangle2d rect) {
        int x = rect.getX();
        int y = rect.getY();
        int x2 = x + rect.getWidth();
        int y2 = y + rect.getHeight();
        return x >= this.x && x2 <= this.x + this.width && y >= this.y && y2 <= this.y + this.height;
    }

    public boolean overlap(Rectangle2d rect) {
        int x = rect.getX();
        int y = rect.getY();
        int x2 = x + rect.getWidth();
        int y2 = y + rect.getHeight();
        return x2 >= this.x && x <= this.x + this.width && y2 >= this.y && y <= this.y + this.height;
    }
}

