/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockGoldPile
extends Block {
    public static final IntegerProperty LAYERS = IntegerProperty.func_177719_a((String)"layers", (int)1, (int)8);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{VoxelShapes.func_197880_a(), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    public Item itemBlock;

    public BlockGoldPile(String name) {
        super(Block.Properties.func_200945_a((Material)Material.field_151578_c).func_200948_a(0.3f, 1.0f).func_200944_c().func_200947_a(IafBlockRegistry.SOUND_TYPE_GOLD));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)LAYERS, (Comparable)Integer.valueOf(1)));
        this.setRegistryName("iceandfire", name);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Integer)state.func_177229_b((IProperty)LAYERS) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((IProperty)LAYERS)];
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((IProperty)LAYERS) - 1];
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        Block block = blockstate.func_177230_c();
        if (block != Blocks.field_150432_aD && block != Blocks.field_150403_cj && block != Blocks.field_180401_cv) {
            if (block != Blocks.field_226907_mc_ && block != Blocks.field_150425_aM) {
                return Block.func_208061_a((VoxelShape)blockstate.func_196952_d((IBlockReader)worldIn, pos.func_177977_b()), (Direction)Direction.UP) || block instanceof BlockGoldPile && (Integer)blockstate.func_177229_b((IProperty)LAYERS) == 8;
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean canEntitySpawn(BlockState state, Entity entityIn) {
        return false;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (blockstate.func_177230_c() == this) {
            int i = (Integer)blockstate.func_177229_b((IProperty)LAYERS);
            return (BlockState)blockstate.func_206870_a((IProperty)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.func_196258_a(context);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{LAYERS});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult resultIn) {
        ItemStack item = playerIn.field_71071_by.func_70448_g();
        if (!item.func_190926_b() && item.func_77973_b() != null && item.func_77973_b() == Item.func_150898_a((Block)this) && !item.func_190926_b() && (Integer)state.func_177229_b((IProperty)LAYERS) < 8) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)LAYERS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)LAYERS) + 1)), 3);
            if (!playerIn.func_184812_l_()) {
                item.func_190918_g(1);
                if (item.func_190926_b()) {
                    playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                } else {
                    playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, item);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

