/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.gui;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforge;
import com.github.alexthe666.iceandfire.inventory.ContainerDragonForge;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiDragonForge
extends ContainerScreen<ContainerDragonForge> {
    private static final ResourceLocation TEXTURE_FIRE = new ResourceLocation("iceandfire:textures/gui/dragonforge_fire.png");
    private static final ResourceLocation TEXTURE_ICE = new ResourceLocation("iceandfire:textures/gui/dragonforge_ice.png");
    private static final ResourceLocation TEXTURE_LIGHTNING = new ResourceLocation("iceandfire:textures/gui/dragonforge_lightning.png");
    private final PlayerInventory playerInventory;
    private ContainerDragonForge tileFurnace;
    private int dragonType;

    public GuiDragonForge(ContainerDragonForge container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.playerInventory = inv;
        this.tileFurnace = container;
        if (this.tileFurnace instanceof ContainerDragonForge) {
            this.dragonType = this.tileFurnace.isFire;
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.tileFurnace != null) {
            String s = I18n.func_135052_a((String)("block.iceandfire.dragonforge_" + DragonType.getNameFromInt(this.dragonType) + "_core"), (Object[])new Object[0]);
            this.font.func_211126_b(s, (float)(this.field_146999_f / 2 - this.font.func_78256_a(s) / 2), 6.0f, 0x404040);
        }
        this.font.func_211126_b(this.playerInventory.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.dragonType == 0) {
            this.minecraft.func_110434_K().func_110577_a(TEXTURE_FIRE);
        } else if (this.dragonType == 1) {
            this.minecraft.func_110434_K().func_110577_a(TEXTURE_ICE);
        } else {
            this.minecraft.func_110434_K().func_110577_a(TEXTURE_LIGHTNING);
        }
        int k = (this.width - this.field_146999_f) / 2;
        int l = (this.height - this.field_147000_g) / 2;
        this.blit(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        int i1 = this.func_175381_h(126);
        this.blit(k + 12, l + 23, 0, 166, i1, 38);
    }

    private int func_175381_h(int p_175381_1_) {
        TileEntity te = IceAndFire.PROXY.getRefrencedTE();
        int j = 0;
        int maxCookTime = 1000;
        if (te instanceof TileEntityDragonforge) {
            maxCookTime = ((TileEntityDragonforge)te).getMaxCookTime(this.tileFurnace.func_75139_a(0).func_75211_c(), this.tileFurnace.func_75139_a(1).func_75211_c());
            j = Math.min(((TileEntityDragonforge)te).cookTime, maxCookTime);
        }
        return j != 0 ? j * p_175381_1_ / maxCookTime : 0;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }
}

