/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.gui;

import com.github.alexthe666.iceandfire.ClientProxy;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.message.MessageGetMyrmexHive;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiMyrmexAddRoom
extends Screen {
    private static final ResourceLocation JUNGLE_TEXTURE = new ResourceLocation("iceandfire:textures/gui/myrmex_staff_jungle.png");
    private static final ResourceLocation DESERT_TEXTURE = new ResourceLocation("iceandfire:textures/gui/myrmex_staff_desert.png");
    private ItemStack staff;
    private boolean jungle;
    private BlockPos interactPos;
    private Direction facing;

    public GuiMyrmexAddRoom(ItemStack staff, BlockPos interactPos, Direction facing) {
        super((ITextComponent)new TranslationTextComponent("myrmex_add_room", new Object[0]));
        this.staff = staff;
        this.jungle = staff.func_77973_b() == IafItemRegistry.MYRMEX_JUNGLE_STAFF;
        this.interactPos = interactPos;
        this.facing = facing;
        this.init();
    }

    public void init() {
        super.init();
        this.buttons.clear();
        int i = (this.width - 248) / 2;
        int j = (this.height - 166) / 2;
        if (ClientProxy.getReferedClientHive() != null) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            this.addButton((Widget)new Button(i + 50, j + 35, 150, 20, I18n.func_135052_a((String)"myrmex.message.establishroom_food", (Object[])new Object[0]), arg_0 -> this.lambda$init$0((PlayerEntity)player, arg_0)));
            this.addButton((Widget)new Button(i + 50, j + 60, 150, 20, I18n.func_135052_a((String)"myrmex.message.establishroom_nursery", (Object[])new Object[0]), arg_0 -> this.lambda$init$1((PlayerEntity)player, arg_0)));
            this.addButton((Widget)new Button(i + 50, j + 85, 150, 20, I18n.func_135052_a((String)"myrmex.message.establishroom_enterance_surface", (Object[])new Object[0]), arg_0 -> this.lambda$init$2((PlayerEntity)player, arg_0)));
            this.addButton((Widget)new Button(i + 50, j + 110, 150, 20, I18n.func_135052_a((String)"myrmex.message.establishroom_enterance_bottom", (Object[])new Object[0]), arg_0 -> this.lambda$init$3((PlayerEntity)player, arg_0)));
            this.addButton((Widget)new Button(i + 50, j + 135, 150, 20, I18n.func_135052_a((String)"myrmex.message.establishroom_misc", (Object[])new Object[0]), arg_0 -> this.lambda$init$4((PlayerEntity)player, arg_0)));
        }
    }

    public void renderBackground() {
        super.renderBackground();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(this.jungle ? JUNGLE_TEXTURE : DESERT_TEXTURE);
        int i = (this.width - 248) / 2;
        int j = (this.height - 166) / 2;
        this.blit(i, j, 0, 0, 248, 166);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int color;
        this.renderBackground();
        this.init();
        int i = (this.width - 248) / 2 + 10;
        int j = (this.height - 166) / 2 + 8;
        super.render(mouseX, mouseY, partialTicks);
        int n = color = this.jungle ? 3533333 : 0xFFBF00;
        if (ClientProxy.getReferedClientHive() != null) {
            if (!ClientProxy.getReferedClientHive().colonyName.isEmpty()) {
                String title = I18n.func_135052_a((String)"myrmex.message.colony_named", (Object[])new Object[]{ClientProxy.getReferedClientHive().colonyName});
                this.font.func_175063_a(title, (float)(i + 40 - title.length() / 2), (float)(j - 3), color);
            } else {
                this.font.func_175063_a(I18n.func_135052_a((String)"myrmex.message.colony", (Object[])new Object[0]), (float)(i + 80), (float)(j - 3), color);
            }
            this.font.func_175063_a(I18n.func_135052_a((String)"myrmex.message.create_new_room", (Object[])new Object[]{this.interactPos.func_177958_n(), this.interactPos.func_177956_o(), this.interactPos.func_177952_p()}), (float)(i + 30), (float)(j + 6), color);
        }
    }

    public void onGuiClosed() {
        IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageGetMyrmexHive(ClientProxy.getReferedClientHive().toNBT()));
    }

    public boolean isPauseScreen() {
        return false;
    }

    private /* synthetic */ void lambda$init$4(PlayerEntity player, Button p_214132_1_) {
        ClientProxy.getReferedClientHive().addRoomWithMessage(player, this.interactPos, WorldGenMyrmexHive.RoomType.EMPTY);
        this.onGuiClosed();
        Minecraft.func_71410_x().func_147108_a(null);
    }

    private /* synthetic */ void lambda$init$3(PlayerEntity player, Button p_214132_1_) {
        ClientProxy.getReferedClientHive().addEnteranceWithMessage(player, true, this.interactPos, this.facing);
        this.onGuiClosed();
        Minecraft.func_71410_x().func_147108_a(null);
    }

    private /* synthetic */ void lambda$init$2(PlayerEntity player, Button p_214132_1_) {
        ClientProxy.getReferedClientHive().addEnteranceWithMessage(player, false, this.interactPos, this.facing);
        this.onGuiClosed();
        Minecraft.func_71410_x().func_147108_a(null);
    }

    private /* synthetic */ void lambda$init$1(PlayerEntity player, Button p_214132_1_) {
        ClientProxy.getReferedClientHive().addRoomWithMessage(player, this.interactPos, WorldGenMyrmexHive.RoomType.NURSERY);
        this.onGuiClosed();
        Minecraft.func_71410_x().func_147108_a(null);
    }

    private /* synthetic */ void lambda$init$0(PlayerEntity player, Button p_214132_1_) {
        ClientProxy.getReferedClientHive().addRoomWithMessage(player, this.interactPos, WorldGenMyrmexHive.RoomType.FOOD);
        this.onGuiClosed();
        Minecraft.func_71410_x().func_147108_a(null);
    }
}

