/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.gui;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.gui.GuiMainMenuBlit;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.StringUtils;

public class IceAndFireMainMenu
extends MainMenuScreen {
    public static final int LAYER_COUNT = 2;
    public static final ResourceLocation splash = new ResourceLocation("iceandfire", "splashes.txt");
    private static final ResourceLocation MINECRAFT_TITLE_TEXTURES = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation BESTIARY_TEXTURE = new ResourceLocation("iceandfire:textures/gui/main_menu/bestiary_menu.png");
    private static final ResourceLocation TABLE_TEXTURE = new ResourceLocation("iceandfire:textures/gui/main_menu/table.png");
    public static ResourceLocation[] pageFlipTextures;
    public static ResourceLocation[] drawingTextures;
    private final String[] namePartsArray = "Go Play My Other Mods Like Fossils Archeology Revival and Rats And Soon To Be Joined By Other Cool Stuff Too Dont Play The Knock Off Mods".split(" ");
    private int layerTick;
    private String splashText;
    private boolean isFlippingPage = false;
    private int pageFlip = 0;
    private Picture[] drawnPictures;
    private Enscription[] drawnEnscriptions;
    private float globalAlpha = 1.0f;
    private int zLevel = 200;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceAndFireMainMenu() {
        pageFlipTextures = new ResourceLocation[]{new ResourceLocation("iceandfire", "textures/gui/main_menu/page_1.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_2.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_3.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_4.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_5.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_6.png")};
        for (int i = 0; i < drawingTextures.length; ++i) {
            IceAndFireMainMenu.drawingTextures[i] = new ResourceLocation("iceandfire", "textures/gui/main_menu/drawing_" + (i + 1) + ".png");
        }
        this.resetDrawnImages();
        BufferedReader reader = null;
        try {
            String s;
            ArrayList<String> list = new ArrayList<String>();
            String branch = "1.15.2";
            reader = IceAndFireMainMenu.getURLContents("https://raw.githubusercontent.com/Alex-the-666/Ice_and_Fire/" + branch + "/src/main/resources/assets/iceandfire/splashes.txt", "assets/iceandfire/splashes.txt");
            while ((s = reader.readLine()) != null) {
                if ((s = s.trim()).isEmpty()) continue;
                list.add(s);
            }
            if (!list.isEmpty()) {
                do {
                    this.splashText = (String)list.get(new Random().nextInt(list.size()));
                } while (this.splashText.hashCode() == 125780783);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static BufferedReader getURLContents(String urlString, String backupFileLoc) {
        InputStream is;
        URL url;
        BufferedReader reader = null;
        boolean useBackup = false;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            url = null;
            useBackup = true;
        }
        if (url != null) {
            URLConnection connection = null;
            try {
                connection = url.openConnection();
                InputStream is2 = connection.getInputStream();
                reader = new BufferedReader(new InputStreamReader(is2));
            }
            catch (IOException e) {
                IceAndFire.LOGGER.warn("Ice and Fire couldn't download splash texts for main menu");
                useBackup = true;
            }
        }
        if (useBackup && (is = IceAndFireMainMenu.class.getClassLoader().getResourceAsStream(backupFileLoc)) != null) {
            reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        }
        return reader;
    }

    public void drawCenteredString(FontRenderer fontRenderer, String string, int x, int y, int color) {
        if (string.equals(this.splashText)) {
            fontRenderer.func_175063_a(string, (float)(x - fontRenderer.func_78256_a(string) / 2), (float)y, 15853921);
        } else {
            fontRenderer.func_175063_a(string, (float)(x - fontRenderer.func_78256_a(string) / 2), (float)y, color);
        }
    }

    public void init() {
        super.init();
    }

    private void resetDrawnImages() {
        int x;
        int y;
        int i;
        this.globalAlpha = 0.0f;
        Random random = new Random();
        this.drawnPictures = new Picture[1 + random.nextInt(2)];
        int cornerRight = 32;
        int cornerLeft = 32;
        boolean left = random.nextBoolean();
        for (i = 0; i < this.drawnPictures.length; ++i) {
            left = !left;
            y = random.nextInt(25);
            x = left ? -15 - random.nextInt(20) - 128 : 30 + random.nextInt(20);
            this.drawnPictures[i] = new Picture(random.nextInt(drawingTextures.length - 1), x, y, 0.5f, random.nextFloat() * 0.5f + 0.5f);
        }
        this.drawnEnscriptions = new Enscription[4 + random.nextInt(8)];
        for (i = 0; i < this.drawnEnscriptions.length; ++i) {
            left = !left;
            y = 10 + random.nextInt(130);
            x = left ? -30 - random.nextInt(30) - 50 : 30 + random.nextInt(30);
            String s1 = this.generateNewRandomName(Minecraft.func_71410_x().field_71466_p, 50, random);
            this.drawnEnscriptions[i] = new Enscription(s1, x, y, random.nextFloat() * 0.5f + 0.5f, 10259323);
        }
    }

    public void tick() {
        super.tick();
        float flipTick = this.layerTick % 40;
        if (this.globalAlpha < 1.0f && !this.isFlippingPage && flipTick < 30.0f) {
            this.globalAlpha += 0.1f;
        }
        if (this.globalAlpha > 0.0f && flipTick > 30.0f) {
            this.globalAlpha -= 0.1f;
        }
        if (flipTick == 0.0f && !this.isFlippingPage) {
            this.isFlippingPage = true;
        }
        if (this.isFlippingPage) {
            if (this.layerTick % 2 == 0) {
                ++this.pageFlip;
            }
            if (this.pageFlip == 6) {
                this.pageFlip = 0;
                this.isFlippingPage = false;
                this.resetDrawnImages();
            }
        }
        ++this.layerTick;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int i;
        FontRenderer fontrenderer = this.minecraft.func_211500_ak().func_211504_a(Minecraft.field_71464_q);
        GlStateManager.func_227619_H_();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227740_m_();
        this.minecraft.func_110434_K().func_110577_a(TABLE_TEXTURE);
        IceAndFireMainMenu.blit((int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
        this.minecraft.func_110434_K().func_110577_a(BESTIARY_TEXTURE);
        IceAndFireMainMenu.blit((int)50, (int)0, (float)0.0f, (float)0.0f, (int)(this.width - 100), (int)this.height, (int)(this.width - 100), (int)this.height);
        if (this.isFlippingPage) {
            this.minecraft.func_110434_K().func_110577_a(pageFlipTextures[Math.min(5, this.pageFlip)]);
            IceAndFireMainMenu.blit((int)50, (int)0, (float)0.0f, (float)0.0f, (int)(this.width - 100), (int)this.height, (int)(this.width - 100), (int)this.height);
        } else {
            int middleX = this.width / 2;
            int middleY = this.height / 5;
            float widthScale = (float)this.width / 427.0f;
            float imageScale = widthScale * 128.0f;
            for (Enscription enscription : this.drawnEnscriptions) {
                float f2 = 60.0f - partialTicks;
                int color = 10259323;
                int opacity = 10 + (int)(255.0f * enscription.alpha * this.globalAlpha);
                fontrenderer.func_211126_b(enscription.text, (float)((int)((float)enscription.x * widthScale) + middleX), (float)((int)((float)enscription.y * widthScale) + middleY), color | opacity << 24);
            }
            for (Picture picture : this.drawnPictures) {
                float alpha = picture.alpha * this.globalAlpha + 0.01f;
                RenderSystem.enableBlend();
                this.minecraft.func_110434_K().func_110577_a(drawingTextures[picture.image]);
                GuiMainMenuBlit.blit((int)((float)picture.x * widthScale + (float)middleX), (int)((float)picture.y * widthScale + (float)middleY), 0.0f, 0.0f, (int)imageScale, (int)imageScale, (int)imageScale, (int)imageScale, alpha);
            }
        }
        GlStateManager.func_227619_H_();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227740_m_();
        this.font.func_175063_a("Ice and Fire " + ChatFormatting.YELLOW + "2.1.0-1.15.2", 2.0f, (float)(this.height - 10), -1);
        GlStateManager.func_227626_N_();
        this.minecraft.func_110434_K().func_110577_a(MINECRAFT_TITLE_TEXTURES);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(this.width / 2 - 137, 10, 0, 0, 155, 44);
        this.blit(this.width / 2 - 137 + 155, 10, 0, 45, 155, 44);
        GlStateManager.func_227688_c_((float)(this.width / 2 + 100), (float)85.0f, (float)0.0f);
        GlStateManager.func_227689_c_((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f1 = 1.8f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(System.currentTimeMillis() % 1000L) / 1000.0f * (float)Math.PI * 2.0f)) * 0.1f));
        f1 = f1 * 100.0f / (float)(this.font.func_78256_a(this.splashText) + 32);
        GlStateManager.func_227688_c_((float)0.0f, (float)(f1 * 10.0f), (float)0.0f);
        GlStateManager.func_227672_b_((float)f1, (float)f1, (float)f1);
        this.drawCenteredString(this.font, this.splashText, 0, -40, 0xFFFFFF);
        GlStateManager.func_227627_O_();
        ForgeHooksClient.renderMainMenu((MainMenuScreen)this, (FontRenderer)this.font, (int)this.width, (int)this.height);
        String s1 = "Copyright Mojang AB. Do not distribute!";
        this.drawString(this.font, s1, this.width - this.font.func_78256_a(s1) - 2, this.height - 10, -1);
        for (i = 0; i < this.buttons.size(); ++i) {
            ((Widget)this.buttons.get(i)).render(mouseX, mouseY, this.minecraft.func_184121_ak());
        }
        for (i = 0; i < this.buttons.size(); ++i) {
            ((Widget)this.buttons.get(i)).render(mouseX, mouseY, this.minecraft.func_184121_ak());
        }
    }

    public String generateNewRandomName(FontRenderer fontRendererIn, int length, Random rand) {
        int i = rand.nextInt(2) + 3;
        String s = "";
        for (int j = 0; j < i; ++j) {
            if (j > 0) {
                s = s + " ";
            }
            s = s + this.namePartsArray[rand.nextInt(this.namePartsArray.length)];
        }
        List list = fontRendererIn.func_78271_c(s, length);
        return StringUtils.join((Iterable)(list.size() >= 2 ? list.subList(0, 2) : list), (String)" ");
    }

    static {
        drawingTextures = new ResourceLocation[22];
    }

    private class Enscription {
        String text;
        int x;
        int y;
        int color;
        float alpha;

        public Enscription(String text, int x, int y, float alpha, int color) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.alpha = alpha;
            this.color = color;
        }
    }

    private class Picture {
        int image;
        int x;
        int y;
        float alpha;
        float scale;

        public Picture(int image, int x, int y, float alpha, float scale) {
            this.image = image;
            this.x = x;
            this.y = y;
            this.alpha = alpha;
            this.scale = scale;
        }
    }
}

