/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model;

import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.iceandfire.client.model.ModelDragonBase;
import com.github.alexthe666.iceandfire.client.model.util.EntityModelPartBuilder;
import com.github.alexthe666.iceandfire.client.model.util.HideableModelRenderer;
import com.github.alexthe666.iceandfire.entity.EntityDreadThrall;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;

public class ModelDreadThrall
extends ModelDragonBase<EntityDreadThrall>
implements IHasArm {
    public HideableModelRenderer bipedHead;
    public HideableModelRenderer bipedHeadwear;
    public HideableModelRenderer bipedBody;
    public HideableModelRenderer bipedRightArm;
    public HideableModelRenderer bipedLeftArm;
    public HideableModelRenderer bipedRightLeg;
    public HideableModelRenderer bipedLeftLeg;
    public BipedModel.ArmPose leftArmPose;
    public BipedModel.ArmPose rightArmPose;
    public boolean isSneak;
    private ModelAnimator animator;
    private boolean armor = false;

    public ModelDreadThrall(float modelSize, boolean armorArms) {
        this.armor = armorArms;
        this.field_78089_u = 32;
        this.field_78090_t = 64;
        this.leftArmPose = BipedModel.ArmPose.EMPTY;
        this.rightArmPose = BipedModel.ArmPose.EMPTY;
        this.bipedBody = new HideableModelRenderer(this, 16, 16);
        this.bipedBody.func_228301_a_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, modelSize);
        this.bipedBody.func_78793_a(0.0f, 0.0f, 0.0f);
        this.bipedRightArm = new HideableModelRenderer(this, 40, 16);
        this.bipedRightArm.func_228301_a_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, modelSize);
        this.bipedRightArm.func_78793_a(-5.0f, 2.0f, 0.0f);
        this.bipedLeftArm = new HideableModelRenderer(this, 40, 16);
        this.bipedLeftArm.field_78809_i = true;
        this.bipedLeftArm.func_228301_a_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, modelSize);
        this.bipedLeftArm.func_78793_a(5.0f, 2.0f, 0.0f);
        this.bipedRightLeg = new HideableModelRenderer(this, 0, 16);
        this.bipedRightLeg.func_228301_a_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, modelSize);
        this.bipedRightLeg.func_78793_a(-2.0f, 12.0f, 0.0f);
        this.bipedLeftLeg = new HideableModelRenderer(this, 0, 16);
        this.bipedLeftLeg.field_78809_i = true;
        this.bipedLeftLeg.func_228301_a_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, modelSize);
        this.bipedLeftLeg.func_78793_a(2.0f, 12.0f, 0.0f);
        this.bipedHead = new HideableModelRenderer(this, 0, 0);
        this.bipedHead.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, modelSize - 0.5f);
        this.bipedHead.func_78793_a(0.0f, 0.0f, 0.0f);
        this.bipedHeadwear = new HideableModelRenderer(this, 32, 0);
        this.bipedHeadwear.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, modelSize);
        this.bipedHeadwear.func_78793_a(0.0f, 0.0f, 0.0f);
        if (armorArms) {
            this.bipedHead = new HideableModelRenderer(this, 0, 0);
            this.bipedHead.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, modelSize);
            this.bipedHead.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bipedHeadwear = new HideableModelRenderer(this, 32, 0);
            this.bipedHeadwear.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, modelSize + 0.5f);
            this.bipedHeadwear.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bipedBody = new HideableModelRenderer(this, 16, 16);
            this.bipedBody.func_228301_a_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, modelSize);
            this.bipedBody.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bipedRightArm = new HideableModelRenderer(this, 40, 16);
            this.bipedRightArm.func_228301_a_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
            this.bipedRightArm.func_78793_a(-5.0f, 2.0f, 0.0f);
            this.bipedLeftArm = new HideableModelRenderer(this, 40, 16);
            this.bipedLeftArm.field_78809_i = true;
            this.bipedLeftArm.func_228301_a_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
            this.bipedLeftArm.func_78793_a(5.0f, 2.0f, 0.0f);
            this.bipedRightLeg = new HideableModelRenderer(this, 0, 16);
            this.bipedRightLeg.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
            this.bipedRightLeg.func_78793_a(-1.9f, 12.0f, 0.0f);
            this.bipedLeftLeg = new HideableModelRenderer(this, 0, 16);
            this.bipedLeftLeg.field_78809_i = true;
            this.bipedLeftLeg.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
            this.bipedLeftLeg.func_78793_a(1.9f, 12.0f, 0.0f);
        }
        this.bipedBody.func_78792_a((ModelRenderer)this.bipedHead);
        this.bipedHead.func_78792_a((ModelRenderer)this.bipedHeadwear);
        this.bipedBody.func_78792_a((ModelRenderer)this.bipedRightArm);
        this.bipedBody.func_78792_a((ModelRenderer)this.bipedLeftArm);
        this.bipedBody.func_78792_a((ModelRenderer)this.bipedRightLeg);
        this.bipedBody.func_78792_a((ModelRenderer)this.bipedLeftLeg);
        this.animator = ModelAnimator.create();
        this.updateDefaultPose();
    }

    public void setLivingAnimations(EntityDreadThrall LivingEntityIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.rightArmPose = BipedModel.ArmPose.EMPTY;
        this.leftArmPose = BipedModel.ArmPose.EMPTY;
        ItemStack itemstack = LivingEntityIn.func_184586_b(Hand.MAIN_HAND);
        super.func_212843_a_((Entity)LivingEntityIn, limbSwing, limbSwingAmount, partialTickTime);
    }

    public void setRotationAngles(EntityDreadThrall entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, 1.0f);
        ItemStack itemstack = entityIn.func_184614_ca();
        EntityDreadThrall thrall = entityIn;
        float f = 1.0f;
        this.bipedRightArm.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.bipedLeftArm.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.bipedRightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / f;
        this.bipedLeftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / f;
        this.bipedRightLeg.field_78796_g = 0.0f;
        this.bipedLeftLeg.field_78796_g = 0.0f;
        this.bipedRightLeg.field_78808_h = 0.0f;
        this.bipedLeftLeg.field_78808_h = 0.0f;
        if (entityIn.func_184218_aH()) {
            this.bipedRightArm.field_78795_f += -0.62831855f;
            this.bipedLeftArm.field_78795_f += -0.62831855f;
            this.bipedRightLeg.field_78795_f = -1.4137167f;
            this.bipedRightLeg.field_78796_g = 0.31415927f;
            this.bipedRightLeg.field_78808_h = 0.07853982f;
            this.bipedLeftLeg.field_78795_f = -1.4137167f;
            this.bipedLeftLeg.field_78796_g = -0.31415927f;
            this.bipedLeftLeg.field_78808_h = -0.07853982f;
        }
        if (this.field_217112_c > 0.0f) {
            HandSide Handside = this.getMainHand((Entity)entityIn);
            ModelRenderer modelrenderer = this.getArmForSide(Handside);
            float f1 = this.field_217112_c;
            this.bipedBody.field_78796_g = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f1) * ((float)Math.PI * 2))) * 0.2f;
            if (Handside == HandSide.LEFT) {
                this.bipedBody.field_78796_g *= -1.0f;
            }
            this.bipedRightArm.field_78798_e = MathHelper.func_76126_a((float)this.bipedBody.field_78796_g) * 5.0f;
            this.bipedRightArm.field_78800_c = -MathHelper.func_76134_b((float)this.bipedBody.field_78796_g) * 5.0f;
            this.bipedLeftArm.field_78798_e = -MathHelper.func_76126_a((float)this.bipedBody.field_78796_g) * 5.0f;
            this.bipedLeftArm.field_78800_c = MathHelper.func_76134_b((float)this.bipedBody.field_78796_g) * 5.0f;
            this.bipedRightArm.field_78796_g += this.bipedBody.field_78796_g;
            this.bipedLeftArm.field_78796_g += this.bipedBody.field_78796_g;
            this.bipedLeftArm.field_78795_f += this.bipedBody.field_78796_g;
            f1 = 1.0f - this.field_217112_c;
            f1 *= f1;
            f1 *= f1;
            f1 = 1.0f - f1;
            float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
            float f3 = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -(this.bipedHead.field_78795_f - 0.7f) * 0.75f;
            modelrenderer.field_78795_f = (float)((double)modelrenderer.field_78795_f - ((double)f2 * 1.2 + (double)f3));
            modelrenderer.field_78796_g += this.bipedBody.field_78796_g * 2.0f;
            modelrenderer.field_78808_h += MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -0.4f;
        }
        if (this.isSneak) {
            this.bipedBody.field_78795_f = 0.5f;
            this.bipedRightArm.field_78795_f += 0.4f;
            this.bipedLeftArm.field_78795_f += 0.4f;
            this.bipedRightLeg.field_78798_e = 4.0f;
            this.bipedLeftLeg.field_78798_e = 4.0f;
            this.bipedRightLeg.field_78797_d = 9.0f;
            this.bipedLeftLeg.field_78797_d = 9.0f;
            this.bipedHead.field_78797_d = 1.0f;
        } else {
            this.bipedBody.field_78795_f = 0.0f;
            this.bipedRightLeg.field_78798_e = 0.1f;
            this.bipedLeftLeg.field_78798_e = 0.1f;
            this.bipedRightLeg.field_78797_d = 12.0f;
            this.bipedLeftLeg.field_78797_d = 12.0f;
            this.bipedHead.field_78797_d = 0.0f;
        }
        this.bipedRightArm.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.bipedLeftArm.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.bipedRightArm.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        this.bipedLeftArm.field_78795_f -= MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        float speed_walk = 0.6f;
        float speed_idle = 0.05f;
        float degree_walk = 1.0f;
        float degree_idle = 0.5f;
        if (thrall.getAnimation() == EntityDreadThrall.ANIMATION_SPAWN && thrall.getAnimationTick() < 30) {
            this.flap(this.bipedRightArm, 0.5f, 0.5f, false, 2.0f, -0.7f, thrall.field_70173_aa, 1.0f);
            this.flap(this.bipedLeftArm, 0.5f, 0.5f, true, 2.0f, -0.7f, thrall.field_70173_aa, 1.0f);
            this.walk(this.bipedRightArm, 0.5f, 0.5f, true, 1.0f, 0.0f, thrall.field_70173_aa, 1.0f);
            this.walk(this.bipedLeftArm, 0.5f, 0.5f, true, 1.0f, 0.0f, thrall.field_70173_aa, 1.0f);
        }
        this.flap(this.bipedBody, 0.5f, 0.15f, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)((Object)this.bipedBody));
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return EntityModelPartBuilder.getAllPartsFromClass(this.getClass(), this.getClass().getName());
    }

    public void animate(IAnimatedEntity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        this.animator.update(entity);
        this.animator.setAnimation(EntityDreadThrall.ANIMATION_SPAWN);
        this.animator.startKeyframe(0);
        this.animator.move((AdvancedModelBox)this.bipedBody, 0.0f, 35.0f, 0.0f);
        this.rotate(this.animator, this.bipedLeftArm, -180.0f, 0.0f, 0.0f);
        this.rotate(this.animator, this.bipedRightArm, -180.0f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(30);
        this.animator.move((AdvancedModelBox)this.bipedBody, 0.0f, 0.0f, 0.0f);
        this.rotate(this.animator, this.bipedLeftArm, -180.0f, 0.0f, 0.0f);
        this.rotate(this.animator, this.bipedRightArm, -180.0f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
    }

    @Override
    public void rotate(ModelAnimator animator, AdvancedModelBox model, float x, float y, float z) {
        animator.rotate(model, (float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
    }

    @Override
    public void rotateMinus(ModelAnimator animator, AdvancedModelBox model, float x, float y, float z) {
        animator.rotate(model, (float)Math.toRadians(x) - model.defaultRotationX, (float)Math.toRadians(y) - model.defaultRotationY, (float)Math.toRadians(z) - model.defaultRotationZ);
    }

    protected ModelRenderer getArmForSide(HandSide side) {
        return side == HandSide.LEFT ? this.bipedLeftArm : this.bipedRightArm;
    }

    protected HandSide getMainHand(Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            LivingEntity LivingEntity2 = (LivingEntity)entityIn;
            HandSide Handside = LivingEntity2.func_184591_cq();
            return LivingEntity2.field_184622_au == Hand.MAIN_HAND ? Handside : Handside.func_188468_a();
        }
        return HandSide.RIGHT;
    }

    public void setVisible(boolean visible) {
        this.bipedHead.invisible = !visible;
        this.bipedHeadwear.invisible = !visible;
        this.bipedBody.invisible = !visible;
        this.bipedRightArm.invisible = !visible;
        this.bipedLeftArm.invisible = !visible;
        this.bipedRightLeg.invisible = !visible;
        this.bipedLeftLeg.invisible = !visible;
    }

    public void func_225599_a_(HandSide sideIn, MatrixStack matrixStackIn) {
        this.bipedBody.func_228307_a_(matrixStackIn);
        this.getArmForSide(sideIn).func_228307_a_(matrixStackIn);
    }

    @Override
    public void renderStatue(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, Entity living) {
        this.resetToDefaultPose();
        this.func_225598_a_(matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

