/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model.animator;

import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ITabulaModelAnimator;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.iceandfire.client.model.animator.IceAndFireTabulaModelAnimator;
import com.github.alexthe666.iceandfire.client.model.util.EnumDragonAnimations;
import com.github.alexthe666.iceandfire.client.model.util.LegArticulator;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class LightningTabulaDragonAnimator
extends IceAndFireTabulaModelAnimator
implements ITabulaModelAnimator<EntityLightningDragon> {
    AdvancedModelBox[] neckParts;
    AdvancedModelBox[] tailParts;
    AdvancedModelBox[] tailPartsWBody;
    AdvancedModelBox[] toesPartsL;
    AdvancedModelBox[] toesPartsR;
    AdvancedModelBox[] clawL;
    AdvancedModelBox[] clawR;
    private TabulaModel[] walkPoses;
    private TabulaModel[] flyPoses;

    public LightningTabulaDragonAnimator() {
        super(EnumDragonAnimations.GROUND_POSE.lightningdragon_model);
        this.walkPoses = new TabulaModel[]{EnumDragonAnimations.WALK1.lightningdragon_model, EnumDragonAnimations.WALK2.lightningdragon_model, EnumDragonAnimations.WALK3.lightningdragon_model, EnumDragonAnimations.WALK4.lightningdragon_model};
        this.flyPoses = new TabulaModel[]{EnumDragonAnimations.FLIGHT1.lightningdragon_model, EnumDragonAnimations.FLIGHT2.lightningdragon_model, EnumDragonAnimations.FLIGHT3.lightningdragon_model, EnumDragonAnimations.FLIGHT4.lightningdragon_model, EnumDragonAnimations.FLIGHT5.lightningdragon_model, EnumDragonAnimations.FLIGHT6.lightningdragon_model};
    }

    public void init(TabulaModel model) {
        this.neckParts = new AdvancedModelBox[]{model.getCube("Neck1"), model.getCube("Neck2"), model.getCube("Neck3"), model.getCube("Neck3"), model.getCube("Head")};
        this.tailParts = new AdvancedModelBox[]{model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4")};
        this.tailPartsWBody = new AdvancedModelBox[]{model.getCube("BodyLower"), model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4")};
        this.toesPartsL = new AdvancedModelBox[]{model.getCube("ToeL1"), model.getCube("ToeL2"), model.getCube("ToeL3")};
        this.toesPartsR = new AdvancedModelBox[]{model.getCube("ToeR1"), model.getCube("ToeR2"), model.getCube("ToeR3")};
        this.clawL = new AdvancedModelBox[]{model.getCube("ClawL")};
        this.clawR = new AdvancedModelBox[]{model.getCube("ClawR")};
    }

    public void setRotationAngles(TabulaModel model, EntityLightningDragon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        model.resetToDefaultPose();
        this.init(model);
        this.animate(model, entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, scale);
        boolean walking = !entity.isHovering() && !entity.isFlying() && entity.hoverProgress <= 0.0f && entity.flyProgress <= 0.0f;
        int currentIndex = walking ? entity.walkCycle / 10 : entity.flightCycle / 10;
        int prevIndex = currentIndex - 1;
        float dive = (10.0f - entity.diveProgress) * 0.1f;
        if (prevIndex < 0) {
            prevIndex = walking ? 3 : 5;
        }
        TabulaModel currentPosition = walking ? this.walkPoses[currentIndex] : this.flyPoses[currentIndex];
        TabulaModel prevPosition = walking ? this.walkPoses[prevIndex] : this.flyPoses[prevIndex];
        float delta = (float)(walking ? entity.walkCycle : entity.flightCycle) / 10.0f % 1.0f;
        float deltaTicks = delta + Minecraft.func_71410_x().func_184121_ak() / 10.0f;
        if (delta == 0.0f) {
            deltaTicks = 0.0f;
        }
        for (AdvancedModelBox cube : model.getCubes().values()) {
            float z;
            float y;
            float x;
            float prevZ;
            float prevY;
            float prevX;
            this.genderMob(entity, cube);
            if (walking && entity.flyProgress <= 0.0f && entity.hoverProgress <= 0.0f && entity.modelDeadProgress <= 0.0f) {
                AdvancedModelBox walkPart = EnumDragonAnimations.GROUND_POSE.lightningdragon_model.getCube(cube.boxName);
                prevX = prevPosition.getCube((String)cube.boxName).field_78795_f;
                prevY = prevPosition.getCube((String)cube.boxName).field_78796_g;
                prevZ = prevPosition.getCube((String)cube.boxName).field_78808_h;
                x = currentPosition.getCube((String)cube.boxName).field_78795_f;
                y = currentPosition.getCube((String)cube.boxName).field_78796_g;
                z = currentPosition.getCube((String)cube.boxName).field_78808_h;
                if (this.isWing(model, cube) && (entity.getAnimation() == EntityDragonBase.ANIMATION_WINGBLAST || entity.getAnimation() == EntityDragonBase.ANIMATION_EPIC_ROAR)) {
                    this.addToRotateAngle(cube, limbSwingAmount, walkPart.field_78795_f, walkPart.field_78796_g, walkPart.field_78808_h);
                } else {
                    this.addToRotateAngle(cube, limbSwingAmount, prevX + deltaTicks * this.distance(prevX, x), prevY + deltaTicks * this.distance(prevY, y), prevZ + deltaTicks * this.distance(prevZ, z));
                }
            }
            if (entity.modelDeadProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.DEAD.lightningdragon_model.getCube(cube.boxName))) {
                this.transitionTo(cube, EnumDragonAnimations.DEAD.lightningdragon_model.getCube(cube.boxName), entity.modelDeadProgress, 20.0f, cube.boxName.equals("ThighR") || cube.boxName.equals("ThighL"));
            }
            if (entity.sleepProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.SLEEPING_POSE.lightningdragon_model.getCube(cube.boxName))) {
                this.transitionTo(cube, EnumDragonAnimations.SLEEPING_POSE.lightningdragon_model.getCube(cube.boxName), entity.sleepProgress, 20.0f, false);
            }
            if (!(!(entity.hoverProgress > 0.0f) || this.isPartEqual(cube, EnumDragonAnimations.HOVERING_POSE.lightningdragon_model.getCube(cube.boxName)) || this.isWing(model, cube) || cube.boxName.contains("Tail") || cube.boxName.contains("Head"))) {
                this.transitionTo(cube, EnumDragonAnimations.HOVERING_POSE.lightningdragon_model.getCube(cube.boxName), entity.hoverProgress, 20.0f, false);
            }
            if (entity.flyProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.FLYING_POSE.lightningdragon_model.getCube(cube.boxName))) {
                this.transitionTo(cube, EnumDragonAnimations.FLYING_POSE.lightningdragon_model.getCube(cube.boxName), entity.flyProgress - entity.diveProgress * 2.0f, 20.0f, false);
            }
            if (entity.ridingProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.SIT_ON_PLAYER_POSE.lightningdragon_model.getCube(cube.boxName))) {
                this.transitionTo(cube, EnumDragonAnimations.SIT_ON_PLAYER_POSE.lightningdragon_model.getCube(cube.boxName), entity.ridingProgress, 20.0f, false);
                if (cube.boxName.equals("BodyUpper")) {
                    cube.field_78798_e += (-12.0f - cube.field_78798_e) / 20.0f * entity.ridingProgress;
                }
            }
            if (entity.tackleProgress > 0.0f && !this.isPartEqual(EnumDragonAnimations.TACKLE.lightningdragon_model.getCube(cube.boxName), EnumDragonAnimations.FLYING_POSE.lightningdragon_model.getCube(cube.boxName)) && !this.isWing(model, cube)) {
                this.transitionTo(cube, EnumDragonAnimations.TACKLE.lightningdragon_model.getCube(cube.boxName), entity.tackleProgress, 5.0f, false);
            }
            if (entity.diveProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.DIVING_POSE.lightningdragon_model.getCube(cube.boxName))) {
                this.transitionTo(cube, EnumDragonAnimations.DIVING_POSE.lightningdragon_model.getCube(cube.boxName), entity.diveProgress, 10.0f, false);
            }
            if (entity.fireBreathProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.STREAM_BREATH.lightningdragon_model.getCube(cube.boxName)) && !this.isWing(model, cube) && !cube.boxName.contains("Finger")) {
                if (entity.prevFireBreathProgress <= entity.fireBreathProgress) {
                    this.transitionTo(cube, EnumDragonAnimations.BLAST_CHARGE3.lightningdragon_model.getCube(cube.boxName), MathHelper.func_76131_a((float)entity.fireBreathProgress, (float)0.0f, (float)5.0f), 5.0f, false);
                }
                this.transitionTo(cube, EnumDragonAnimations.STREAM_BREATH.lightningdragon_model.getCube(cube.boxName), MathHelper.func_76131_a((float)(entity.fireBreathProgress - 5.0f), (float)0.0f, (float)5.0f), 5.0f, false);
            }
            if (entity.sitProgress > 0.0f) {
                if (!entity.func_184218_aH() && !this.isPartEqual(cube, EnumDragonAnimations.SITTING_POSE.lightningdragon_model.getCube(cube.boxName))) {
                    this.transitionTo(cube, EnumDragonAnimations.SITTING_POSE.lightningdragon_model.getCube(cube.boxName), entity.sitProgress, 20.0f, false);
                }
                if (cube.boxName.equals("Head") && entity.isBreathingFire()) {
                    cube.field_78795_f = (float)((double)cube.field_78795_f - Math.toRadians(20.0f * entity.fireBreathProgress / 10.0f));
                }
            }
            if (walking) continue;
            AdvancedModelBox flightPart = EnumDragonAnimations.FLYING_POSE.lightningdragon_model.getCube(cube.boxName);
            prevX = prevPosition.getCube((String)cube.boxName).field_78795_f;
            prevY = prevPosition.getCube((String)cube.boxName).field_78796_g;
            prevZ = prevPosition.getCube((String)cube.boxName).field_78808_h;
            x = currentPosition.getCube((String)cube.boxName).field_78795_f;
            y = currentPosition.getCube((String)cube.boxName).field_78796_g;
            z = currentPosition.getCube((String)cube.boxName).field_78808_h;
            if (x == flightPart.field_78795_f && y == flightPart.field_78796_g && z == flightPart.field_78808_h) continue;
            this.setRotateAngle(cube, 1.0f, prevX + deltaTicks * this.distance(prevX, x), prevY + deltaTicks * this.distance(prevY, y), prevZ + deltaTicks * this.distance(prevZ, z));
        }
        float speed_walk = 0.2f;
        float speed_idle = entity.func_70608_bn() ? 0.025f : 0.05f;
        float speed_fly = 0.2f;
        float degree_walk = 0.5f;
        float degree_idle = entity.func_70608_bn() ? 0.25f : 0.5f;
        float degree_fly = 0.5f;
        if (!entity.func_175446_cd()) {
            if (!walking) {
                model.bob(model.getCube("BodyUpper"), -speed_fly, degree_fly * 5.0f, false, ageInTicks, 1.0f);
                model.walk(model.getCube("BodyUpper"), -speed_fly, degree_fly * 0.1f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
                model.chainWave(this.tailPartsWBody, speed_fly, degree_fly * -0.1f, 0.0, ageInTicks, 1.0f);
                model.chainWave(this.neckParts, speed_fly, degree_fly * 0.2f, -4.0, ageInTicks, 1.0f);
                model.chainWave(this.toesPartsL, speed_fly, degree_fly * 0.2f, -2.0, ageInTicks, 1.0f);
                model.chainWave(this.toesPartsR, speed_fly, degree_fly * 0.2f, -2.0, ageInTicks, 1.0f);
                model.walk(model.getCube("ThighR"), -speed_fly, degree_fly * 0.1f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
                model.walk(model.getCube("ThighL"), -speed_fly, degree_fly * 0.1f, true, 0.0f, 0.0f, ageInTicks, 1.0f);
            } else {
                model.bob(model.getCube("BodyUpper"), speed_walk * 2.0f, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
                model.bob(model.getCube("ThighR"), speed_walk, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
                model.bob(model.getCube("ThighL"), speed_walk, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
                model.chainSwing(this.tailParts, speed_walk, degree_walk * 0.25f, -2.0, limbSwing, limbSwingAmount);
                model.chainWave(this.tailParts, speed_walk, degree_walk * 0.15f, 2.0, limbSwing, limbSwingAmount);
                model.chainSwing(this.neckParts, speed_walk, degree_walk * 0.15f, 2.0, limbSwing, limbSwingAmount);
                model.chainWave(this.neckParts, speed_walk, degree_walk * 0.05f, -2.0, limbSwing, limbSwingAmount);
                model.chainSwing(this.tailParts, speed_idle, degree_idle * 0.25f, -2.0, ageInTicks, 1.0f);
                float sitMod = entity.func_70906_o() ? 0.15f : 1.0f;
                model.chainWave(this.tailParts, speed_idle, degree_idle * 0.15f * sitMod, -2.0, ageInTicks, 1.0f);
                model.chainWave(this.neckParts, speed_idle, degree_idle * -0.15f, -3.0, ageInTicks, 1.0f);
                model.walk(model.getCube("Neck1"), speed_idle, degree_idle * 0.05f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
            }
            model.bob(model.getCube("BodyUpper"), speed_idle, degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("ThighR"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("ThighL"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("armR1"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("armL1"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
            if (entity.getAnimation() != EntityDragonBase.ANIMATION_SHAKEPREY || entity.getAnimation() != EntityDragonBase.ANIMATION_ROAR) {
                model.faceTarget(rotationYaw, rotationPitch, 4.0f, this.neckParts);
            }
            if (entity.isActuallyBreathingFire()) {
                float speed_shake = 0.7f;
                float degree_shake = 0.03f;
                model.chainFlap(this.neckParts, speed_shake, degree_shake, 2.0, ageInTicks, 1.0f);
                model.chainSwing(this.neckParts, speed_shake * 0.65f, degree_shake * 0.1f, 1.0, ageInTicks, 1.0f);
            }
        }
        if (!entity.isModelDead()) {
            if (entity.turn_buffer != null && !entity.func_184207_aI() && !entity.isBreathingFire()) {
                entity.turn_buffer.applyChainSwingBuffer((ModelRenderer[])this.neckParts);
            }
            if (entity.tail_buffer != null) {
                entity.tail_buffer.applyChainSwingBuffer((ModelRenderer[])this.tailPartsWBody);
            }
            if (entity.roll_buffer != null && entity.pitch_buffer_body != null && entity.pitch_buffer != null && (entity.flyProgress > 0.0f || entity.hoverProgress > 0.0f)) {
                entity.roll_buffer.applyChainFlapBuffer(new ModelRenderer[]{model.getCube("BodyUpper")});
                entity.pitch_buffer_body.applyChainWaveBuffer(new ModelRenderer[]{model.getCube("BodyUpper")});
                entity.pitch_buffer.applyChainWaveBufferReverse((ModelRenderer[])this.tailPartsWBody);
            }
        }
        if (entity.func_213311_cf() >= 2.0f && entity.flyProgress == 0.0f && entity.hoverProgress == 0.0f) {
            LegArticulator.articulateQuadruped(entity, entity.legSolver, model.getCube("BodyUpper"), model.getCube("BodyLower"), model.getCube("Neck1"), model.getCube("ThighL"), model.getCube("LegL"), this.toesPartsL, model.getCube("ThighR"), model.getCube("LegR"), this.toesPartsR, model.getCube("armL1"), model.getCube("armL2"), this.clawL, model.getCube("armR1"), model.getCube("armR2"), this.clawR, 1.0f, 0.5f, 0.5f, -0.15f, -0.15f, 0.0f, Minecraft.func_71410_x().func_184121_ak());
        }
    }

    private void genderMob(EntityLightningDragon entity, AdvancedModelBox cube) {
        if (!entity.isMale()) {
            TabulaModel maleModel = EnumDragonAnimations.MALE.lightningdragon_model;
            TabulaModel femaleModel = EnumDragonAnimations.FEMALE.lightningdragon_model;
            if (femaleModel.getCube(cube.boxName) != null) {
                float x = femaleModel.getCube((String)cube.boxName).field_78795_f;
                float y = femaleModel.getCube((String)cube.boxName).field_78796_g;
                float z = femaleModel.getCube((String)cube.boxName).field_78808_h;
                if (x != maleModel.getCube((String)cube.boxName).field_78795_f || y != maleModel.getCube((String)cube.boxName).field_78796_g || z != maleModel.getCube((String)cube.boxName).field_78808_h) {
                    this.setRotateAngle(cube, 1.0f, x, y, z);
                }
            }
        }
    }

    private boolean isWing(TabulaModel model, AdvancedModelBox modelRenderer) {
        return model.getCube("armL1") == modelRenderer || model.getCube("armR1") == modelRenderer || model.getCube((String)"armL1").field_78805_m.contains((Object)modelRenderer) || model.getCube((String)"armR1").field_78805_m.contains((Object)modelRenderer);
    }

    public void animate(TabulaModel model, EntityLightningDragon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        model.llibAnimator.update((IAnimatedEntity)entity);
        model.llibAnimator.setAnimation(EntityLightningDragon.ANIMATION_FIRECHARGE);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.BLAST_CHARGE1.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.BLAST_CHARGE2.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.BLAST_CHARGE3.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(5);
        model.llibAnimator.setAnimation(EntityLightningDragon.ANIMATION_SPEAK);
        model.llibAnimator.startKeyframe(5);
        this.rotate(model.llibAnimator, model.getCube("Jaw"), 18.0f, 0.0f, 0.0f);
        model.llibAnimator.move(model.getCube("Jaw"), 0.0f, 0.0f, 0.2f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.setStaticKeyframe(5);
        model.llibAnimator.startKeyframe(5);
        this.rotate(model.llibAnimator, model.getCube("Jaw"), 18.0f, 0.0f, 0.0f);
        model.llibAnimator.move(model.getCube("Jaw"), 0.0f, 0.0f, 0.2f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(5);
        model.llibAnimator.setAnimation(EntityLightningDragon.ANIMATION_BITE);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.BITE1.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.BITE2.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.BITE3.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityLightningDragon.ANIMATION_SHAKEPREY);
        model.llibAnimator.startKeyframe(15);
        this.moveToPose(model, EnumDragonAnimations.GRAB1.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.GRAB2.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.GRAB_SHAKE1.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.GRAB_SHAKE2.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.GRAB_SHAKE3.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityLightningDragon.ANIMATION_TAILWHACK);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.TAIL_WHIP1.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.TAIL_WHIP2.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.TAIL_WHIP3.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityLightningDragon.ANIMATION_WINGBLAST);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST1.lightningdragon_model);
        model.llibAnimator.move(model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST2.lightningdragon_model);
        model.llibAnimator.move(model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST3.lightningdragon_model);
        model.llibAnimator.move(model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST4.lightningdragon_model);
        model.llibAnimator.move(model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST5.lightningdragon_model);
        model.llibAnimator.move(model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST6.lightningdragon_model);
        model.llibAnimator.move(model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST7.lightningdragon_model);
        model.llibAnimator.move(model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityLightningDragon.ANIMATION_ROAR);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.ROAR1.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.ROAR3.lightningdragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityLightningDragon.ANIMATION_EPIC_ROAR);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.EPIC_ROAR1.lightningdragon_model);
        model.llibAnimator.move(model.getCube("BodyUpper"), 0.0f, -6.8f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.EPIC_ROAR2.lightningdragon_model);
        model.llibAnimator.move(model.getCube("BodyUpper"), 0.0f, -6.8f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.EPIC_ROAR3.lightningdragon_model);
        model.llibAnimator.move(model.getCube("BodyUpper"), 0.0f, -6.8f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.EPIC_ROAR2.lightningdragon_model);
        model.llibAnimator.move(model.getCube("BodyUpper"), 0.0f, -6.8f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.EPIC_ROAR3.lightningdragon_model);
        model.llibAnimator.move(model.getCube("BodyUpper"), 0.0f, -6.8f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
    }
}

