/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity.layer;

import com.github.alexthe666.iceandfire.client.texture.ArrayLayeredTexture;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.enums.EnumDragonTextures;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;

public class LayerDragonArmor
extends LayerRenderer<EntityDragonBase, SegmentedModel<EntityDragonBase>> {
    private static final Map<String, ResourceLocation> LAYERED_ARMOR_CACHE = Maps.newHashMap();
    private static EquipmentSlotType[] ARMOR_SLOTS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    private final MobRenderer render;

    public LayerDragonArmor(MobRenderer renderIn, int type) {
        super((IEntityRenderer)renderIn);
        this.render = renderIn;
    }

    public static void clearCache(String str) {
        LAYERED_ARMOR_CACHE.remove(str);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityDragonBase dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        int armorHead = dragon.getArmorOrdinal(dragon.func_184582_a(EquipmentSlotType.HEAD));
        int armorNeck = dragon.getArmorOrdinal(dragon.func_184582_a(EquipmentSlotType.CHEST));
        int armorLegs = dragon.getArmorOrdinal(dragon.func_184582_a(EquipmentSlotType.LEGS));
        int armorFeet = dragon.getArmorOrdinal(dragon.func_184582_a(EquipmentSlotType.FEET));
        String armorTexture = dragon.dragonType.getName() + "_" + armorHead + "_" + armorNeck + "_" + armorLegs + "_" + armorFeet;
        if (!armorTexture.equals(dragon.dragonType.getName() + "_0_0_0_0")) {
            ResourceLocation resourcelocation = LAYERED_ARMOR_CACHE.get(armorTexture);
            if (resourcelocation == null) {
                resourcelocation = new ResourceLocation("iceandfiredragon_armor_" + armorTexture);
                ArrayList<String> tex = new ArrayList<String>();
                for (EquipmentSlotType slot : ARMOR_SLOTS) {
                    if (dragon.dragonType == DragonType.FIRE) {
                        tex.add(EnumDragonTextures.Armor.getArmorForDragon((EntityDragonBase)dragon, (EquipmentSlotType)slot).FIRETEXTURE.toString());
                        continue;
                    }
                    if (dragon.dragonType == DragonType.ICE) {
                        tex.add(EnumDragonTextures.Armor.getArmorForDragon((EntityDragonBase)dragon, (EquipmentSlotType)slot).ICETEXTURE.toString());
                        continue;
                    }
                    tex.add(EnumDragonTextures.Armor.getArmorForDragon((EntityDragonBase)dragon, (EquipmentSlotType)slot).LIGHTNINGTEXTURE.toString());
                }
                ArrayLayeredTexture layeredBase = new ArrayLayeredTexture(tex);
                Minecraft.func_71410_x().func_110434_K().func_229263_a_(resourcelocation, (Texture)layeredBase);
                LAYERED_ARMOR_CACHE.put(armorTexture, resourcelocation);
            }
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)resourcelocation));
            ((SegmentedModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

