/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity.layer;

import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.citadel.server.entity.EntityPropertiesHandler;
import com.github.alexthe666.iceandfire.client.model.ICustomStatueModel;
import com.github.alexthe666.iceandfire.client.model.ModelGuardianStatue;
import com.github.alexthe666.iceandfire.client.model.ModelHorseStatue;
import com.github.alexthe666.iceandfire.client.render.IafRenderType;
import com.github.alexthe666.iceandfire.entity.props.StoneEntityProperties;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.util.ResourceLocation;

public class LayerStoneEntityCrack<T extends Entity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    protected static final ResourceLocation[] DESTROY_STAGES = new ResourceLocation[]{new ResourceLocation("textures/block/destroy_stage_0.png"), new ResourceLocation("textures/block/destroy_stage_1.png"), new ResourceLocation("textures/block/destroy_stage_2.png"), new ResourceLocation("textures/block/destroy_stage_3.png"), new ResourceLocation("textures/block/destroy_stage_4.png"), new ResourceLocation("textures/block/destroy_stage_5.png"), new ResourceLocation("textures/block/destroy_stage_6.png"), new ResourceLocation("textures/block/destroy_stage_7.png"), new ResourceLocation("textures/block/destroy_stage_8.png"), new ResourceLocation("textures/block/destroy_stage_9.png")};
    private static final ModelHorseStatue HORSE_MODEL = new ModelHorseStatue();
    private static final ModelGuardianStatue GUARDIAN_MODEL = new ModelGuardianStatue();
    private IEntityRenderer<T, M> renderer;

    public LayerStoneEntityCrack(IEntityRenderer<T, M> entityRendererIn) {
        super(entityRendererIn);
        this.renderer = entityRendererIn;
    }

    public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, Entity living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        EntityModel model;
        StoneEntityProperties properties;
        if (living instanceof LivingEntity && (properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(living, StoneEntityProperties.class)) != null && properties.isStone() && properties.getBreakLevel() >= 1 && (model = this.renderer.func_217764_d()) != null) {
            float x = (float)Math.max(model.field_78090_t, 1) / 16.0f;
            float y = (float)Math.max(model.field_78089_u, 1) / 16.0f;
            RenderType tex = IafRenderType.getStoneCrackRenderType(DESTROY_STAGES[properties.getBreakLevel() - 1], x, y);
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(tex);
            if (this.renderer.func_217764_d() instanceof TabulaModel) {
                ((TabulaModel)this.renderer.func_217764_d()).resetToDefaultPose();
            }
            if (this.renderer.func_217764_d() instanceof ICustomStatueModel) {
                ((ICustomStatueModel)this.renderer.func_217764_d()).renderStatue(matrixStackIn, ivertexbuilder, packedLightIn, living);
            } else if (living instanceof GuardianEntity) {
                GUARDIAN_MODEL.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                this.renderer.func_217764_d().func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

