/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityAmphithereArrow
extends AbstractArrowEntity {
    public EntityAmphithereArrow(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_70239_b(2.5);
    }

    public EntityAmphithereArrow(EntityType type, World worldIn, double x, double y, double z) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
        this.func_70239_b(2.5);
    }

    public EntityAmphithereArrow(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(IafEntityRegistry.AMPHITHERE_ARROW, world);
    }

    public EntityAmphithereArrow(EntityType type, LivingEntity shooter, World worldIn) {
        super(type, shooter, worldIn);
        this.func_70239_b(2.5);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!(this.field_70173_aa != 1 && this.field_70173_aa % 70 != 0 || this.field_70254_i || this.field_70122_E)) {
            this.func_184185_a(IafSoundRegistry.AMPHITHERE_GUST, 1.0f, 1.0f);
        }
        if (this.field_70170_p.field_72995_K && !this.field_70254_i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d3 = 10.0;
            double xRatio = this.func_213322_ci().field_72450_a * (double)this.func_213311_cf();
            double zRatio = this.func_213322_ci().field_72449_c * (double)this.func_213311_cf();
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226277_ct_() + xRatio + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 1.0f) - (double)this.func_213311_cf() - d0 * 10.0, this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()) - d1 * 10.0, this.func_226281_cx_() + zRatio + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 1.0f) - (double)this.func_213311_cf() - d2 * 10.0, d0, d1, d2);
        }
    }

    protected void func_184548_a(LivingEntity living) {
        if (living instanceof PlayerEntity) {
            this.damageShield((PlayerEntity)living, (float)this.func_70242_d());
        }
        living.field_70160_al = true;
        double xRatio = this.func_213322_ci().field_72450_a;
        double zRatio = this.func_213322_ci().field_72449_c;
        float strength = -1.4f;
        float f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
        living.func_213317_d(living.func_213322_ci().func_216372_d(0.5, 1.0, 0.5).func_178786_a(xRatio / (double)f * (double)strength, 0.0, zRatio / (double)f * (double)strength).func_72441_c(0.0, 0.6, 0.0));
        this.spawnExplosionParticle();
    }

    public void spawnExplosionParticle() {
        if (this.field_70170_p.field_72995_K) {
            for (int height = 0; height < 1 + this.field_70146_Z.nextInt(2); ++height) {
                for (int i = 0; i < 20; ++i) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d3 = 10.0;
                    double xRatio = this.func_213322_ci().field_72450_a * (double)this.func_213311_cf();
                    double zRatio = this.func_213322_ci().field_72449_c * (double)this.func_213311_cf();
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226277_ct_() + xRatio + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 1.0f) - (double)this.func_213311_cf() - d0 * 10.0, this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()) - d1 * 10.0, this.func_226281_cx_() + zRatio + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 1.0f) - (double)this.func_213311_cf() - d2 * 10.0, d0, d1, d2);
                }
            }
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)20);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 20) {
            this.spawnExplosionParticle();
        } else {
            super.func_70103_a(id);
        }
    }

    protected void damageShield(PlayerEntity player, float damage) {
        if (damage >= 3.0f && player.func_184607_cu().func_77973_b().isShield(player.func_184607_cu(), (LivingEntity)player)) {
            ItemStack copyBeforeUse = player.func_184607_cu().func_77946_l();
            int i = 1 + MathHelper.func_76141_d((float)damage);
            player.func_184607_cu().func_222118_a(i, (LivingEntity)player, p_220040_1_ -> p_220040_1_.func_213334_d(player.func_184600_cs()));
            if (player.func_184607_cu().func_190926_b()) {
                Hand Hand2 = player.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)copyBeforeUse, (Hand)Hand2);
                if (Hand2 == Hand.MAIN_HAND) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                }
                player.func_184602_cy();
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)IafItemRegistry.AMPHITHERE_ARROW);
    }
}

