/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.server.entity.EntityPropertiesHandler;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.ai.PixieAIFlee;
import com.github.alexthe666.iceandfire.entity.ai.PixieAIFollowOwner;
import com.github.alexthe666.iceandfire.entity.ai.PixieAIPickupItem;
import com.github.alexthe666.iceandfire.entity.ai.PixieAISteal;
import com.github.alexthe666.iceandfire.entity.props.StoneEntityProperties;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityPixieHouse;
import com.github.alexthe666.iceandfire.message.MessageUpdatePixieHouse;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.google.common.base.Predicate;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;

public class EntityPixie
extends TameableEntity {
    public static final float[][] PARTICLE_RGB = new float[][]{{1.0f, 0.752f, 0.792f}, {0.831f, 0.662f, 1.0f}, {0.513f, 0.843f, 1.0f}, {0.654f, 0.909f, 0.615f}, {0.996f, 0.788f, 0.407f}};
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityPixie.class, (IDataSerializer)DataSerializers.field_187192_b);
    public Effect[] positivePotions = new Effect[]{Effects.field_76420_g, Effects.field_76430_j, Effects.field_76424_c, Effects.field_188425_z, Effects.field_76422_e};
    public Effect[] negativePotions = new Effect[]{Effects.field_76437_t, Effects.field_76431_k, Effects.field_76421_d, Effects.field_189112_A, Effects.field_76419_f};
    public boolean slowSpeed = false;
    public int ticksUntilHouseAI;
    private BlockPos housePos;

    public EntityPixie(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new AIMoveControl(this);
        this.field_70728_aV = 3;
        this.func_184642_a(EquipmentSlotType.MAINHAND, 0.0f);
    }

    public static BlockPos getPositionRelativetoGround(Entity entity, World world, double x, double z, Random rand) {
        BlockPos pos = new BlockPos(x, entity.func_226278_cu_(), z);
        for (int yDown = 0; yDown < 3; ++yDown) {
            if (world.func_175623_d(pos.func_177979_c(yDown))) continue;
            return pos.func_177981_b(yDown);
        }
        return pos;
    }

    public static BlockPos findAHouse(Entity entity, World world) {
        for (int xSearch = -10; xSearch < 10; ++xSearch) {
            for (int ySearch = -10; ySearch < 10; ++ySearch) {
                for (int zSearch = -10; zSearch < 10; ++zSearch) {
                    if (world.func_175625_s(entity.func_180425_c().func_177982_a(xSearch, ySearch, zSearch)) == null || !(world.func_175625_s(entity.func_180425_c().func_177982_a(xSearch, ySearch, zSearch)) instanceof TileEntityPixieHouse)) continue;
                    TileEntityPixieHouse house = (TileEntityPixieHouse)world.func_175625_s(entity.func_180425_c().func_177982_a(xSearch, ySearch, zSearch));
                    if (house.hasPixie) continue;
                    return entity.func_180425_c().func_177982_a(xSearch, ySearch, zSearch);
                }
            }
        }
        return entity.func_180425_c();
    }

    protected int func_70693_a(PlayerEntity player) {
        return 3;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class);
        if (!this.field_70170_p.field_72995_K && this.func_70681_au().nextInt(3) == 0 && this.func_184586_b(Hand.MAIN_HAND) != ItemStack.field_190927_a && !properties.isStone()) {
            this.func_70099_a(this.func_184586_b(Hand.MAIN_HAND), 0.0f);
            this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            return true;
        }
        if (this.isOwnerClose() && (source == DamageSource.field_82729_p || source == DamageSource.field_76368_d || this.func_70902_q() != null && source.func_76346_g() == this.func_70902_q())) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && !this.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            this.func_70099_a(this.func_184586_b(Hand.MAIN_HAND), 0.0f);
            this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        }
        super.func_70645_a(cause);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(COLOR, (Object)0);
    }

    protected void func_82167_n(Entity entityIn) {
        if (this.func_70902_q() != entityIn) {
            entityIn.func_70108_f((Entity)this);
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (player.func_184586_b(hand).func_111282_a(player, (LivingEntity)this, hand)) {
            return true;
        }
        if (this.func_152114_e((LivingEntity)player)) {
            if (player.func_184586_b(hand).func_77973_b() == Items.field_151102_aT && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(5.0f);
                player.func_184586_b(hand).func_190918_g(1);
                this.func_184185_a(IafSoundRegistry.PIXIE_TAUNT, 1.0f, 1.0f);
                return true;
            }
            this.func_70904_g(!this.func_70906_o());
            return true;
        }
        if (player.func_184586_b(hand).func_77973_b() == Item.func_150898_a((Block)IafBlockRegistry.JAR_EMPTY) && !this.func_70909_n()) {
            if (!player.func_184812_l_()) {
                player.func_184586_b(hand).func_190918_g(1);
            }
            Block jar = IafBlockRegistry.JAR_PIXIE_0;
            switch (this.getColor()) {
                case 0: {
                    jar = IafBlockRegistry.JAR_PIXIE_0;
                    break;
                }
                case 1: {
                    jar = IafBlockRegistry.JAR_PIXIE_1;
                    break;
                }
                case 2: {
                    jar = IafBlockRegistry.JAR_PIXIE_2;
                    break;
                }
                case 3: {
                    jar = IafBlockRegistry.JAR_PIXIE_3;
                    break;
                }
                case 4: {
                    jar = IafBlockRegistry.JAR_PIXIE_4;
                }
            }
            ItemStack stack = new ItemStack((IItemProvider)jar, 1);
            if (!this.field_70170_p.field_72995_K) {
                if (!this.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                    this.func_70099_a(this.func_184586_b(Hand.MAIN_HAND), 0.0f);
                }
                this.func_70099_a(stack, 0.0f);
            }
            this.func_70106_y();
        }
        return super.func_184645_a(player, hand);
    }

    public void flipAI(boolean flee) {
    }

    public void fall(float distance, float damageMultiplier) {
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PixieAIFollowOwner(this, 1.0, 2.0f, 4.0f));
        this.field_70714_bg.func_75776_a(1, new PixieAIPickupItem(this, false));
        this.field_70714_bg.func_75776_a(2, new PixieAIFlee<PlayerEntity>(this, PlayerEntity.class, 10.0f, new Predicate<PlayerEntity>(){

            public boolean apply(@Nullable PlayerEntity entity) {
                return true;
            }
        }));
        this.field_70714_bg.func_75776_a(2, (Goal)new PixieAISteal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(4, (Goal)new AIEnterHouse());
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setColor(this.field_70146_Z.nextInt(5));
        this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        return spawnDataIn;
    }

    private boolean isBeyondHeight() {
        if (this.func_226278_cu_() > (double)this.field_70170_p.func_217301_I()) {
            return true;
        }
        BlockPos height = this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos((Entity)this));
        int maxY = 20 + height.func_177956_o();
        return this.func_226278_cu_() > (double)maxY;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_70906_o() && !this.isBeyondHeight()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.08, 0.0));
        }
        if (this.field_70170_p.field_72995_K) {
            IceAndFire.PROXY.spawnParticle("if_pixie", this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), PARTICLE_RGB[this.getColor()][0], PARTICLE_RGB[this.getColor()][1], PARTICLE_RGB[this.getColor()][2]);
        }
        if (this.ticksUntilHouseAI > 0) {
            --this.ticksUntilHouseAI;
        }
        if (!this.field_70170_p.field_72995_K && this.housePos != null) {
            Vec3d vec3d = new Vec3d((Vec3i)this.housePos);
            if (this.func_195048_a(vec3d.func_72441_c(0.5, 0.5, 0.5)) < 1.5 && this.field_70170_p.func_175625_s(this.housePos) != null && this.field_70170_p.func_175625_s(this.housePos) instanceof TileEntityPixieHouse) {
                TileEntityPixieHouse house = (TileEntityPixieHouse)this.field_70170_p.func_175625_s(this.housePos);
                if (house.hasPixie) {
                    this.housePos = null;
                } else {
                    house.hasPixie = true;
                    house.pixieType = this.getColor();
                    house.pixieItems.set(0, (Object)this.func_184586_b(Hand.MAIN_HAND));
                    house.tamedPixie = this.func_70909_n();
                    house.pixieOwnerUUID = this.func_184753_b();
                    IceAndFire.sendMSGToAll(new MessageUpdatePixieHouse(this.housePos.func_218275_a(), true, this.getColor()));
                    this.func_70106_y();
                }
            }
        }
        if (this.func_70902_q() != null && this.isOwnerClose() && this.field_70173_aa % 80 == 0) {
            this.func_70902_q().func_195064_c(new EffectInstance(this.positivePotions[this.getColor()], 100, 0, false, false));
        }
    }

    public int getColor() {
        return MathHelper.func_76125_a((int)((Integer)this.func_184212_Q().func_187225_a(COLOR)), (int)0, (int)4);
    }

    public void setColor(int color) {
        this.func_184212_Q().func_187227_b(COLOR, (Object)color);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setColor(compound.func_74762_e("Color"));
        super.func_70037_a(compound);
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Color", this.getColor());
        super.func_213281_b(compound);
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    public BlockPos getHousePos() {
        return this.housePos;
    }

    public boolean isOwnerClose() {
        return this.func_70909_n() && this.func_70902_q() != null && this.func_70068_e((Entity)this.func_70902_q()) < 100.0;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.PIXIE_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return IafSoundRegistry.PIXIE_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.PIXIE_DIE;
    }

    class AIEnterHouse
    extends Goal {
        public AIEnterHouse() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (EntityPixie.this.isOwnerClose() || EntityPixie.this.func_70605_aq().func_75640_a() || EntityPixie.this.func_70906_o() || EntityPixie.this.field_70146_Z.nextInt(20) != 0 || EntityPixie.this.ticksUntilHouseAI != 0) {
                return false;
            }
            BlockPos blockpos1 = EntityPixie.findAHouse((Entity)EntityPixie.this, EntityPixie.this.field_70170_p);
            return !blockpos1.toString().equals(EntityPixie.this.func_180425_c().toString());
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos;
            BlockPos blockPos = blockpos = EntityPixie.this.getHousePos() == null ? EntityPixie.this.func_180425_c() : EntityPixie.this.getHousePos();
            if (blockpos == null) {
                blockpos = new BlockPos((Entity)EntityPixie.this);
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = EntityPixie.findAHouse((Entity)EntityPixie.this, EntityPixie.this.field_70170_p);
                EntityPixie.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                EntityPixie.this.housePos = blockpos1;
                if (EntityPixie.this.func_70638_az() != null) continue;
                EntityPixie.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
            }
        }
    }

    class AIMoveRandom
    extends Goal {
        BlockPos target;

        public AIMoveRandom() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.target = EntityPixie.getPositionRelativetoGround((Entity)EntityPixie.this, EntityPixie.this.field_70170_p, EntityPixie.this.func_226277_ct_() + (double)EntityPixie.this.field_70146_Z.nextInt(15) - 7.0, EntityPixie.this.func_226281_cx_() + (double)EntityPixie.this.field_70146_Z.nextInt(15) - 7.0, EntityPixie.this.field_70146_Z);
            return !EntityPixie.this.isOwnerClose() && !EntityPixie.this.func_70906_o() && this.isDirectPathBetweenPoints(EntityPixie.this.func_180425_c(), this.target) && !EntityPixie.this.func_70605_aq().func_75640_a() && EntityPixie.this.field_70146_Z.nextInt(4) == 0 && EntityPixie.this.housePos == null;
        }

        protected boolean isDirectPathBetweenPoints(BlockPos posVec31, BlockPos posVec32) {
            return EntityPixie.this.field_70170_p.func_217299_a(new RayTraceContext(new Vec3d((double)posVec31.func_177958_n() + 0.5, (double)posVec31.func_177956_o() + 0.5, (double)posVec31.func_177952_p() + 0.5), new Vec3d((double)posVec32.func_177958_n() + 0.5, (double)posVec32.func_177956_o() + (double)EntityPixie.this.func_213302_cg() * 0.5, (double)posVec32.func_177952_p() + 0.5), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)EntityPixie.this)).func_216346_c() == RayTraceResult.Type.MISS;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            if (!this.isDirectPathBetweenPoints(EntityPixie.this.func_180425_c(), this.target)) {
                this.target = EntityPixie.getPositionRelativetoGround((Entity)EntityPixie.this, EntityPixie.this.field_70170_p, EntityPixie.this.func_226277_ct_() + (double)EntityPixie.this.field_70146_Z.nextInt(15) - 7.0, EntityPixie.this.func_226281_cx_() + (double)EntityPixie.this.field_70146_Z.nextInt(15) - 7.0, EntityPixie.this.field_70146_Z);
            }
            if (EntityPixie.this.field_70170_p.func_175623_d(this.target)) {
                EntityPixie.this.field_70765_h.func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.25);
                if (EntityPixie.this.func_70638_az() == null) {
                    EntityPixie.this.func_70671_ap().func_75650_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }

    class AIMoveControl
    extends MovementController {
        public AIMoveControl(EntityPixie pixie) {
            super((MobEntity)pixie);
            this.field_75645_e = 0.75;
        }

        public void func_75641_c() {
            if (EntityPixie.this.slowSpeed) {
                this.field_75645_e = 2.0;
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                if (EntityPixie.this.field_70123_F) {
                    EntityPixie.this.field_70177_z += 180.0f;
                    this.field_75645_e = 0.1f;
                    BlockPos target = EntityPixie.getPositionRelativetoGround((Entity)EntityPixie.this, EntityPixie.this.field_70170_p, EntityPixie.this.func_226277_ct_() + (double)EntityPixie.this.field_70146_Z.nextInt(15) - 7.0, EntityPixie.this.func_226281_cx_() + (double)EntityPixie.this.field_70146_Z.nextInt(15) - 7.0, EntityPixie.this.field_70146_Z);
                    this.field_75646_b = target.func_177958_n();
                    this.field_75647_c = target.func_177956_o();
                    this.field_75644_d = target.func_177952_p();
                }
                double d0 = this.field_75646_b - EntityPixie.this.func_226277_ct_();
                double d1 = this.field_75647_c - EntityPixie.this.func_226278_cu_();
                double d2 = this.field_75644_d - EntityPixie.this.func_226281_cx_();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityPixie.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    EntityPixie.this.func_213317_d(EntityPixie.this.func_213322_ci().func_216372_d(0.5, 0.5, 0.5));
                } else {
                    EntityPixie.this.func_213317_d(EntityPixie.this.func_213322_ci().func_72441_c(d0 / d3 * 0.05 * this.field_75645_e, d1 / d3 * 0.05 * this.field_75645_e, d2 / d3 * 0.05 * this.field_75645_e));
                    if (EntityPixie.this.func_70638_az() == null) {
                        EntityPixie.this.field_70761_aq = EntityPixie.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityPixie.this.func_213322_ci().field_72450_a, (double)EntityPixie.this.func_213322_ci().field_72449_c)) * 57.295776f;
                    } else {
                        double d4 = EntityPixie.this.func_70638_az().func_226277_ct_() - EntityPixie.this.func_226277_ct_();
                        double d5 = EntityPixie.this.func_70638_az().func_226281_cx_() - EntityPixie.this.func_226281_cx_();
                        EntityPixie.this.field_70761_aq = EntityPixie.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

