/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntitySiren;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class AquaticAIGetInWater
extends Goal {
    private final MobEntity creature;
    private final double movementSpeed;
    private final World world;
    private double shelterX;
    private double shelterY;
    private double shelterZ;

    public AquaticAIGetInWater(MobEntity theCreatureIn, double movementSpeedIn) {
        this.creature = theCreatureIn;
        this.movementSpeed = movementSpeedIn;
        this.world = theCreatureIn.field_70170_p;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    protected boolean isAttackerInWater() {
        return this.creature.func_70638_az() != null && !this.creature.func_70638_az().func_70090_H();
    }

    public boolean func_75250_a() {
        if (this.creature.func_184207_aI() || this.creature instanceof TameableEntity && ((TameableEntity)this.creature).func_70909_n() || this.creature.func_70090_H() || this.isAttackerInWater() || this.creature instanceof EntitySiren && (((EntitySiren)this.creature).isSinging() || ((EntitySiren)this.creature).wantsToSing())) {
            return false;
        }
        Vec3d vec3d = this.findPossibleShelter();
        if (vec3d == null) {
            return false;
        }
        this.shelterX = vec3d.field_72450_a;
        this.shelterY = vec3d.field_72448_b;
        this.shelterZ = vec3d.field_72449_c;
        return true;
    }

    public boolean func_75253_b() {
        return !this.creature.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.creature.func_70661_as().func_75492_a(this.shelterX, this.shelterY, this.shelterZ, this.movementSpeed);
    }

    @Nullable
    public Vec3d findPossibleShelter() {
        return this.findPossibleShelter(10, 3);
    }

    @Nullable
    protected Vec3d findPossibleShelter(int xz, int y) {
        Random random = this.creature.func_70681_au();
        BlockPos blockpos = new BlockPos(this.creature.func_226277_ct_(), this.creature.func_174813_aQ().field_72338_b, this.creature.func_226281_cx_());
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.func_177982_a(random.nextInt(xz * 2) - xz, random.nextInt(y * 2) - y, random.nextInt(xz * 2) - xz);
            if (this.world.func_180495_p(blockpos1).func_185904_a() != Material.field_151586_h) continue;
            return new Vec3d((double)blockpos1.func_177958_n(), (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p());
        }
        return null;
    }
}

