/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.item.ItemHippogryphEgg;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class HippogryphAIMate
extends Goal {
    private final EntityHippogryph hippo;
    private final Class<? extends AnimalEntity> mateClass;
    World world;
    int spawnBabyDelay;
    double moveSpeed;
    private EntityHippogryph targetMate;

    public HippogryphAIMate(EntityHippogryph animal, double speedIn) {
        this(animal, speedIn, animal.getClass());
    }

    public HippogryphAIMate(EntityHippogryph hippogryph, double speed, Class<? extends AnimalEntity> mate) {
        this.hippo = hippogryph;
        this.world = hippogryph.field_70170_p;
        this.mateClass = mate;
        this.moveSpeed = speed;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.hippo.func_70880_s() || this.hippo.func_70906_o()) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean func_75253_b() {
        return !this.targetMate.func_70089_S() && this.targetMate.func_70880_s() && this.spawnBabyDelay < 60;
    }

    public void func_75251_c() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void func_75246_d() {
        this.hippo.func_70671_ap().func_75651_a((Entity)this.targetMate, 10.0f, (float)this.hippo.func_70646_bf());
        this.hippo.func_70661_as().func_75497_a((Entity)this.targetMate, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.hippo.func_70068_e((Entity)this.targetMate) < 9.0) {
            this.spawnBaby();
        }
    }

    private EntityHippogryph getNearbyMate() {
        List list = this.world.func_217357_a(EntityHippogryph.class, this.hippo.func_174813_aQ().func_186662_g(8.0));
        double d0 = Double.MAX_VALUE;
        EntityHippogryph entityanimal = null;
        for (EntityHippogryph entityanimal1 : list) {
            if (!this.hippo.func_70878_b((AnimalEntity)entityanimal1) || !(this.hippo.func_70068_e((Entity)entityanimal1) < d0)) continue;
            entityanimal = entityanimal1;
            d0 = this.hippo.func_70068_e((Entity)entityanimal1);
        }
        return entityanimal;
    }

    private void spawnBaby() {
        ItemEntity egg = new ItemEntity(this.world, this.hippo.func_226277_ct_(), this.hippo.func_226278_cu_(), this.hippo.func_226281_cx_(), ItemHippogryphEgg.createEggStack(this.hippo.getEnumVariant(), this.targetMate.getEnumVariant()));
        if (egg != null) {
            ServerPlayerEntity PlayerEntity2 = this.hippo.func_191993_do();
            if (PlayerEntity2 == null && this.targetMate.func_191993_do() != null) {
                PlayerEntity2 = this.targetMate.func_191993_do();
            }
            this.hippo.func_70873_a(6000);
            this.targetMate.func_70873_a(6000);
            this.hippo.func_70875_t();
            this.targetMate.func_70875_t();
            egg.func_70012_b(this.hippo.func_226277_ct_(), this.hippo.func_226278_cu_(), this.hippo.func_226281_cx_(), 0.0f, 0.0f);
            if (!this.world.field_72995_K) {
                this.world.func_217376_c((Entity)egg);
            }
            Random random = this.hippo.func_70681_au();
            for (int i = 0; i < 7; ++i) {
                double d0 = random.nextGaussian() * 0.02;
                double d1 = random.nextGaussian() * 0.02;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextDouble() * (double)this.hippo.func_213311_cf() * 2.0 - (double)this.hippo.func_213311_cf();
                double d4 = 0.5 + random.nextDouble() * (double)this.hippo.func_213302_cg();
                double d5 = random.nextDouble() * (double)this.hippo.func_213311_cf() * 2.0 - (double)this.hippo.func_213311_cf();
                this.world.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.hippo.func_226277_ct_() + d3, this.hippo.func_226278_cu_() + d4, this.hippo.func_226281_cx_() + d5, d0, d1, d2);
            }
            if (this.world.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.world.func_217376_c((Entity)new ExperienceOrbEntity(this.world, this.hippo.func_226277_ct_(), this.hippo.func_226278_cu_(), this.hippo.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }
}

