/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.block.BlockMyrmexCocoon;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexWorker;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityMyrmexCocoon;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Collectors;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class MyrmexAIStoreItems
extends Goal {
    private final EntityMyrmexBase myrmex;
    private final double movementSpeed;
    private BlockPos nextRoom = null;
    private BlockPos nextCocoon = null;
    private BlockPos mainRoom = null;
    private boolean first = true;

    public MyrmexAIStoreItems(EntityMyrmexBase entityIn, double movementSpeedIn) {
        this.myrmex = entityIn;
        this.movementSpeed = movementSpeedIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.myrmex.canMove() || this.myrmex instanceof EntityMyrmexWorker && ((EntityMyrmexWorker)this.myrmex).holdingBaby() || !this.myrmex.shouldEnterHive() && !this.myrmex.func_70661_as().func_75500_f() || this.myrmex.canSeeSky() || this.myrmex.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        MyrmexHive village = this.myrmex.getHive();
        if (village == null) {
            return false;
        }
        this.first = true;
        this.mainRoom = MyrmexHive.getGroundedPos((IWorld)this.myrmex.field_70170_p, village.getCenter());
        this.nextRoom = MyrmexHive.getGroundedPos((IWorld)this.myrmex.field_70170_p, village.getRandomRoom(WorldGenMyrmexHive.RoomType.FOOD, this.myrmex.func_70681_au(), this.myrmex.func_180425_c()));
        this.nextCocoon = this.getNearbyCocoon(this.nextRoom);
        return this.nextCocoon != null;
    }

    public boolean func_75253_b() {
        return !this.myrmex.func_184586_b(Hand.MAIN_HAND).func_190926_b() && this.nextCocoon != null && this.isUseableCocoon(this.nextCocoon) && this.myrmex.func_70092_e((double)this.nextCocoon.func_177958_n() + 0.5, (double)this.nextCocoon.func_177956_o() + 0.5, (double)this.nextCocoon.func_177952_p() + 0.5) > 3.0 && this.myrmex.shouldEnterHive();
    }

    public void func_75246_d() {
        if (this.first && this.mainRoom != null) {
            if (this.myrmex.func_70661_as().func_75500_f()) {
                this.myrmex.func_70661_as().func_75492_a((double)this.mainRoom.func_177958_n() + 0.5, (double)this.mainRoom.func_177956_o() + 0.5, (double)this.mainRoom.func_177952_p() + 0.5, this.movementSpeed);
            }
            if (this.myrmex.func_70092_e((double)this.mainRoom.func_177958_n() + 0.5, (double)this.mainRoom.func_177956_o() + 0.5, (double)this.mainRoom.func_177952_p() + 0.5) < 10.0) {
                this.first = false;
                return;
            }
        }
        if (!this.first && this.nextCocoon != null) {
            if (this.myrmex.func_70661_as().func_75500_f()) {
                this.myrmex.func_70661_as().func_75492_a((double)this.nextCocoon.func_177958_n() + 0.5, (double)this.nextCocoon.func_177956_o() + 0.5, (double)this.nextCocoon.func_177952_p() + 0.5, this.movementSpeed);
            }
            if (this.myrmex.func_70092_e((double)this.nextCocoon.func_177958_n() + 0.5, (double)this.nextCocoon.func_177956_o() + 0.5, (double)this.nextCocoon.func_177952_p() + 0.5) < 5.5 && !this.myrmex.func_184586_b(Hand.MAIN_HAND).func_190926_b() && this.isUseableCocoon(this.nextCocoon)) {
                TileEntityMyrmexCocoon cocoon = (TileEntityMyrmexCocoon)this.myrmex.field_70170_p.func_175625_s(this.nextCocoon);
                ItemStack itemstack = this.myrmex.func_184586_b(Hand.MAIN_HAND);
                if (!itemstack.func_190926_b()) {
                    for (int i = 0; i < cocoon.func_70302_i_(); ++i) {
                        if (itemstack.func_190926_b()) continue;
                        ItemStack cocoonStack = cocoon.func_70301_a(i);
                        if (cocoonStack.func_190926_b()) {
                            cocoon.func_70299_a(i, itemstack.func_77946_l());
                            cocoon.func_70296_d();
                            this.myrmex.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                            this.myrmex.isEnteringHive = false;
                            return;
                        }
                        if (cocoonStack.func_77973_b() != itemstack.func_77973_b()) continue;
                        int j = Math.min(cocoon.func_70297_j_(), cocoonStack.func_77976_d());
                        int k = Math.min(itemstack.func_190916_E(), j - cocoonStack.func_190916_E());
                        if (k <= 0) continue;
                        cocoonStack.func_190917_f(k);
                        itemstack.func_190918_g(k);
                        if (itemstack.func_190926_b()) {
                            cocoon.func_70296_d();
                        }
                        this.myrmex.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                        this.myrmex.isEnteringHive = false;
                        return;
                    }
                }
            }
        }
    }

    public void func_75251_c() {
        this.nextRoom = null;
        this.nextCocoon = null;
        this.mainRoom = null;
        this.first = true;
    }

    public BlockPos getNearbyCocoon(BlockPos roomCenter) {
        int RADIUS_XZ = 15;
        int RADIUS_Y = 7;
        ArrayList<BlockPos> closeCocoons = new ArrayList<BlockPos>();
        for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)roomCenter.func_177982_a(-RADIUS_XZ, -RADIUS_Y, -RADIUS_XZ), (BlockPos)roomCenter.func_177982_a(RADIUS_XZ, RADIUS_Y, RADIUS_XZ)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
            TileEntity te = this.myrmex.field_70170_p.func_175625_s(blockpos);
            if (te == null || !(te instanceof TileEntityMyrmexCocoon) || ((TileEntityMyrmexCocoon)te).isFull(this.myrmex.func_184586_b(Hand.MAIN_HAND))) continue;
            closeCocoons.add(blockpos);
        }
        if (closeCocoons.isEmpty()) {
            return null;
        }
        return (BlockPos)closeCocoons.get(this.myrmex.func_70681_au().nextInt(Math.max(closeCocoons.size() - 1, 1)));
    }

    public boolean isUseableCocoon(BlockPos blockpos) {
        if (this.myrmex.field_70170_p.func_180495_p(blockpos).func_177230_c() instanceof BlockMyrmexCocoon && this.myrmex.field_70170_p.func_175625_s(blockpos) != null && this.myrmex.field_70170_p.func_175625_s(blockpos) instanceof TileEntityMyrmexCocoon) {
            return !((TileEntityMyrmexCocoon)this.myrmex.field_70170_p.func_175625_s(blockpos)).isFull(this.myrmex.func_184586_b(Hand.MAIN_HAND));
        }
        return false;
    }
}

