/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.tile;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityPixie;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.tile.IafTileEntityRegistry;
import com.github.alexthe666.iceandfire.message.MessageUpdatePixieHouse;
import com.github.alexthe666.iceandfire.message.MessageUpdatePixieHouseModel;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;

public class TileEntityPixieHouse
extends TileEntity
implements ITickableTileEntity {
    private static final float PARTICLE_WIDTH = 0.3f;
    private static final float PARTICLE_HEIGHT = 0.6f;
    public int houseType;
    public boolean hasPixie;
    public boolean tamedPixie;
    public UUID pixieOwnerUUID;
    public int pixieType;
    public int ticksExisted;
    public NonNullList<ItemStack> pixieItems = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private Random rand = new Random();

    public TileEntityPixieHouse() {
        super(IafTileEntityRegistry.PIXIE_HOUSE);
    }

    public static int getHouseTypeFromBlock(Block block) {
        if (block == IafBlockRegistry.PIXIE_HOUSE_MUSHROOM_RED) {
            return 1;
        }
        if (block == IafBlockRegistry.PIXIE_HOUSE_MUSHROOM_BROWN) {
            return 0;
        }
        if (block == IafBlockRegistry.PIXIE_HOUSE_OAK) {
            return 3;
        }
        if (block == IafBlockRegistry.PIXIE_HOUSE_BIRCH) {
            return 2;
        }
        if (block == IafBlockRegistry.PIXIE_HOUSE_SPRUCE) {
            return 5;
        }
        if (block == IafBlockRegistry.PIXIE_HOUSE_DARK_OAK) {
            return 4;
        }
        return 0;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("HouseType", this.houseType);
        compound.func_74757_a("HasPixie", this.hasPixie);
        compound.func_74768_a("PixieType", this.pixieType);
        compound.func_74757_a("TamedPixie", this.tamedPixie);
        if (this.pixieOwnerUUID != null) {
            compound.func_186854_a("PixieOwnerUUID", this.pixieOwnerUUID);
        }
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.pixieItems);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_145839_a(packet.func_148857_g());
        if (!this.field_145850_b.field_72995_K) {
            IceAndFire.sendMSGToAll(new MessageUpdatePixieHouseModel(this.field_174879_c.func_218275_a(), packet.func_148857_g().func_74762_e("HouseType")));
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_145839_a(CompoundNBT compound) {
        this.houseType = compound.func_74762_e("HouseType");
        this.hasPixie = compound.func_74767_n("HasPixie");
        this.pixieType = compound.func_74762_e("PixieType");
        this.tamedPixie = compound.func_74767_n("TamedPixie");
        this.pixieOwnerUUID = compound.func_186857_a("TicksExisted");
        this.pixieItems = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.pixieItems);
        super.func_145839_a(compound);
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (!this.field_145850_b.field_72995_K && this.hasPixie && new Random().nextInt(100) == 0) {
            this.releasePixie();
        }
        if (this.field_145850_b.field_72995_K && this.hasPixie) {
            IceAndFire.PROXY.spawnParticle("if_pixie", (double)((float)this.field_174879_c.func_177958_n() + 0.5f) + (double)(this.rand.nextFloat() * 0.3f * 2.0f) - (double)0.3f, (double)this.field_174879_c.func_177956_o() + (double)(this.rand.nextFloat() * 0.6f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f) + (double)(this.rand.nextFloat() * 0.3f * 2.0f) - (double)0.3f, EntityPixie.PARTICLE_RGB[this.pixieType][0], EntityPixie.PARTICLE_RGB[this.pixieType][1], EntityPixie.PARTICLE_RGB[this.pixieType][2]);
        }
    }

    public void releasePixie() {
        EntityPixie pixie = new EntityPixie(IafEntityRegistry.PIXIE, this.field_145850_b);
        pixie.func_70080_a((float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 1.0f, (float)this.field_174879_c.func_177952_p() + 0.5f, new Random().nextInt(360), 0.0f);
        pixie.func_184611_a(Hand.MAIN_HAND, (ItemStack)this.pixieItems.get(0));
        pixie.setColor(this.pixieType);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_217376_c((Entity)pixie);
        }
        this.hasPixie = false;
        this.pixieType = 0;
        pixie.ticksUntilHouseAI = 500;
        pixie.func_70903_f(this.tamedPixie);
        pixie.func_184754_b(this.pixieOwnerUUID);
        if (!this.field_145850_b.field_72995_K) {
            IceAndFire.sendMSGToAll(new MessageUpdatePixieHouse(this.field_174879_c.func_218275_a(), false, 0));
        }
    }
}

