/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.event;

import com.github.alexthe666.citadel.server.entity.EntityPropertiesHandler;
import com.github.alexthe666.iceandfire.ClientProxy;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.IafKeybindRegistry;
import com.github.alexthe666.iceandfire.client.gui.IceAndFireMainMenu;
import com.github.alexthe666.iceandfire.client.render.entity.ICustomStoneLayer;
import com.github.alexthe666.iceandfire.client.render.entity.RenderCockatrice;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerStoneEntity;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerStoneEntityCrack;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import com.github.alexthe666.iceandfire.entity.props.ChainEntityProperties;
import com.github.alexthe666.iceandfire.entity.props.FrozenEntityProperties;
import com.github.alexthe666.iceandfire.entity.props.MiscEntityProperties;
import com.github.alexthe666.iceandfire.entity.props.SirenEntityProperties;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ClientEvents {
    private static final ResourceLocation SIREN_SHADER = new ResourceLocation("iceandfire:shaders/post/siren.json");
    private static final ResourceLocation TEXTURE_0 = new ResourceLocation("textures/block/frosted_ice_0.png");
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("textures/block/frosted_ice_1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("textures/block/frosted_ice_2.png");
    private static final ResourceLocation TEXTURE_3 = new ResourceLocation("textures/block/frosted_ice_3.png");
    private static final ResourceLocation CHAIN_TEXTURE = new ResourceLocation("iceandfire:textures/models/misc/chain_link.png");
    private Random rand = new Random();

    public static void initializeStoneLayer() {
        for (Map.Entry entry : Minecraft.func_71410_x().func_175598_ae().field_78729_o.entrySet()) {
            EntityRenderer render = (EntityRenderer)entry.getValue();
            if (!(render instanceof LivingRenderer)) continue;
            LayerStoneEntity stoneLayer = render instanceof ICustomStoneLayer ? ((ICustomStoneLayer)render).getStoneLayer((LivingRenderer)render) : new LayerStoneEntity((LivingRenderer)render);
            ((LivingRenderer)render).func_177094_a((LayerRenderer)stoneLayer);
            ((LivingRenderer)render).func_177094_a(new LayerStoneEntityCrack((LivingRenderer)render));
        }
        Field renderingRegistryField = ObfuscationReflectionHelper.findField(RenderingRegistry.class, (String)"INSTANCE");
        Field entityRendersField = ObfuscationReflectionHelper.findField(RenderingRegistry.class, (String)"entityRenderers");
        RenderingRegistry registry = null;
        try {
            Field modifier = Field.class.getDeclaredField("modifiers");
            modifier.setAccessible(true);
            registry = (RenderingRegistry)renderingRegistryField.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (registry != null) {
            Map entityRenders = null;
            try {
                Field modifier1 = Field.class.getDeclaredField("modifiers");
                modifier1.setAccessible(true);
                entityRenders = (Map)entityRendersField.get(registry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (entityRenders != null) {
                for (Map.Entry entry : entityRenders.entrySet()) {
                    if (entry.getValue() == null) continue;
                    try {
                        EntityRenderer render = ((IRenderFactory)entry.getValue()).createRenderFor(Minecraft.func_71410_x().func_175598_ae());
                        if (render == null || !(render instanceof LivingRenderer)) continue;
                        LayerStoneEntity stoneLayer = render instanceof ICustomStoneLayer ? ((ICustomStoneLayer)render).getStoneLayer((LivingRenderer)render) : new LayerStoneEntity((LivingRenderer)render);
                        ((LivingRenderer)render).func_177094_a((LayerRenderer)stoneLayer);
                        ((LivingRenderer)render).func_177094_a(new LayerStoneEntityCrack((LivingRenderer)render));
                    }
                    catch (NullPointerException exp) {
                        IceAndFire.LOGGER.warn("Ice and Fire could not apply stone render layer to " + ((EntityType)entry.getKey()).func_210760_d() + ", someone isn't registering their renderer properly... <.<");
                    }
                }
            }
        }
    }

    private static ResourceLocation getIceTexture(int ticksFrozen) {
        if (ticksFrozen < 100) {
            if (ticksFrozen < 50) {
                if (ticksFrozen < 20) {
                    return TEXTURE_3;
                }
                return TEXTURE_2;
            }
            return TEXTURE_1;
        }
        return TEXTURE_0;
    }

    public static void renderMovingAABB(AxisAlignedBB boundingBox, MatrixStack stack) {
        Tessellator tessellator = Tessellator.func_178181_a();
        IVertexBuilder vertexbuffer = tessellator.func_178180_c().getVertexBuilder();
        BufferBuilder buffer = tessellator.func_178180_c();
        float f3 = 0.0f;
        Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
        float maxX = (float)boundingBox.field_72336_d * 0.425f;
        float minX = (float)boundingBox.field_72340_a * 0.425f;
        float maxY = (float)boundingBox.field_72337_e * 0.425f;
        float minY = (float)boundingBox.field_72338_b * 0.425f;
        float maxZ = (float)boundingBox.field_72334_f * 0.425f;
        float minZ = (float)boundingBox.field_72339_c * 0.425f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225583_a_(f3 + minX - maxX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225583_a_(f3 + maxX - minX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225583_a_(f3 + maxX - minX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225583_a_(f3 + minX - maxX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225583_a_(f3 + minX - maxX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225583_a_(f3 + maxX - minX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225583_a_(f3 + maxX - minX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225583_a_(f3 + minX - maxX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225583_a_(f3 + minX - maxX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225583_a_(f3 + maxX - minX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225583_a_(f3 + maxX - minX, f3 + maxZ - minZ).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225583_a_(f3 + minX - maxX, f3 + maxZ - minZ).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225583_a_(f3 + minX - maxX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225583_a_(f3 + maxX - minX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225583_a_(f3 + maxX - minX, f3 + maxZ - minZ).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225583_a_(f3 + minX - maxX, f3 + maxZ - minZ).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225583_a_(f3 + minX - maxX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225583_a_(f3 + minX - maxX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225583_a_(f3 + maxX - minX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225583_a_(f3 + maxX - minX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225583_a_(f3 + minX - maxX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225583_a_(f3 + minX - maxX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225583_a_(f3 + maxX - minX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225583_a_(f3 + maxX - minX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    private static void func_229108_a_(IVertexBuilder p_229108_0_, Matrix4f p_229108_1_, Matrix3f p_229108_2_, float p_229108_3_, float p_229108_4_, float p_229108_5_, int p_229108_6_, int p_229108_7_, int p_229108_8_, float p_229108_9_, float p_229108_10_, int packedLight) {
        p_229108_0_.func_227888_a_(p_229108_1_, p_229108_3_, p_229108_4_, p_229108_5_).func_225586_a_(p_229108_6_, p_229108_7_, p_229108_8_, 255).func_225583_a_(p_229108_9_, p_229108_10_).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(p_229108_2_, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    @SubscribeEvent
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184187_bx() != null && player.func_184187_bx() instanceof EntityDragonBase) {
            int currentView = IceAndFire.PROXY.getDragon3rdPersonView();
            EntityDragonBase dragon = (EntityDragonBase)player.func_184187_bx();
            float scale = ((EntityDragonBase)player.func_184187_bx()).getRenderSize() / 3.0f;
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 1 && currentView != 0) {
                if (currentView == 1) {
                    event.getInfo().func_216782_a((double)(-scale * 1.2f), 0.0, 0.0);
                } else if (currentView == 2) {
                    event.getInfo().func_216782_a((double)(-scale * 3.0f), 0.0, 0.0);
                } else if (currentView == 3) {
                    event.getInfo().func_216782_a((double)(-scale * 5.0f), 0.0, 0.0);
                }
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 && currentView != 0) {
                if (currentView == 1) {
                    event.getInfo().func_216782_a((double)(-scale * 1.2f), 0.0, 0.0);
                } else if (currentView == 2) {
                    event.getInfo().func_216782_a((double)(-scale * 3.0f), 0.0, 0.0);
                } else if (currentView == 3) {
                    event.getInfo().func_216782_a((double)(-scale * 5.0f), 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (player.field_70170_p.field_72995_K && IafKeybindRegistry.dragon_change_view.func_151470_d()) {
                int currentView = IceAndFire.PROXY.getDragon3rdPersonView();
                currentView = currentView + 1 > 3 ? 0 : ++currentView;
                IceAndFire.PROXY.setDragon3rdPersonView(currentView);
            }
            SirenEntityProperties sirenProps = (SirenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), SirenEntityProperties.class);
            if (player.field_70170_p.field_72995_K && sirenProps != null) {
                GameRenderer renderer = Minecraft.func_71410_x().field_71460_t;
                EntitySiren siren = sirenProps.getSiren(event.getEntityLiving().field_70170_p);
                if (IafConfig.sirenShader && !sirenProps.isCharmed && renderer != null && renderer.func_147706_e() != null && SIREN_SHADER.toString().equals(renderer.func_147706_e().func_148022_b())) {
                    renderer.func_181022_b();
                }
                if (siren == null) {
                    sirenProps.isCharmed = false;
                    return;
                }
                if (sirenProps.isCharmed) {
                    if (player.field_70170_p.field_72995_K && this.rand.nextInt(40) == 0) {
                        IceAndFire.PROXY.spawnParticle("siren_appearance", player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), siren.getHairColor(), 0.0, 0.0);
                    }
                    if (IafConfig.sirenShader && renderer.func_147706_e() == null) {
                        renderer.func_175069_a(SIREN_SHADER);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPreRenderLiving(RenderLivingEvent.Pre event) {
        FrozenEntityProperties frozenProps;
        if (event.getEntity().func_184187_bx() != null && event.getEntity().func_184187_bx() instanceof EntityDragonBase && (ClientProxy.currentDragonRiders.contains(event.getEntity().func_110124_au()) || event.getEntity() == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0)) {
            event.setCanceled(true);
            MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(event.getEntity(), event.getRenderer(), event.getPartialRenderTick(), event.getMatrixStack(), event.getBuffers(), event.getLight()));
        }
        if ((frozenProps = (FrozenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntity(), FrozenEntityProperties.class)) != null && frozenProps.isFrozen) {
            LivingEntity entity = event.getEntity();
            float sideExpand = -0.125f;
            float sideExpandY = 0.325f;
            AxisAlignedBB axisalignedbb1 = new AxisAlignedBB((double)(-entity.func_213311_cf() / 2.0f - sideExpand), 0.0, (double)(-entity.func_213311_cf() / 2.0f - sideExpand), (double)(entity.func_213311_cf() / 2.0f + sideExpand), (double)(entity.func_213302_cg() + sideExpandY), (double)(entity.func_213311_cf() / 2.0f + sideExpand));
            event.getMatrixStack().func_227860_a_();
            event.getMatrixStack().func_227860_a_();
            RenderSystem.enableDepthTest();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ClientEvents.getIceTexture(frozenProps.ticksUntilUnfrozen));
            ClientEvents.renderMovingAABB(axisalignedbb1, event.getMatrixStack());
            RenderSystem.disableDepthTest();
            event.getMatrixStack().func_227865_b_();
            event.getMatrixStack().func_227865_b_();
        }
    }

    @SubscribeEvent
    public void onPostRenderLiving(RenderLivingEvent.Post event) {
        LivingEntity entity = event.getEntity();
        ChainEntityProperties properties = (ChainEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entity, ChainEntityProperties.class);
        MiscEntityProperties miscProps = (MiscEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entity, MiscEntityProperties.class);
        if (miscProps != null && miscProps.glarers.size() > 0) {
            MatrixStack matrixStackIn = event.getMatrixStack();
            LivingEntity entityIn = entity;
            for (Entity livingentity : miscProps.glarers) {
                float f = 1.0f;
                float f1 = (float)entityIn.field_70170_p.func_82737_E() + event.getPartialRenderTick();
                float f2 = f1 * 0.5f % 1.0f;
                float f3 = entityIn.func_70047_e();
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_(0.0, (double)f3, 0.0);
                Vec3d vec3d = this.getPosition(livingentity, (double)livingentity.func_213302_cg() * 0.5, event.getPartialRenderTick());
                Vec3d vec3d1 = this.getPosition((Entity)entityIn, f3, event.getPartialRenderTick());
                Vec3d vec3d2 = vec3d.func_178788_d(vec3d1);
                float f4 = (float)(vec3d2.func_72433_c() + 1.0);
                vec3d2 = vec3d2.func_72432_b();
                float f5 = (float)Math.acos(vec3d2.field_72448_b);
                float f6 = (float)Math.atan2(vec3d2.field_72449_c, vec3d2.field_72450_a);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((1.5707964f - f6) * 57.295776f));
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f5 * 57.295776f));
                boolean i = true;
                float f7 = f1 * 0.05f * -1.5f;
                float f8 = f * f;
                int j = 64 + (int)(f8 * 191.0f);
                int k = 32 + (int)(f8 * 191.0f);
                int l = 128 - (int)(f8 * 64.0f);
                float f9 = 0.2f;
                float f10 = 0.282f;
                float f11 = MathHelper.func_76134_b((float)(f7 + 2.3561945f)) * 0.282f;
                float f12 = MathHelper.func_76126_a((float)(f7 + 2.3561945f)) * 0.282f;
                float f13 = MathHelper.func_76134_b((float)(f7 + 0.7853982f)) * 0.282f;
                float f14 = MathHelper.func_76126_a((float)(f7 + 0.7853982f)) * 0.282f;
                float f15 = MathHelper.func_76134_b((float)(f7 + 3.926991f)) * 0.282f;
                float f16 = MathHelper.func_76126_a((float)(f7 + 3.926991f)) * 0.282f;
                float f17 = MathHelper.func_76134_b((float)(f7 + 5.4977875f)) * 0.282f;
                float f18 = MathHelper.func_76126_a((float)(f7 + 5.4977875f)) * 0.282f;
                float f19 = MathHelper.func_76134_b((float)(f7 + (float)Math.PI)) * 0.2f;
                float f20 = MathHelper.func_76126_a((float)(f7 + (float)Math.PI)) * 0.2f;
                float f21 = MathHelper.func_76134_b((float)(f7 + 0.0f)) * 0.2f;
                float f22 = MathHelper.func_76126_a((float)(f7 + 0.0f)) * 0.2f;
                float f23 = MathHelper.func_76134_b((float)(f7 + 1.5707964f)) * 0.2f;
                float f24 = MathHelper.func_76126_a((float)(f7 + 1.5707964f)) * 0.2f;
                float f25 = MathHelper.func_76134_b((float)(f7 + 4.712389f)) * 0.2f;
                float f26 = MathHelper.func_76126_a((float)(f7 + 4.712389f)) * 0.2f;
                float f27 = 0.0f;
                float f28 = 0.4999f;
                float f29 = -1.0f + f2;
                float f30 = f4 * 2.5f + f29;
                IVertexBuilder ivertexbuilder = event.getBuffers().getBuffer(RenderCockatrice.TEXTURE_BEAM);
                MatrixStack.Entry matrixstack$entry = event.getMatrixStack().func_227866_c_();
                Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
                Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
                int light = 0xF000F0;
                ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f19, f4, f20, j, k, l, 0.4999f, f30, light);
                ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f19, 0.0f, f20, j, k, l, 0.4999f, f29, light);
                ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f21, 0.0f, f22, j, k, l, 0.0f, f29, light);
                ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f21, f4, f22, j, k, l, 0.0f, f30, light);
                ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f23, f4, f24, j, k, l, 0.4999f, f30, light);
                ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f23, 0.0f, f24, j, k, l, 0.4999f, f29, light);
                ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f25, 0.0f, f26, j, k, l, 0.0f, f29, light);
                ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f25, f4, f26, j, k, l, 0.0f, f30, light);
                float f31 = 0.0f;
                if (entityIn.field_70173_aa % 2 == 0) {
                    f31 = 0.5f;
                }
                ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f11, f4, f12, j, k, l, 0.5f, f31 + 0.5f, light);
                ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f13, f4, f14, j, k, l, 1.0f, f31 + 0.5f, light);
                ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f17, f4, f18, j, k, l, 1.0f, f31, light);
                ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f15, f4, f16, j, k, l, 0.5f, f31, light);
                matrixStackIn.func_227865_b_();
            }
        }
        if (properties != null) {
            if (!properties.connectedEntities.isEmpty()) {
                try {
                    for (Entity livingentity : properties.connectedEntities) {
                        if (!properties.alreadyIgnoresCamera) {
                            entity.field_70158_ak = true;
                        }
                        MatrixStack matrixStackIn = event.getMatrixStack();
                        float f = 1.0f;
                        float f1 = 0.0f;
                        float f2 = 1.0f;
                        float f3 = entity.func_70047_e();
                        matrixStackIn.func_227860_a_();
                        matrixStackIn.func_227861_a_(0.0, (double)f3, 0.0);
                        Vec3d vec3d = this.getPosition(livingentity, (double)livingentity.func_213302_cg() * 0.5, event.getPartialRenderTick());
                        Vec3d vec3d1 = this.getPosition((Entity)entity, f3, event.getPartialRenderTick());
                        Vec3d vec3d2 = vec3d.func_178788_d(vec3d1);
                        float f4 = (float)(vec3d2.func_72433_c() + 0.0);
                        vec3d2 = vec3d2.func_72432_b();
                        float f5 = (float)Math.acos(vec3d2.field_72448_b);
                        float f6 = (float)Math.atan2(vec3d2.field_72449_c, vec3d2.field_72450_a);
                        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((1.5707964f - f6) * 57.295776f));
                        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f5 * 57.295776f));
                        boolean i = true;
                        float f7 = -1.0f;
                        float f8 = f * f;
                        int j = 255;
                        int k = 255;
                        int l = 255;
                        float f11 = MathHelper.func_76134_b((float)(f7 + 2.3561945f)) * 0.282f;
                        float f12 = MathHelper.func_76126_a((float)(f7 + 2.3561945f)) * 0.282f;
                        float f13 = MathHelper.func_76134_b((float)(f7 + 0.7853982f)) * 0.282f;
                        float f14 = MathHelper.func_76126_a((float)(f7 + 0.7853982f)) * 0.282f;
                        float f15 = MathHelper.func_76134_b((float)(f7 + 3.926991f)) * 0.282f;
                        float f16 = MathHelper.func_76126_a((float)(f7 + 3.926991f)) * 0.282f;
                        float f17 = MathHelper.func_76134_b((float)(f7 + 5.4977875f)) * 0.282f;
                        float f18 = MathHelper.func_76126_a((float)(f7 + 5.4977875f)) * 0.282f;
                        float f19 = 0.0f;
                        float f20 = 0.2f;
                        float f21 = 0.0f;
                        float f22 = -0.2f;
                        float f23 = MathHelper.func_76134_b((float)(f7 + 1.5707964f)) * 0.2f;
                        float f24 = MathHelper.func_76126_a((float)(f7 + 1.5707964f)) * 0.2f;
                        float f25 = MathHelper.func_76134_b((float)(f7 + 4.712389f)) * 0.2f;
                        float f26 = MathHelper.func_76126_a((float)(f7 + 4.712389f)) * 0.2f;
                        float f27 = 0.0f;
                        float f28 = 0.4999f;
                        float f29 = 0.0f;
                        float f30 = f4 + f29;
                        float f32 = 0.75f;
                        float f31 = f4 + f32;
                        IVertexBuilder ivertexbuilder = event.getBuffers().getBuffer(RenderType.func_228640_c_((ResourceLocation)CHAIN_TEXTURE));
                        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
                        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
                        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
                        matrixStackIn.func_227860_a_();
                        int light = event.getLight();
                        ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f19, f4, f20, j, k, l, 0.4999f, f30, light);
                        ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f19, 0.0f, f20, j, k, l, 0.4999f, f29, light);
                        ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f21, 0.0f, f22, j, k, l, 0.0f, f29, light);
                        ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f21, f4, f22, j, k, l, 0.0f, f30, light);
                        ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f23, f4, f24, j, k, l, 0.4999f, f31, light);
                        ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f23, 0.0f, f24, j, k, l, 0.4999f, f32, light);
                        ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f25, 0.0f, f26, j, k, l, 0.0f, f32, light);
                        ClientEvents.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f25, f4, f26, j, k, l, 0.0f, f31, light);
                        matrixStackIn.func_227865_b_();
                        matrixStackIn.func_227865_b_();
                    }
                }
                catch (Exception e) {
                    IceAndFire.LOGGER.warn("Could not render chain link");
                }
            } else if (!properties.alreadyIgnoresCamera && entity.field_70158_ak) {
                entity.field_70158_ak = false;
            }
        }
    }

    private Vec3d getPosition(Entity LivingEntityIn, double p_177110_2_, float p_177110_4_) {
        double d0 = LivingEntityIn.field_70142_S + (LivingEntityIn.func_226277_ct_() - LivingEntityIn.field_70142_S) * (double)p_177110_4_;
        double d1 = p_177110_2_ + LivingEntityIn.field_70137_T + (LivingEntityIn.func_226278_cu_() - LivingEntityIn.field_70137_T) * (double)p_177110_4_;
        double d2 = LivingEntityIn.field_70136_U + (LivingEntityIn.func_226281_cx_() - LivingEntityIn.field_70136_U) * (double)p_177110_4_;
        return new Vec3d(d0, d1, d2);
    }

    private double acos(double x) {
        return (-0.6981317007977321 * x * x - 0.8726646259971648) * x + 1.5707963267948966;
    }

    private Vec3d getChainPosition(Entity LivingEntityIn, double p_177110_2_, float p_177110_4_) {
        double d0 = LivingEntityIn.field_70142_S + (LivingEntityIn.func_226277_ct_() - LivingEntityIn.field_70142_S) * (double)p_177110_4_;
        double d1 = p_177110_2_ + LivingEntityIn.field_70137_T + (LivingEntityIn.func_226278_cu_() - LivingEntityIn.field_70137_T) * (double)p_177110_4_;
        double d2 = LivingEntityIn.field_70136_U + (LivingEntityIn.func_226281_cx_() - LivingEntityIn.field_70136_U) * (double)p_177110_4_;
        return new Vec3d(d0, d1, d2);
    }

    @SubscribeEvent
    public void onGuiOpened(GuiOpenEvent event) {
        if (IafConfig.customMainMenu && event.getGui() instanceof MainMenuScreen && !(event.getGui() instanceof IceAndFireMainMenu)) {
            event.setGui((Screen)new IceAndFireMainMenu());
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        EntityDragonBase dragon;
        if (IafConfig.dragonAuto3rdPerson && event.getEntityBeingMounted() instanceof EntityDragonBase && event.getWorldObj().field_72995_K && event.getEntityMounting() == Minecraft.func_71410_x().field_71439_g && (dragon = (EntityDragonBase)event.getEntityBeingMounted()).func_70909_n() && dragon.func_152114_e((LivingEntity)Minecraft.func_71410_x().field_71439_g)) {
            if (event.isDismounting()) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = IceAndFire.PROXY.getPreviousViewType();
            } else {
                IceAndFire.PROXY.setPreviousViewType(Minecraft.func_71410_x().field_71474_y.field_74320_O);
                Minecraft.func_71410_x().field_71474_y.field_74320_O = 1;
                IceAndFire.PROXY.setDragon3rdPersonView(2);
            }
        }
    }
}

