/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.event;

import com.github.alexthe666.citadel.server.entity.EntityPropertiesHandler;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityAmphithere;
import com.github.alexthe666.iceandfire.entity.EntityCockatrice;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityGhost;
import com.github.alexthe666.iceandfire.entity.EntityGhostSword;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import com.github.alexthe666.iceandfire.entity.EntityHydraHead;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.EntitySheepAIFollowCyclops;
import com.github.alexthe666.iceandfire.entity.ai.VillagerAIFearUntamed;
import com.github.alexthe666.iceandfire.entity.props.ChainEntityProperties;
import com.github.alexthe666.iceandfire.entity.props.ChickenEntityProperties;
import com.github.alexthe666.iceandfire.entity.props.FrozenEntityProperties;
import com.github.alexthe666.iceandfire.entity.props.MiscEntityProperties;
import com.github.alexthe666.iceandfire.entity.props.SirenEntityProperties;
import com.github.alexthe666.iceandfire.entity.props.StoneEntityProperties;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IHearsSiren;
import com.github.alexthe666.iceandfire.entity.util.IPhasesThroughBlock;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemBlindfold;
import com.github.alexthe666.iceandfire.item.ItemChain;
import com.github.alexthe666.iceandfire.item.ItemCockatriceScepter;
import com.github.alexthe666.iceandfire.item.ItemDeathwormGauntlet;
import com.github.alexthe666.iceandfire.item.ItemScaleArmor;
import com.github.alexthe666.iceandfire.item.ItemSeaSerpentArmor;
import com.github.alexthe666.iceandfire.item.ItemTrollArmor;
import com.github.alexthe666.iceandfire.message.MessagePlayerHitMultipart;
import com.github.alexthe666.iceandfire.message.MessageSwingArm;
import com.github.alexthe666.iceandfire.misc.IafDamageRegistry;
import com.github.alexthe666.iceandfire.misc.IafTagRegistry;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonCave;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.WallBlock;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="iceandfire")
public class ServerEvents {
    public static final UUID ALEX_UUID = UUID.fromString("71363abe-fd03-49c9-940d-aae8b8209b7c");
    private static final com.google.common.base.Predicate VILLAGER_FEAR = new com.google.common.base.Predicate<LivingEntity>(){

        public boolean apply(@Nullable LivingEntity entity) {
            return entity != null && entity instanceof IVillagerFear;
        }
    };
    private Random rand = new Random();

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ServerEvents.onLeftClick(event.getPlayer(), event.getItemStack());
        if (event.getWorld().field_72995_K) {
            IceAndFire.sendMSGToServer(new MessageSwingArm());
        }
    }

    public static void onLeftClick(PlayerEntity living, ItemStack stack) {
        if (stack.func_77973_b() == IafItemRegistry.GHOST_SWORD && living.field_70733_aJ == 0.0f) {
            Multimap dmg = stack.func_111283_C(EquipmentSlotType.MAINHAND);
            double totalDmg = 0.0;
            for (Map.Entry entry : dmg.entries()) {
                if (!((AttributeModifier)entry.getValue()).func_111167_a().toString().equals("CB3F55D3-645C-4F38-A497-9C13A33DB5CF")) continue;
                totalDmg += ((AttributeModifier)entry.getValue()).func_111164_d();
            }
            living.func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
            EntityGhostSword shot = new EntityGhostSword(IafEntityRegistry.GHOST_SWORD, living.field_70170_p, (LivingEntity)living, totalDmg * 0.5);
            Vec3d vector3d = living.func_70676_i(1.0f);
            Vector3f vector3f = new Vector3f(vector3d);
            shot.func_70186_c(vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c(), 1.0f, 0.5f);
            living.field_70170_p.func_217376_c((Entity)shot);
        }
    }

    private static void signalChickenAlarm(LivingEntity chicken, LivingEntity attacker) {
        float d0 = IafConfig.cockatriceChickenSearchLength;
        List list = chicken.field_70170_p.func_217357_a(EntityCockatrice.class, new AxisAlignedBB(chicken.func_226277_ct_(), chicken.func_226278_cu_(), chicken.func_226281_cx_(), chicken.func_226277_ct_() + 1.0, chicken.func_226278_cu_() + 1.0, chicken.func_226281_cx_() + 1.0).func_72314_b((double)d0, 10.0, (double)d0));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                EntityCockatrice cockatrice;
                if (!(entity instanceof EntityCockatrice) || attacker instanceof EntityCockatrice || DragonUtils.hasSameOwner(cockatrice = (EntityCockatrice)entity, (Entity)attacker)) continue;
                if (attacker instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)attacker;
                    if (player.func_184812_l_() || cockatrice.func_152114_e((LivingEntity)player)) continue;
                    cockatrice.func_70624_b((LivingEntity)player);
                    continue;
                }
                cockatrice.func_70624_b(attacker);
            }
        }
    }

    private static void signalAmphithereAlarm(LivingEntity villager, LivingEntity attacker) {
        float d0 = IafConfig.amphithereVillagerSearchLength;
        List list = villager.field_70170_p.func_217357_a(EntityAmphithere.class, new AxisAlignedBB(villager.func_226277_ct_() - 1.0, villager.func_226278_cu_() - 1.0, villager.func_226281_cx_() - 1.0, villager.func_226277_ct_() + 1.0, villager.func_226278_cu_() + 1.0, villager.func_226281_cx_() + 1.0).func_72314_b((double)d0, (double)d0, (double)d0));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                TameableEntity amphithere;
                if (!(entity instanceof EntityAmphithere) || attacker instanceof EntityAmphithere || DragonUtils.hasSameOwner(amphithere = (TameableEntity)entity, (Entity)attacker)) continue;
                if (attacker instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)attacker;
                    if (player.func_184812_l_() || amphithere.func_152114_e((LivingEntity)player)) continue;
                    amphithere.func_70624_b((LivingEntity)player);
                    continue;
                }
                amphithere.func_70624_b(attacker);
            }
        }
    }

    public static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    public static boolean isLivestock(Entity entity) {
        return EntityTypeTags.func_219762_a().func_199915_b(IafTagRegistry.FEAR_DRAGONS).func_199685_a_((Object)entity.func_200600_R());
    }

    public static boolean isVillager(Entity entity) {
        return EntityTypeTags.func_219762_a().func_199915_b(IafTagRegistry.VILLAGERS).func_199685_a_((Object)entity.func_200600_R());
    }

    public static boolean isAnimaniaSheep(Entity entity) {
        return EntityTypeTags.func_219762_a().func_199915_b(IafTagRegistry.SHEEP).func_199685_a_((Object)entity.func_200600_R());
    }

    public static boolean isAnimaniaChicken(Entity entity) {
        return EntityTypeTags.func_219762_a().func_199915_b(IafTagRegistry.CHICKENS).func_199685_a_((Object)entity.func_200600_R());
    }

    public static boolean isAnimaniaFerret(Entity entity) {
        return EntityTypeTags.func_219762_a().func_199915_b(IafTagRegistry.SCARES_COCKATRICES).func_199685_a_((Object)entity.func_200600_R());
    }

    @SubscribeEvent
    public void onArrowCollide(ProjectileImpactEvent event) {
        if (event.getEntity() instanceof AbstractArrowEntity && ((AbstractArrowEntity)event.getEntity()).field_70250_c != null && event.getRayTraceResult() instanceof EntityRayTraceResult && ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a() != null) {
            Entity shootingEntity = ((AbstractArrowEntity)event.getEntity()).func_212360_k();
            Entity shotEntity = ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a();
            if (shootingEntity instanceof LivingEntity && shootingEntity.func_184215_y(shotEntity) && shotEntity instanceof TameableEntity && ((TameableEntity)shotEntity).func_70909_n() && shotEntity.func_184191_r(shootingEntity)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttackMob(AttackEntityEvent event) {
        if (event.getTarget() instanceof EntityMutlipartPart && event.getEntity() instanceof PlayerEntity) {
            event.setCanceled(true);
            LivingEntity parent = ((EntityMutlipartPart)event.getTarget()).getParent();
            try {
                ((PlayerEntity)event.getEntity()).func_71059_n((Entity)parent);
            }
            catch (Exception e) {
                IceAndFire.LOGGER.warn("Exception thrown while interacting with entity");
            }
            int extraData = 0;
            if (event.getTarget() instanceof EntityHydraHead && parent instanceof EntityHydra) {
                extraData = ((EntityHydraHead)event.getTarget()).headIndex;
                ((EntityHydra)parent).triggerHeadFlags(extraData);
            }
            if (event.getTarget().field_70170_p.field_72995_K && parent != null) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessagePlayerHitMultipart(parent.func_145782_y(), extraData));
            }
        }
    }

    @SubscribeEvent
    public void onGatherCollisionBoxes(GetCollisionBoxesEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof IPhasesThroughBlock) {
            Iterator itr = event.getCollisionBoxesList().iterator();
            while (itr.hasNext()) {
                AxisAlignedBB aabb = (AxisAlignedBB)itr.next();
                BlockPos pos = new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
                if (!((IPhasesThroughBlock)event.getEntity()).canPhaseThroughBlock(event.getWorld(), pos)) continue;
                itr.remove();
            }
        }
    }

    @SubscribeEvent
    public void onEntityFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            MiscEntityProperties properties = (MiscEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), MiscEntityProperties.class);
            if (properties.hasDismountedDragon) {
                event.setDamageMultiplier(0.0f);
                properties.hasDismountedDragon = false;
            }
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
    }

    @SubscribeEvent
    public void onEntityDamage(LivingHurtEvent event) {
        float multi;
        if (event.getSource().func_76352_a()) {
            multi = 1.0f;
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof ItemTrollArmor) {
                multi = (float)((double)multi - 0.1);
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ItemTrollArmor) {
                multi = (float)((double)multi - 0.3);
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.LEGS).func_77973_b() instanceof ItemTrollArmor) {
                multi = (float)((double)multi - 0.2);
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET).func_77973_b() instanceof ItemTrollArmor) {
                multi = (float)((double)multi - 0.1);
            }
            event.setAmount(event.getAmount() * multi);
        }
        if (event.getSource() == IafDamageRegistry.DRAGON_FIRE || event.getSource() == IafDamageRegistry.DRAGON_ICE) {
            multi = 1.0f;
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof ItemScaleArmor) {
                multi = (float)((double)multi - 0.1);
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ItemScaleArmor) {
                multi = (float)((double)multi - 0.3);
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.LEGS).func_77973_b() instanceof ItemScaleArmor) {
                multi = (float)((double)multi - 0.2);
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET).func_77973_b() instanceof ItemScaleArmor) {
                multi = (float)((double)multi - 0.1);
            }
            event.setAmount(event.getAmount() * multi);
        }
    }

    @SubscribeEvent
    public void onEntityDrop(LivingDropsEvent event) {
        StoneEntityProperties properties;
        if (event.getEntityLiving() instanceof WitherSkeletonEntity) {
            event.getDrops().add(new ItemEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), new ItemStack((IItemProvider)IafItemRegistry.WITHERBONE, event.getEntityLiving().func_70681_au().nextInt(2))));
        }
        if (event.getEntityLiving() instanceof LivingEntity && (properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), StoneEntityProperties.class)) != null && properties.isStone()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityDespawn(LivingSpawnEvent.AllowDespawn event) {
        StoneEntityProperties properties;
        if (event.getEntityLiving() instanceof LivingEntity && (properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), StoneEntityProperties.class)) != null && properties.isStone()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent event) {
        if (event.getSource().func_76346_g() != null) {
            Entity attacker = event.getSource().func_76346_g();
            MiscEntityProperties properties = (MiscEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(attacker, MiscEntityProperties.class);
            if (properties != null && properties.inLoveTicks > 0) {
                event.setCanceled(true);
            }
            if (ServerEvents.isAnimaniaChicken((Entity)event.getEntityLiving()) && attacker instanceof LivingEntity) {
                ServerEvents.signalChickenAlarm(event.getEntityLiving(), (LivingEntity)attacker);
            }
            if (DragonUtils.isVillager((Entity)event.getEntityLiving()) && attacker instanceof LivingEntity) {
                ServerEvents.signalAmphithereAlarm(event.getEntityLiving(), (LivingEntity)attacker);
            }
        }
    }

    @SubscribeEvent
    public void onLivingSetTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() != null) {
            LivingEntity attacker = event.getEntityLiving();
            if (ServerEvents.isAnimaniaChicken((Entity)event.getTarget())) {
                ServerEvents.signalChickenAlarm(event.getTarget(), attacker);
            }
            if (DragonUtils.isVillager((Entity)event.getTarget())) {
                ServerEvents.signalAmphithereAlarm(event.getTarget(), attacker);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        if (event.getTarget() != null && ServerEvents.isAnimaniaSheep(event.getTarget())) {
            float dist = IafConfig.cyclopesSheepSearchLength;
            List list = event.getTarget().field_70170_p.func_72839_b((Entity)event.getPlayer(), event.getPlayer().func_174813_aQ().func_72321_a((double)dist, (double)dist, (double)dist));
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    EntityCyclops cyclops;
                    if (!(entity instanceof EntityCyclops) || (cyclops = (EntityCyclops)entity).isBlinded() || event.getPlayer().func_184812_l_()) continue;
                    cyclops.func_70624_b((LivingEntity)event.getPlayer());
                }
            }
        }
        if (event.getTarget() instanceof LivingEntity) {
            boolean stonePlayer = event.getTarget() instanceof EntityStoneStatue;
            StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getTarget(), StoneEntityProperties.class);
            if (properties != null && properties.isStone() || stonePlayer) {
                ((LivingEntity)event.getTarget()).func_70606_j(((LivingEntity)event.getTarget()).func_110138_aP());
                if (event.getPlayer() != null) {
                    ItemStack stack = event.getPlayer().func_184614_ca();
                    event.getTarget().func_184185_a(SoundEvents.field_187843_fX, 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.5f);
                    if (stack.func_77973_b() != null && (stack.func_77973_b().func_150897_b(Blocks.field_150348_b.func_176223_P()) || stack.func_77973_b().func_77658_a().contains("pickaxe"))) {
                        boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
                        boolean ready = false;
                        if (properties != null && !stonePlayer) {
                            properties.setBreakLevel(properties.getBreakLevel() + 1);
                            ready = properties.getBreakLevel() > 9;
                        }
                        event.setCanceled(true);
                        if (stonePlayer) {
                            EntityStoneStatue statue = (EntityStoneStatue)event.getTarget();
                            statue.setCrackAmount(statue.getCrackAmount() + 1);
                            boolean bl = ready = statue.getCrackAmount() > 9;
                        }
                        if (ready) {
                            event.getTarget().func_184185_a(SoundEvents.field_187835_fT, 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.5f);
                            event.getTarget().func_70106_y();
                            if (silkTouch) {
                                ItemStack statuette = new ItemStack((IItemProvider)IafItemRegistry.STONE_STATUE);
                                statuette.func_77982_d(new CompoundNBT());
                                statuette.func_77978_p().func_74757_a("IAFStoneStatuePlayerEntity", stonePlayer);
                                statuette.func_77978_p().func_74778_a("IAFStoneStatueEntityID", Registry.field_212629_r.func_177774_c((Object)event.getTarget().func_200600_R()).toString());
                                ((LivingEntity)event.getTarget()).func_213281_b(statuette.func_77978_p());
                                if (!event.getTarget().field_70170_p.field_72995_K) {
                                    event.getTarget().func_70099_a(statuette, 1.0f);
                                }
                            } else if (!((LivingEntity)event.getTarget()).field_70170_p.field_72995_K) {
                                event.getTarget().func_199702_a((IItemProvider)Item.func_150898_a((Block)Blocks.field_150347_e), 2 + event.getEntityLiving().func_70681_au().nextInt(4));
                            }
                            event.getTarget().func_70106_y();
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityStopUsingItem(LivingEntityUseItemEvent.Tick event) {
        if (event.getItem().func_77973_b() instanceof ItemDeathwormGauntlet || event.getItem().func_77973_b() instanceof ItemCockatriceScepter) {
            event.setDuration(20);
        }
    }

    @SubscribeEvent
    public void onEntityUseItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntityLiving() instanceof PlayerEntity && event.getEntityLiving().field_70125_A > 87.0f && event.getEntityLiving().func_184187_bx() != null && event.getEntityLiving().func_184187_bx() instanceof EntityDragonBase) {
            ((EntityDragonBase)event.getEntityLiving().func_184187_bx()).func_184645_a((PlayerEntity)event.getEntityLiving(), event.getHand());
        }
        if (event.getEntityLiving() instanceof EntityDragonBase && !event.getEntityLiving().func_70089_S()) {
            event.setResult(Event.Result.DENY);
            ((EntityDragonBase)event.getEntityLiving()).func_184645_a(event.getPlayer(), event.getHand());
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        MiscEntityProperties properties;
        EntitySiren closestSiren;
        SirenEntityProperties sirenProps;
        FrozenEntityProperties frozenProps;
        ChickenEntityProperties chickenProps;
        ChainEntityProperties chainProperties = (ChainEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), ChainEntityProperties.class);
        if (chainProperties != null && chainProperties.isChained()) {
            if (chainProperties.wasJustDisconnected) {
                chainProperties.wasJustDisconnected = false;
            }
            if (!event.getEntityLiving().field_70170_p.field_72995_K) {
                chainProperties.updateConnectedEntities((Entity)event.getEntityLiving());
                for (Entity chainer : chainProperties.connectedEntities) {
                    float f = event.getEntityLiving().func_70032_d(chainer);
                    if (!(f > 7.0f)) continue;
                    double d0 = (chainer.func_226277_ct_() - event.getEntityLiving().func_226277_ct_()) / (double)f;
                    double d1 = (chainer.func_226278_cu_() - event.getEntityLiving().func_226278_cu_()) / (double)f;
                    double d2 = (chainer.func_226281_cx_() - event.getEntityLiving().func_226281_cx_()) / (double)f;
                    event.getEntityLiving().func_213317_d(event.getEntity().func_213322_ci().func_72441_c(d0 * Math.abs(d0) * 0.4, d1 * Math.abs(d1) * 0.2, d2 * Math.abs(d2) * 0.4));
                }
            }
        }
        try {
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof ItemSeaSerpentArmor || event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ItemSeaSerpentArmor || event.getEntityLiving().func_184582_a(EquipmentSlotType.LEGS).func_77973_b() instanceof ItemSeaSerpentArmor || event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET).func_77973_b() instanceof ItemSeaSerpentArmor) {
                event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76427_o, 50, 0, false, false));
                if (event.getEntityLiving().func_70026_G()) {
                    int headMod = event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
                    int chestMod = event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
                    int legMod = event.getEntityLiving().func_184582_a(EquipmentSlotType.LEGS).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
                    int footMod = event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
                    event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76420_g, 50, headMod + chestMod + legMod + footMod - 1, false, false));
                }
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof ItemBlindfold) {
                event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76440_q, 50, 0, false, false));
            }
        }
        catch (Exception headMod) {
            // empty catch block
        }
        if (IafConfig.chickensLayRottenEggs && !event.getEntityLiving().field_70170_p.field_72995_K && ServerEvents.isAnimaniaChicken((Entity)event.getEntityLiving()) && !event.getEntityLiving().func_70631_g_() && event.getEntityLiving() instanceof AnimalEntity && (chickenProps = (ChickenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), ChickenEntityProperties.class)) != null) {
            if (chickenProps.timeUntilNextEgg < 0) {
                chickenProps.timeUntilNextEgg = 0;
            }
            if (chickenProps.timeUntilNextEgg == 0) {
                if (event.getEntityLiving().func_70681_au().nextInt(IafConfig.cockatriceEggChance + 1) == 0 && event.getEntityLiving().field_70173_aa > 30) {
                    event.getEntityLiving().func_184185_a(SoundEvents.field_187666_Z, 2.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
                    event.getEntityLiving().func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
                    event.getEntityLiving().func_199702_a((IItemProvider)IafItemRegistry.ROTTEN_EGG, 1);
                }
                chickenProps.timeUntilNextEgg = chickenProps.generateTime();
            } else if (chickenProps.timeUntilNextEgg > 0) {
                --chickenProps.timeUntilNextEgg;
            }
        }
        if ((frozenProps = (FrozenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), FrozenEntityProperties.class)) != null) {
            boolean prevFrozen = frozenProps.isFrozen;
            if (event.getEntityLiving() instanceof EntityIceDragon) {
                frozenProps.isFrozen = false;
            }
            if (!event.getEntityLiving().field_70170_p.field_72995_K) {
                if (frozenProps.isFrozen && event.getEntityLiving().func_70027_ad()) {
                    frozenProps.isFrozen = false;
                    event.getEntityLiving().func_70066_B();
                }
                if (event.getEntityLiving().field_70725_aQ > 0) {
                    frozenProps.isFrozen = false;
                }
                if (frozenProps.ticksUntilUnfrozen > 0) {
                    --frozenProps.ticksUntilUnfrozen;
                } else {
                    frozenProps.ticksUntilUnfrozen = 0;
                    frozenProps.isFrozen = false;
                }
            }
            if (!(!frozenProps.isFrozen || event.getEntityLiving() instanceof PlayerEntity && ((PlayerEntity)event.getEntityLiving()).func_184812_l_())) {
                event.getEntity().func_213317_d(event.getEntity().func_213322_ci().func_216372_d(0.25, 1.0, 0.25));
                if (!(event.getEntityLiving() instanceof EnderDragonEntity) && !event.getEntityLiving().field_70122_E) {
                    event.getEntity().func_213317_d(event.getEntity().func_213322_ci().func_72441_c(0.0, -0.2, 0.0));
                }
            }
            if (prevFrozen != frozenProps.isFrozen) {
                if (frozenProps.isFrozen) {
                    event.getEntityLiving().func_184185_a(SoundEvents.field_187567_bP, 1.0f, 1.0f);
                } else {
                    for (int i = 0; i < 15; ++i) {
                        event.getEntityLiving().field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, IafBlockRegistry.DRAGON_ICE.func_176223_P()), event.getEntityLiving().func_226277_ct_() + (this.rand.nextDouble() - 0.5) * (double)event.getEntityLiving().func_213311_cf(), event.getEntityLiving().func_226278_cu_() + this.rand.nextDouble() * (double)event.getEntityLiving().func_213302_cg(), event.getEntityLiving().func_226281_cx_() + (this.rand.nextDouble() - 0.5) * (double)event.getEntityLiving().func_213311_cf(), 0.0, 0.0, 0.0);
                    }
                    event.getEntityLiving().func_184185_a(SoundEvents.field_187561_bM, 3.0f, 1.0f);
                }
            }
        }
        if ((event.getEntityLiving() instanceof PlayerEntity || event.getEntityLiving() instanceof AbstractVillagerEntity || event.getEntityLiving() instanceof IHearsSiren) && (sirenProps = (SirenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), SirenEntityProperties.class)) != null && sirenProps.sirenID != 0 && (closestSiren = sirenProps.getSiren(event.getEntityLiving().field_70170_p)) != null && closestSiren.isActuallySinging()) {
            if (EntitySiren.isWearingEarplugs(event.getEntityLiving()) || sirenProps.singTime > IafConfig.sirenMaxSingTime) {
                sirenProps.isCharmed = false;
                sirenProps.sirenID = 0;
                sirenProps.singTime = 0;
                closestSiren.singCooldown = IafConfig.sirenTimeBetweenSongs;
            } else {
                sirenProps.isCharmed = true;
                ++sirenProps.singTime;
                if (this.rand.nextInt(7) == 0) {
                    for (int i = 0; i < 5; ++i) {
                        event.getEntityLiving().field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, event.getEntityLiving().func_226277_ct_() + (this.rand.nextDouble() - 0.5) * 3.0, event.getEntityLiving().func_226278_cu_() + (this.rand.nextDouble() - 0.5) * 3.0, event.getEntityLiving().func_226281_cx_() + (this.rand.nextDouble() - 0.5) * 3.0, 0.0, 0.0, 0.0);
                    }
                }
                LivingEntity entity = event.getEntityLiving();
                if (entity.field_70123_F) {
                    if (entity instanceof LivingEntity) {
                        entity.func_70637_d(true);
                    } else if (entity.field_70122_E) {
                        entity.func_213317_d(entity.func_213322_ci().func_72441_c(0.0, 0.42, 0.0));
                    }
                }
                double motionXAdd = (Math.signum(closestSiren.func_226277_ct_() - entity.func_226277_ct_()) * 0.5 - entity.func_213322_ci().field_72450_a) * 0.100000000372529;
                double motionYAdd = (Math.signum(closestSiren.func_226278_cu_() - entity.func_226278_cu_() + 1.0) * 0.5 - entity.func_213322_ci().field_72448_b) * 0.100000000372529;
                double motionZAdd = (Math.signum(closestSiren.func_226281_cx_() - entity.func_226281_cx_()) * 0.5 - entity.func_213322_ci().field_72449_c) * 0.100000000372529;
                entity.func_213317_d(entity.func_213322_ci().func_72441_c(motionXAdd, motionYAdd, motionZAdd));
                float angle = (float)(Math.atan2(entity.func_213322_ci().field_72449_c, entity.func_213322_ci().field_72450_a) * 180.0 / Math.PI) - 90.0f;
                double d0 = closestSiren.func_226277_ct_() - entity.func_226277_ct_();
                double d2 = closestSiren.func_226281_cx_() - entity.func_226281_cx_();
                double d1 = closestSiren.func_226278_cu_() - 1.0 - entity.func_226278_cu_();
                if (entity.func_184218_aH()) {
                    entity.func_184210_p();
                }
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
                if (!(entity instanceof PlayerEntity)) {
                    entity.field_70125_A = ServerEvents.updateRotation(entity.field_70125_A, f1, 30.0f);
                    entity.field_70177_z = ServerEvents.updateRotation(entity.field_70177_z, f, 30.0f);
                }
                if ((double)entity.func_70032_d((Entity)closestSiren) < 5.0) {
                    sirenProps.isCharmed = false;
                    sirenProps.sirenID = 0;
                    sirenProps.singTime = 0;
                    closestSiren.singCooldown = IafConfig.sirenTimeBetweenSongs;
                    closestSiren.setSinging(false);
                    closestSiren.func_70624_b(entity);
                    closestSiren.setAggressive(true);
                    closestSiren.triggerOtherSirens(entity);
                }
                if (!closestSiren.func_70089_S() || entity.func_70032_d((Entity)closestSiren) > 64.0f || sirenProps.getSiren(event.getEntityLiving().field_70170_p) == null || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_()) {
                    sirenProps.isCharmed = false;
                    sirenProps.sirenID = 0;
                    sirenProps.singTime = 0;
                }
            }
        }
        if (event.getEntityLiving() instanceof LivingEntity) {
            boolean stonePlayer = event.getEntityLiving() instanceof EntityStoneStatue;
            StoneEntityProperties properties2 = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), StoneEntityProperties.class);
            if (properties2 != null && properties2.isStone() || stonePlayer) {
                LivingEntity living = event.getEntityLiving();
                if (!living.func_184188_bt().isEmpty()) {
                    for (Entity e : living.func_184188_bt()) {
                        e.func_184210_p();
                    }
                }
                living.func_213317_d(living.func_213322_ci().func_216372_d(0.0, 0.0, 0.0));
                living.func_213317_d(living.func_213322_ci().func_72441_c(0.0, -0.1, 0.0));
                living.field_70733_aJ = 0.0f;
                living.field_184619_aG = 0.0f;
                if (living.field_70170_p.field_72995_K) {
                    living.func_82142_c(!stonePlayer);
                }
                living.field_70737_aN = 0;
                living.func_174810_b(true);
                living.getClass();
                living.field_70172_ad = 20 - 1;
                living.func_70066_B();
                if (living instanceof AnimalEntity) {
                    ((AnimalEntity)living).func_70875_t();
                }
                if (living instanceof MobEntity) {
                    MobEntity mob = (MobEntity)living;
                    if (!mob.func_175446_cd()) {
                        mob.func_94061_f(true);
                    }
                    if (mob.func_70638_az() != null) {
                        mob.func_70624_b(null);
                    }
                }
                if (living instanceof AbstractHorseEntity) {
                    AbstractHorseEntity horse = (AbstractHorseEntity)living;
                    horse.field_110278_bp = 0;
                    horse.func_110227_p(false);
                }
            }
        }
        if ((properties = (MiscEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), MiscEntityProperties.class)) != null && properties.entitiesWeAreGlaringAt.size() > 0) {
            Iterator<Entity> itr = properties.entitiesWeAreGlaringAt.iterator();
            while (itr.hasNext()) {
                Entity next = itr.next();
                double d5 = 80.0;
                double d0 = next.func_226277_ct_() - event.getEntityLiving().func_226277_ct_();
                double d1 = next.func_226278_cu_() + (double)(next.func_213302_cg() * 0.5f) - (event.getEntityLiving().func_226278_cu_() + (double)event.getEntityLiving().func_70047_e() * 0.5);
                double d2 = next.func_226281_cx_() - event.getEntityLiving().func_226281_cx_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d0 /= d3;
                d1 /= d3;
                d2 /= d3;
                double d4 = this.rand.nextDouble();
                while (d4 < d3) {
                    event.getEntityLiving().field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, event.getEntityLiving().func_226277_ct_() + d0 * (d4 += 1.0), event.getEntityLiving().func_226278_cu_() + d1 * d4 + (double)event.getEntityLiving().func_70047_e() * 0.5, event.getEntityLiving().func_226281_cx_() + d2 * d4, 0.0, 0.0, 0.0);
                }
                ((LivingEntity)next).func_195064_c(new EffectInstance(Effects.field_82731_v, 40, 2));
                if (event.getEntityLiving().field_70173_aa % 20 == 0) {
                    ++properties.specialWeaponDmg;
                    next.func_70097_a(DamageSource.field_82727_n, 2.0f);
                }
                if (next != null && next.func_70089_S()) continue;
                itr.remove();
            }
        }
        if (properties != null && properties.glarers.size() > 0) {
            Iterator<Entity> itr = properties.glarers.iterator();
            while (itr.hasNext()) {
                Entity next = itr.next();
                if (!(next instanceof LivingEntity) || EntityGorgon.isEntityLookingAt((LivingEntity)next, event.getEntityLiving(), 0.2f)) continue;
                MiscEntityProperties theirProperties = (MiscEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(next, MiscEntityProperties.class);
                theirProperties.entitiesWeAreGlaringAt.remove(event.getEntityLiving());
                itr.remove();
            }
        }
        if (properties != null && properties.inLoveTicks > 0) {
            --properties.inLoveTicks;
            if (event.getEntityLiving() instanceof MobEntity) {
                ((MobEntity)event.getEntityLiving()).func_70624_b(null);
            }
            if (this.rand.nextInt(7) == 0) {
                for (int i = 0; i < 5; ++i) {
                    event.getEntityLiving().field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, event.getEntityLiving().func_226277_ct_() + (this.rand.nextDouble() - 0.5) * 3.0, event.getEntityLiving().func_226278_cu_() + (this.rand.nextDouble() - 0.5) * 3.0, event.getEntityLiving().func_226281_cx_() + (this.rand.nextDouble() - 0.5) * 3.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        ChainEntityProperties chainProperties;
        StoneEntityProperties properties;
        if (event.getTarget() instanceof LivingEntity && (properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getTarget(), StoneEntityProperties.class)) != null && properties.isStone()) {
            event.setCanceled(true);
        }
        if ((chainProperties = (ChainEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getTarget(), ChainEntityProperties.class)) != null) {
            chainProperties.updateConnectedEntities(event.getTarget());
            if (chainProperties.isChained() && chainProperties.isConnectedToEntity(event.getTarget(), (Entity)event.getPlayer())) {
                chainProperties.removeChain(event.getTarget(), (Entity)event.getPlayer());
                if (!event.getWorld().field_72995_K) {
                    event.getTarget().func_199702_a((IItemProvider)IafItemRegistry.CHAIN, 1);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        StoneEntityProperties properties;
        if (event.getTarget() instanceof LivingEntity && (properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getTarget(), StoneEntityProperties.class)) != null && properties.isStone()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getPlayer() != null && event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof AbstractChestBlock) {
            float dist = IafConfig.dragonGoldSearchLength;
            List list = event.getWorld().func_72839_b((Entity)event.getPlayer(), event.getPlayer().func_174813_aQ().func_72321_a((double)dist, (double)dist, (double)dist));
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    EntityDragonBase dragon;
                    if (!(entity instanceof EntityDragonBase) || (dragon = (EntityDragonBase)entity).func_70909_n() || dragon.isModelDead() || dragon.func_152114_e((LivingEntity)event.getPlayer()) || event.getPlayer().func_184812_l_()) continue;
                    dragon.setSleeping(false);
                    dragon.func_70904_g(false);
                    dragon.func_70624_b((LivingEntity)event.getPlayer());
                }
            }
        }
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof WallBlock) {
            ItemChain.attachToFence(event.getPlayer(), event.getWorld(), event.getPos());
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && (event.getState().func_177230_c() instanceof AbstractChestBlock || event.getState().func_177230_c() == IafBlockRegistry.GOLD_PILE || event.getState().func_177230_c() == IafBlockRegistry.SILVER_PILE || event.getState().func_177230_c() == IafBlockRegistry.COPPER_PILE)) {
            float dist = IafConfig.dragonGoldSearchLength;
            List list = event.getWorld().func_72839_b((Entity)event.getPlayer(), event.getPlayer().func_174813_aQ().func_72321_a((double)dist, (double)dist, (double)dist));
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    EntityDragonBase dragon;
                    if (!(entity instanceof EntityDragonBase) || (dragon = (EntityDragonBase)entity).func_70909_n() || dragon.isModelDead() || dragon.func_152114_e((LivingEntity)event.getPlayer()) || event.getPlayer().func_184812_l_()) continue;
                    dragon.setSleeping(false);
                    dragon.func_70904_g(false);
                    dragon.func_70624_b((LivingEntity)event.getPlayer());
                }
            }
        }
    }

    @SubscribeEvent
    public void onChestGenerated(LootTableLoadEvent event) {
        LootPool.Builder builder;
        StandaloneLootEntry.Builder item;
        if (event.getName().equals((Object)LootTables.field_186422_d) || event.getName().equals((Object)LootTables.field_186424_f) || event.getName().equals((Object)LootTables.field_186429_k) || event.getName().equals((Object)LootTables.field_186430_l) || event.getName().equals((Object)LootTables.field_186428_j) || event.getName().equals((Object)LootTables.field_186427_i) || event.getName().equals((Object)LootTables.field_215817_h)) {
            item = ItemLootEntry.func_216168_a((IItemProvider)IafItemRegistry.MANUSCRIPT).func_216085_b(20).func_216086_a(5);
            builder = new LootPool.Builder().name("iaf_manuscript").func_216045_a((LootEntry.Builder)item).func_212840_b_(RandomChance.func_216004_a((float)0.35f)).func_216046_a((IRandomRange)new RandomValueRange(1.0f, 4.0f)).bonusRolls(0.0f, 3.0f);
            event.getTable().addPool(builder.func_216044_b());
        }
        if (IafConfig.generateSilverOre && (event.getName().equals((Object)LootTables.field_186422_d) || event.getName().equals((Object)LootTables.field_186424_f) || event.getName().equals((Object)LootTables.field_186429_k) || event.getName().equals((Object)LootTables.field_186430_l) || event.getName().equals((Object)LootTables.field_186428_j) || event.getName().equals((Object)LootTables.field_186427_i) || event.getName().equals((Object)LootTables.field_186431_m) || event.getName().equals((Object)LootTables.field_191192_o) || event.getName().equals((Object)LootTables.field_215815_f) || event.getName().equals((Object)LootTables.field_215816_g))) {
            item = ItemLootEntry.func_216168_a((IItemProvider)IafItemRegistry.SILVER_INGOT).func_216085_b(15).func_216086_a(12);
            builder = new LootPool.Builder().name("iaf_silver_ingot").func_216045_a((LootEntry.Builder)item).func_212840_b_(RandomChance.func_216004_a((float)0.5f)).func_216046_a((IRandomRange)new RandomValueRange(1.0f, 3.0f)).bonusRolls(0.0f, 2.0f);
            event.getTable().addPool(builder.func_216044_b());
        }
        if (IafConfig.generateCopperOre && (event.getName().equals((Object)LootTables.field_186422_d) || event.getName().equals((Object)LootTables.field_186424_f) || event.getName().equals((Object)LootTables.field_186429_k) || event.getName().equals((Object)LootTables.field_186430_l) || event.getName().equals((Object)LootTables.field_186428_j) || event.getName().equals((Object)LootTables.field_186427_i) || event.getName().equals((Object)LootTables.field_186431_m) || event.getName().equals((Object)LootTables.field_191192_o) || event.getName().equals((Object)LootTables.field_215815_f) || event.getName().equals((Object)LootTables.field_215816_g))) {
            item = ItemLootEntry.func_216168_a((IItemProvider)IafItemRegistry.COPPER_INGOT).func_216085_b(10).func_216086_a(14);
            builder = new LootPool.Builder().name("iaf_copper_ingot").func_216045_a((LootEntry.Builder)item).func_212840_b_(RandomChance.func_216004_a((float)0.6f)).func_216046_a((IRandomRange)new RandomValueRange(1.0f, 2.0f)).bonusRolls(0.0f, 3.0f);
            event.getTable().addPool(builder.func_216044_b());
        }
        if (event.getName().equals((Object)WorldGenFireDragonCave.FIREDRAGON_CHEST) || event.getName().equals((Object)WorldGenFireDragonCave.FIREDRAGON_MALE_CHEST) || event.getName().equals((Object)WorldGenIceDragonCave.ICEDRAGON_CHEST) || event.getName().equals((Object)WorldGenIceDragonCave.ICEDRAGON_MALE_CHEST)) {
            item = ItemLootEntry.func_216168_a((IItemProvider)IafItemRegistry.WEEZER_BLUE_ALBUM).func_216085_b(100).func_216086_a(1);
            builder = new LootPool.Builder().name("iaf_weezer").func_216045_a((LootEntry.Builder)item).func_212840_b_(RandomChance.func_216004_a((float)0.01f)).func_216046_a((IRandomRange)new RandomValueRange(1.0f, 1.0f)).bonusRolls(0.0f, 0.0f);
            event.getTable().addPool(builder.func_216044_b());
        }
    }

    @SubscribeEvent
    public void onPlayerLeaveEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getPlayer() != null && !event.getPlayer().func_184188_bt().isEmpty()) {
            Iterator itr = event.getPlayer().func_184188_bt().iterator();
            while (itr.hasNext()) {
                ((Entity)itr.next()).func_184210_p();
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(LivingSpawnEvent.SpecialSpawn event) {
        try {
            AnimalEntity animal;
            if (event.getEntity() instanceof LivingEntity) {
                try {
                    ChainEntityProperties properties = (ChainEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), ChainEntityProperties.class);
                    if (properties != null) {
                        properties.updateConnectedEntities(event.getEntity());
                    }
                }
                catch (Exception e) {
                    IceAndFire.LOGGER.warn("could not instantiate chain properties for " + event.getEntity().func_200200_C_());
                }
            }
            if (event.getEntity() != null && ServerEvents.isAnimaniaSheep(event.getEntity()) && event.getEntity() instanceof AnimalEntity) {
                animal = (AnimalEntity)event.getEntity();
                animal.field_70714_bg.func_75776_a(8, (Goal)new EntitySheepAIFollowCyclops(animal, 1.2));
            }
            if (event.getEntity() != null && ServerEvents.isVillager(event.getEntity()) && event.getEntity() instanceof MobEntity && IafConfig.villagersFearDragons) {
                MobEntity villager = (MobEntity)event.getEntity();
                villager.field_70714_bg.func_75776_a(1, (Goal)new VillagerAIFearUntamed((CreatureEntity)villager, LivingEntity.class, 8.0f, 0.8, 0.8, (Predicate<LivingEntity>)VILLAGER_FEAR));
            }
            if (event.getEntity() != null && ServerEvents.isLivestock(event.getEntity()) && event.getEntity() instanceof MobEntity && IafConfig.animalsFearDragons) {
                animal = (MobEntity)event.getEntity();
                animal.field_70714_bg.func_75776_a(1, (Goal)new VillagerAIFearUntamed((CreatureEntity)animal, LivingEntity.class, 30.0f, 1.0, 0.5, new Predicate<LivingEntity>((MobEntity)animal){
                    final /* synthetic */ MobEntity val$animal;
                    {
                        this.val$animal = mobEntity;
                    }

                    @Override
                    public boolean test(LivingEntity entity) {
                        return entity != null && entity instanceof IAnimalFear && ((IAnimalFear)entity).shouldAnimalsFear((Entity)this.val$animal);
                    }
                }));
            }
        }
        catch (Exception e) {
            IceAndFire.LOGGER.warn("Tried to add unique behaviors to vanilla mobs and encountered an error");
        }
    }

    @SubscribeEvent
    public void onEntityDie(LivingDeathEvent event) {
        ChainEntityProperties chainProperties = (ChainEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), ChainEntityProperties.class);
        if (chainProperties != null) {
            chainProperties.minimizeLists();
            if (!event.getEntity().field_70170_p.field_72995_K) {
                ItemEntity entityitem = new ItemEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_() + 1.0, event.getEntity().func_226281_cx_(), new ItemStack((IItemProvider)IafItemRegistry.CHAIN, chainProperties.connectedEntities.size()));
                entityitem.func_174869_p();
                event.getEntity().field_70170_p.func_217376_c((Entity)entityitem);
            }
            chainProperties.clearChained();
        }
        if (event.getEntityLiving().func_110124_au().equals(ALEX_UUID)) {
            event.getEntityLiving().func_70099_a(new ItemStack((IItemProvider)IafItemRegistry.WEEZER_BLUE_ALBUM), 1.0f);
        }
        if (event.getEntityLiving() instanceof PlayerEntity && IafConfig.ghostsFromPlayerDeaths) {
            CombatTracker combat = event.getEntityLiving().func_110142_aN();
            LivingEntity attacker = event.getEntityLiving().func_70643_av();
            if (attacker instanceof PlayerEntity && event.getEntityLiving().func_70681_au().nextInt(3) == 0) {
                boolean flag = false;
                if (event.getSource() == DamageSource.field_76379_h || event.getSource() == DamageSource.field_76369_e || event.getSource() == DamageSource.field_76371_c) {
                    flag = true;
                }
                if (event.getEntityLiving().func_70644_a(Effects.field_76436_u)) {
                    flag = true;
                }
                World world = event.getEntityLiving().field_70170_p;
                if (flag) {
                    EntityGhost ghost = (EntityGhost)IafEntityRegistry.GHOST.func_200721_a(world);
                    ghost.func_82149_j((Entity)event.getEntityLiving());
                    ghost.func_213386_a((IWorld)world, world.func_175649_E(event.getEntityLiving().func_180425_c()), SpawnReason.SPAWNER, null, null);
                    if (!world.field_72995_K) {
                        world.func_217376_c((Entity)ghost);
                    }
                    ghost.setDaytimeMode(true);
                }
            }
        }
    }
}

