/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityJar;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdatePixieJar {
    public long blockPos;
    public boolean isProducing;

    public MessageUpdatePixieJar(long blockPos, boolean isProducing) {
        this.blockPos = blockPos;
        this.isProducing = isProducing;
    }

    public MessageUpdatePixieJar() {
    }

    public static MessageUpdatePixieJar read(PacketBuffer buf) {
        return new MessageUpdatePixieJar(buf.readLong(), buf.readBoolean());
    }

    public static void write(MessageUpdatePixieJar message, PacketBuffer buf) {
        buf.writeLong(message.blockPos);
        buf.writeBoolean(message.isProducing);
    }

    public static class Handler {
        public static void handle(MessageUpdatePixieJar message, Supplier<NetworkEvent.Context> context) {
            BlockPos pos;
            context.get().setPacketHandled(true);
            ServerPlayerEntity player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IceAndFire.PROXY.getClientSidePlayer();
            }
            if (player != null && player.field_70170_p != null && player.field_70170_p.func_175625_s(pos = BlockPos.func_218283_e((long)message.blockPos)) != null && player.field_70170_p.func_175625_s(pos) instanceof TileEntityJar) {
                TileEntityJar jar = (TileEntityJar)player.field_70170_p.func_175625_s(pos);
                jar.hasProduced = message.isProducing;
            }
        }
    }
}

