/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import com.github.alexthe666.iceandfire.IceAndFire;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class DragonPosWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "iceandfire_dragonPositions";
    protected final Map<UUID, BlockPos> lastDragonPositions = new HashMap<UUID, BlockPos>();
    private World world;
    private int tickCounter;

    public DragonPosWorldData() {
        super(IDENTIFIER);
    }

    public DragonPosWorldData(World world) {
        super(IDENTIFIER);
        this.world = world;
        this.func_76185_a();
    }

    public static DragonPosWorldData get(World world) {
        if (world instanceof ServerWorld) {
            ServerWorld overworld = world.func_73046_m().func_71218_a(DimensionType.field_223227_a_);
            DimensionSavedDataManager storage = overworld.func_217481_x();
            DragonPosWorldData data = (DragonPosWorldData)storage.func_215752_a(DragonPosWorldData::new, IDENTIFIER);
            if (data != null) {
                data.world = world;
                data.func_76185_a();
            }
            return data;
        }
        return null;
    }

    public void addDragon(UUID uuid, BlockPos pos) {
        this.lastDragonPositions.put(uuid, pos);
        this.func_76185_a();
    }

    public void removeDragon(UUID uuid) {
        this.lastDragonPositions.remove(uuid);
        this.func_76185_a();
    }

    public BlockPos getDragonPos(UUID uuid) {
        return this.lastDragonPositions.get(uuid);
    }

    public void debug() {
        IceAndFire.LOGGER.warn(this.lastDragonPositions.toString());
    }

    public void tick() {
        ++this.tickCounter;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.tickCounter = nbt.func_74762_e("Tick");
        ListNBT nbttaglist = nbt.func_150295_c("DragonMap", 10);
        this.lastDragonPositions.clear();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundNBT CompoundNBT2 = nbttaglist.func_150305_b(i);
            UUID uuid = CompoundNBT2.func_186857_a("DragonUUID");
            BlockPos pos = new BlockPos(CompoundNBT2.func_74762_e("DragonPosX"), CompoundNBT2.func_74762_e("DragonPosY"), CompoundNBT2.func_74762_e("DragonPosZ"));
            this.lastDragonPositions.put(uuid, pos);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74768_a("Tick", this.tickCounter);
        ListNBT nbttaglist = new ListNBT();
        for (Map.Entry<UUID, BlockPos> pair : this.lastDragonPositions.entrySet()) {
            CompoundNBT CompoundNBT2 = new CompoundNBT();
            CompoundNBT2.func_186854_a("DragonUUID", pair.getKey());
            CompoundNBT2.func_74768_a("DragonPosX", pair.getValue().func_177958_n());
            CompoundNBT2.func_74768_a("DragonPosY", pair.getValue().func_177956_o());
            CompoundNBT2.func_74768_a("DragonPosZ", pair.getValue().func_177952_p());
            nbttaglist.add((Object)CompoundNBT2);
        }
        compound.func_218657_a("DragonMap", (INBT)nbttaglist);
        return compound;
    }
}

