/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.world.gen.processor.DreadRuinProcessor;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class WorldGenDreadRuin
extends Feature<NoFeatureConfig> {
    private static final ResourceLocation STRUCTURE_0 = new ResourceLocation("iceandfire", "dread_ruin_0");
    private static final ResourceLocation STRUCTURE_1 = new ResourceLocation("iceandfire", "dread_ruin_1");
    private static final ResourceLocation STRUCTURE_2 = new ResourceLocation("iceandfire", "dread_ruin_2");
    private static final ResourceLocation STRUCTURE_3 = new ResourceLocation("iceandfire", "dread_ruin_3");
    private static final ResourceLocation STRUCTURE_4 = new ResourceLocation("iceandfire", "dread_ruin_4");
    private static final ResourceLocation STRUCTURE_5 = new ResourceLocation("iceandfire", "dread_ruin_5");
    private static final ResourceLocation STRUCTURE_6 = new ResourceLocation("iceandfire", "dread_ruin_6");
    private static final ResourceLocation STRUCTURE_7 = new ResourceLocation("iceandfire", "dread_ruin_7");
    private static final ResourceLocation STRUCTURE_8 = new ResourceLocation("iceandfire", "dread_ruin_8");
    private static final ResourceLocation STRUCTURE_9 = new ResourceLocation("iceandfire", "dread_ruin_9");
    private static final ResourceLocation STRUCTURE_10 = new ResourceLocation("iceandfire", "dread_ruin_10");
    private static final ResourceLocation STRUCTURE_11 = new ResourceLocation("iceandfire", "dread_ruin_11");
    private static final ResourceLocation STRUCTURE_12 = new ResourceLocation("iceandfire", "dread_ruin_12");
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public WorldGenDreadRuin(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public static Rotation getRotationFromFacing(Direction facing) {
        switch (facing) {
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    private ResourceLocation getRandomStructure(Random rand) {
        switch (rand.nextInt(11)) {
            case 0: {
                return STRUCTURE_0;
            }
            case 1: {
                return STRUCTURE_1;
            }
            case 2: {
                return STRUCTURE_2;
            }
            case 3: {
                return STRUCTURE_3;
            }
            case 4: {
                return STRUCTURE_4;
            }
            case 5: {
                return STRUCTURE_5;
            }
            case 6: {
                return STRUCTURE_6;
            }
            case 7: {
                return STRUCTURE_7;
            }
            case 8: {
                return STRUCTURE_8;
            }
            case 9: {
                return STRUCTURE_9;
            }
            case 10: {
                return STRUCTURE_10;
            }
            case 11: {
                return STRUCTURE_11;
            }
            case 12: {
                return STRUCTURE_12;
            }
        }
        return STRUCTURE_0;
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos position, NoFeatureConfig config) {
        ResourceLocation structure = this.getRandomStructure(rand);
        Direction facing = HORIZONTALS[rand.nextInt(3)];
        MinecraftServer server = worldIn.func_201672_e().func_73046_m();
        Biome biome = worldIn.func_226691_t_(position);
        TemplateManager templateManager = server.func_71218_a(worldIn.func_201675_m().func_186058_p()).func_184163_y();
        PlacementSettings settings = new PlacementSettings().func_186220_a(WorldGenDreadRuin.getRotationFromFacing(facing)).func_215222_a((StructureProcessor)new DreadRuinProcessor());
        Template template = templateManager.func_200219_b(structure);
        BlockPos genPos = position.func_177967_a(facing, template.func_186259_a().func_177952_p() / 2).func_177967_a(facing.func_176735_f(), template.func_186259_a().func_177958_n() / 2);
        template.func_189962_a(worldIn, genPos, settings, 2);
        return false;
    }
}

