/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen.processor;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DreadRuinProcessor
extends StructureProcessor {
    public static final ResourceLocation DREAD_CHEST_LOOT = new ResourceLocation("iceandfire", "chest/mausoleum_chest");
    private float integrity = 1.0f;

    public static BlockState getRandomCrackedBlock(@Nullable BlockState prev, Random random) {
        float rand = random.nextFloat();
        if ((double)rand < 0.5) {
            return IafBlockRegistry.DREAD_STONE_BRICKS.func_176223_P();
        }
        if ((double)rand < 0.9) {
            return IafBlockRegistry.DREAD_STONE_BRICKS_CRACKED.func_176223_P();
        }
        return IafBlockRegistry.DREAD_STONE_BRICKS_MOSSY.func_176223_P();
    }

    public Template.BlockInfo func_215194_a(IWorldReader worldReader, BlockPos pos, Template.BlockInfo infoIn1, Template.BlockInfo infoIn2, PlacementSettings settings) {
        Random random = settings.func_189947_a(infoIn2.field_186242_a);
        if (random.nextFloat() <= this.integrity) {
            if (infoIn2.field_186243_b.func_177230_c() == IafBlockRegistry.DREAD_STONE_BRICKS) {
                BlockState state = DreadRuinProcessor.getRandomCrackedBlock(null, random);
                return new Template.BlockInfo(infoIn2.field_186242_a, state, null);
            }
            if (infoIn2.field_186243_b.func_177230_c() instanceof AbstractChestBlock) {
                ResourceLocation loot = DREAD_CHEST_LOOT;
                CompoundNBT tag = new CompoundNBT();
                tag.func_74778_a("LootTable", loot.toString());
                tag.func_74772_a("LootTableSeed", random.nextLong());
                Template.BlockInfo newInfo = new Template.BlockInfo(infoIn2.field_186242_a, Blocks.field_150486_ae.func_176223_P(), tag);
                return newInfo;
            }
            if (infoIn2.field_186243_b.func_177230_c() == IafBlockRegistry.DREAD_SPAWNER) {
                CompoundNBT tag = new CompoundNBT();
                CompoundNBT spawnData = new CompoundNBT();
                ResourceLocation spawnerMobId = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)this.getRandomMobForMobSpawner(random));
                if (spawnerMobId != null) {
                    spawnData.func_74778_a("id", spawnerMobId.toString());
                    tag.func_82580_o("SpawnPotentials");
                    tag.func_218657_a("SpawnData", (INBT)spawnData.func_74737_b());
                }
                Template.BlockInfo newInfo = new Template.BlockInfo(infoIn2.field_186242_a, IafBlockRegistry.DREAD_SPAWNER.func_176223_P(), tag);
                return newInfo;
            }
            return infoIn2;
        }
        return infoIn2;
    }

    protected IStructureProcessorType func_215192_a() {
        return IStructureProcessorType.field_214921_c;
    }

    protected <T> Dynamic<T> func_215193_a(DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("dread_ruin_processor"), (Object)ops.createFloat(this.integrity))));
    }

    private EntityType getRandomMobForMobSpawner(Random random) {
        float rand = random.nextFloat();
        if ((double)rand < 0.3) {
            return IafEntityRegistry.DREAD_THRALL;
        }
        if ((double)rand < 0.5) {
            return IafEntityRegistry.DREAD_GHOUL;
        }
        if ((double)rand < 0.7) {
            return IafEntityRegistry.DREAD_BEAST;
        }
        if ((double)rand < 0.85) {
            return IafEntityRegistry.DREAD_SCUTTLER;
        }
        return IafEntityRegistry.DREAD_KNIGHT;
    }
}

