/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen.processor;

import com.github.alexthe666.iceandfire.block.BlockGhostChest;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class GraveyardProcessor
extends StructureProcessor {
    public static final ResourceLocation GRAVEYARD_CHEST_LOOT = new ResourceLocation("iceandfire", "chest/graveyard");
    private float integrity = 1.0f;

    public static BlockState getRandomCobblestone(@Nullable BlockState prev, Random random) {
        float rand = random.nextFloat();
        if ((double)rand < 0.5) {
            return Blocks.field_150347_e.func_176223_P();
        }
        if ((double)rand < 0.9) {
            return Blocks.field_150341_Y.func_176223_P();
        }
        return Blocks.field_196687_dd.func_176223_P();
    }

    public static BlockState getRandomCrackedBlock(@Nullable BlockState prev, Random random) {
        float rand = random.nextFloat();
        if ((double)rand < 0.5) {
            return Blocks.field_196696_di.func_176223_P();
        }
        if ((double)rand < 0.9) {
            return Blocks.field_196700_dk.func_176223_P();
        }
        return Blocks.field_196698_dj.func_176223_P();
    }

    public Template.BlockInfo func_215194_a(IWorldReader worldReader, BlockPos pos, Template.BlockInfo infoIn1, Template.BlockInfo infoIn2, PlacementSettings settings) {
        Random random = settings.func_189947_a(infoIn2.field_186242_a);
        if (infoIn2.field_186243_b.func_177230_c() == Blocks.field_196696_di) {
            BlockState state = GraveyardProcessor.getRandomCrackedBlock(null, random);
            return new Template.BlockInfo(infoIn2.field_186242_a, state, null);
        }
        if (infoIn2.field_186243_b.func_177230_c() == Blocks.field_150347_e) {
            BlockState state = GraveyardProcessor.getRandomCobblestone(null, random);
            return new Template.BlockInfo(infoIn2.field_186242_a, state, null);
        }
        if (infoIn2.field_186243_b.func_177230_c() == IafBlockRegistry.GHOST_CHEST) {
            ResourceLocation loot = GRAVEYARD_CHEST_LOOT;
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("LootTable", loot.toString());
            tag.func_74772_a("LootTableSeed", random.nextLong());
            Direction facing = (Direction)infoIn2.field_186243_b.func_177229_b((IProperty)BlockGhostChest.field_176459_a);
            Template.BlockInfo newInfo = new Template.BlockInfo(infoIn2.field_186242_a, (BlockState)IafBlockRegistry.GHOST_CHEST.func_176223_P().func_206870_a((IProperty)BlockGhostChest.field_176459_a, (Comparable)facing), tag);
            return newInfo;
        }
        return infoIn2;
    }

    protected IStructureProcessorType func_215192_a() {
        return IStructureProcessorType.field_214921_c;
    }

    protected <T> Dynamic<T> func_215193_a(DynamicOps<T> ops) {
        return null;
    }

    private EntityType getRandomMobForMobSpawner(Random random) {
        float rand = random.nextFloat();
        if ((double)rand < 0.3) {
            return IafEntityRegistry.DREAD_THRALL;
        }
        if ((double)rand < 0.5) {
            return IafEntityRegistry.DREAD_GHOUL;
        }
        if ((double)rand < 0.7) {
            return IafEntityRegistry.DREAD_BEAST;
        }
        if ((double)rand < 0.85) {
            return IafEntityRegistry.DREAD_SCUTTLER;
        }
        return IafEntityRegistry.DREAD_KNIGHT;
    }
}

